/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MapDeserializer
extends DeserializerImpl
implements Deserializer {
    protected static Log log;
    public static final Object KEYHINT;
    public static final Object VALHINT;
    public static final Object NILHINT;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.ser.MapDeserializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        KEYHINT = new Object();
        VALHINT = new Object();
        NILHINT = new Object();
    }

    public void onStartElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "MapDeserializer.startElement()"));
        }
        if (attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil") != null) {
            return;
        }
        this.setValue(new HashMap());
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "MapDeserializer.startElement()"));
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "MapDeserializer.onStartChild()"));
        }
        if (!localName.equals("item")) {
            throw new SAXException(JavaUtils.getMessage("itemInMap00"));
        }
        return new ItemHandler(this);
    }

    public void setValue(Object value, Object hint) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("gotValue00", "MapDeserializer", "" + value));
        }
        ((Map)this.value).put(hint, value);
    }

    class ItemHandler
    extends DeserializerImpl
    implements Deserializer {
        Object key;
        Object myValue;
        int numSet = 0;
        MapDeserializer md = null;

        ItemHandler(MapDeserializer md) {
            this.md = md;
        }

        public void setValue(Object val, Object hint) throws SAXException {
            if (hint == KEYHINT) {
                this.key = val;
            } else if (hint == VALHINT) {
                this.myValue = val;
            } else if (hint != NILHINT) {
                return;
            }
            ++this.numSet;
            if (this.numSet == 2) {
                this.md.setValue(this.myValue, this.key);
            }
        }

        public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
            QName typeQName = context.getTypeFromAttributes(namespace, localName, attributes);
            Deserializer dser = context.getDeserializerForType(typeQName);
            if (dser == null) {
                dser = new DeserializerImpl();
            }
            DeserializerTarget dt = null;
            if (context.isNil(attributes)) {
                dt = new DeserializerTarget(this, NILHINT);
            } else if (localName.equals("key")) {
                dt = new DeserializerTarget(this, KEYHINT);
            } else if (localName.equals("value")) {
                dt = new DeserializerTarget(this, VALHINT);
            }
            if (dt != null) {
                dser.registerValueTarget(dt);
            }
            return (SOAPHandler)((Object)dser);
        }
    }
}

