/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanPropertyDescriptor;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleDeserializer
extends DeserializerImpl {
    StringBuffer val = new StringBuffer();
    private Constructor constructor = null;
    private BeanPropertyDescriptor[] pd = null;
    private HashMap propertyMap = new HashMap();
    private HashMap attributeMap = null;
    public QName xmlType;
    public Class javaType;
    private TypeDesc typeDesc = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public SimpleDeserializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.SimpleType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(javaType)) {
            this.pd = BeanSerializer.getPd(javaType);
            int i = 0;
            while (i < this.pd.length) {
                BeanPropertyDescriptor descriptor = this.pd[i];
                this.propertyMap.put(descriptor.getName(), descriptor);
                ++i;
            }
            this.typeDesc = TypeDesc.getTypeDescForClass(javaType);
        }
    }

    public void setConstructor(Constructor c) {
        this.constructor = c;
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        throw new SAXException(JavaUtils.getMessage("cantHandle00", "SimpleDeser"));
    }

    public void characters(char[] chars, int start, int end) throws SAXException {
        this.val.append(chars, start, end);
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.isNil) {
            this.value = null;
            return;
        }
        try {
            this.value = this.makeValue(this.val.toString());
        }
        catch (InvocationTargetException ite) {
            Throwable realException = ite.getTargetException();
            if (realException instanceof Exception) {
                throw new SAXException((Exception)realException);
            }
            throw new SAXException(ite.getMessage());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.setSimpleTypeAttributes();
    }

    public Object makeValue(String source) throws Exception {
        block36: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                if (this.javaType == Boolean.TYPE) break block31;
                                Class<?> clazz = class$2;
                                if (clazz == null) {
                                    try {
                                        clazz = class$2 = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (!clazz.isAssignableFrom(this.javaType)) break block32;
                            }
                            switch (source.charAt(0)) {
                                case '0': 
                                case 'F': 
                                case 'f': {
                                    return Boolean.FALSE;
                                }
                                case '1': 
                                case 'T': 
                                case 't': {
                                    return Boolean.TRUE;
                                }
                            }
                            throw new NumberFormatException(JavaUtils.getMessage("badBool00"));
                        }
                        if (this.javaType == Float.TYPE) break block33;
                        Class<?> clazz = class$4;
                        if (clazz == null) {
                            try {
                                clazz = class$4 = Class.forName("java.lang.Float");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (this.javaType != clazz) break block34;
                    }
                    if (source.equals("NaN")) {
                        return new Float(Float.NaN);
                    }
                    if (source.equals("INF")) {
                        return new Float(Float.POSITIVE_INFINITY);
                    }
                    if (source.equals("-INF")) {
                        return new Float(Float.NEGATIVE_INFINITY);
                    }
                }
                if (this.javaType == Double.TYPE) break block35;
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.javaType != clazz) break block36;
            }
            if (source.equals("NaN")) {
                return new Double(Double.NaN);
            }
            if (source.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (source.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        return this.constructor.newInstance(source);
    }

    public void onStartElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        if (this.typeDesc == null) {
            return;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName != null) {
                String attrName = attributes.getLocalName(i);
                BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
                if (bpd != null && bpd.getWriteMethod() != null) {
                    Class type;
                    TypeMapping tm = context.getTypeMapping();
                    QName qn = tm.getTypeQName(type = bpd.getType());
                    if (qn == null) {
                        throw new SAXException(JavaUtils.getMessage("unregistered00", type.toString()));
                    }
                    Deserializer dSer = context.getDeserializerForType(qn);
                    if (dSer == null) {
                        throw new SAXException(JavaUtils.getMessage("noDeser00", type.toString()));
                    }
                    if (!(dSer instanceof SimpleDeserializer)) {
                        throw new SAXException(JavaUtils.getMessage("AttrNotSimpleType00", bpd.getName(), type.toString()));
                    }
                    if (bpd.getWriteMethod().getParameterTypes().length == 1) {
                        if (this.attributeMap == null) {
                            this.attributeMap = new HashMap();
                        }
                        try {
                            Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                            this.attributeMap.put(fieldName, val);
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void setSimpleTypeAttributes() throws SAXException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.SimpleType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(this.javaType) || this.attributeMap == null) {
            return;
        }
        Set keys = this.attributeMap.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Object val = this.attributeMap.get(name);
            BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)this.propertyMap.get(name);
            if (bpd.getWriteMethod() == null) continue;
            try {
                if (bpd.getWriteMethod().getParameterTypes().length != 1) continue;
                bpd.getWriteMethod().invoke(this.value, val);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }
}

