/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.ser.BeanPropertyDescriptor;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.ClassRep;
import org.apache.axis.wsdl.fromJava.FieldRep;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements Serializer {
    public QName xmlType;
    public Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private TypeDesc typeDesc = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SimpleSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.SimpleType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(javaType)) {
            this.propertyDescriptor = BeanSerializer.getPd(javaType);
            this.typeDesc = TypeDesc.getTypeDescForClass(javaType);
        }
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (value != null) {
            Class<?> clazz = value.getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                throw new IOException(JavaUtils.getMessage("cantSerialize02"));
            }
        }
        if (value instanceof SimpleType) {
            attributes = this.getObjectAttributes(value, attributes, context);
        }
        context.startElement(name, attributes);
        if (value != null) {
            if (value instanceof Float || value instanceof Double) {
                double data = 0.0;
                data = value instanceof Float ? ((Float)value).doubleValue() : ((Double)value).doubleValue();
                if (data == Double.NaN) {
                    context.writeString("NaN");
                } else if (data == Double.POSITIVE_INFINITY) {
                    context.writeString("INF");
                } else if (data == Double.NEGATIVE_INFINITY) {
                    context.writeString("-INF");
                } else {
                    context.writeString(value.toString());
                }
            } else if (value instanceof String) {
                context.writeString(XMLUtils.xmlEncodeString(value.toString()));
            } else if (value instanceof SimpleType) {
                context.writeString(value.toString());
            } else {
                context.writeString(value.toString());
            }
        }
        context.endElement();
    }

    private Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (!propName.equals("class") && (field = this.typeDesc.getFieldByName(propName)) != null && !field.isElement()) {
                    Object propValue;
                    Method readMethod;
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if ((readMethod = this.propertyDescriptor[i].getReadMethod()) != null && readMethod.getParameterTypes().length == 0 && (propValue = readMethod.invoke(value, BeanSerializer.noArgs)) != null) {
                        String propString = propValue.toString();
                        String namespace = qname.getNamespaceURI();
                        String localName = qname.getLocalPart();
                        attrs.addAttribute(namespace, localName, context.qName2String(qname), "CDATA", propString);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.SimpleType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(this.javaType)) {
            return false;
        }
        javax.wsdl.QName qName = types.getWsdlQName(this.xmlType);
        Element complexType = types.createElement("complexType");
        types.writeSchemaElement(qName, complexType);
        complexType.setAttribute("name", qName.getLocalPart());
        Element simpleContent = types.createElement("simpleContent");
        complexType.appendChild(simpleContent);
        Element extension = types.createElement("extension");
        simpleContent.appendChild(extension);
        String base = "string";
        int i = 0;
        while (i < this.propertyDescriptor.length) {
            if (this.propertyDescriptor[i].getName().equals("value")) {
                BeanPropertyDescriptor bpd = this.propertyDescriptor[i];
                Class type = bpd.getType();
                if (!types.isSimpleSchemaType(type)) {
                    throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType01", type.getName()));
                }
                base = types.writeType(type);
            }
            ++i;
        }
        extension.setAttribute("base", base);
        ClassRep clsRep = types.getBeanBuilder().build(this.javaType);
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return true;
        }
        Vector fields = clsRep.getFields();
        int i2 = 0;
        while (i2 < fields.size()) {
            FieldRep field = (FieldRep)fields.elementAt(i2);
            String fieldName = field.getName();
            FieldDesc fieldDesc = this.typeDesc.getFieldByName(field.getName());
            if (fieldDesc != null && !fieldDesc.isElement()) {
                Class fieldType = field.getType();
                if (!types.isSimpleSchemaType(fieldType)) {
                    throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType00", fieldName, fieldType.getName()));
                }
                String elementType = types.writeType(fieldType);
                Element elem = types.createAttributeElement(fieldName, elementType, false, extension.getOwnerDocument());
                extension.appendChild(elem);
            }
            ++i2;
        }
        return true;
    }
}

