/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.JWSClassLoader;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.utils.compiler.Compiler;
import org.apache.axis.utils.compiler.CompilerError;
import org.apache.axis.utils.compiler.CompilerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JWSProcessor
extends BasicHandler {
    protected static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.handlers.JWSProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        this.invokeImpl(msgContext, false);
    }

    public void invokeImpl(MessageContext msgContext, boolean doWsdl) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "JWSProcessor::invoke"));
        }
        try {
            JWSClassLoader cl;
            File outDirectory;
            Runtime rt = Runtime.getRuntime();
            String jwsFile = msgContext.getStrProp("realpath");
            String rel = msgContext.getStrProp("path");
            if (rel.charAt(0) == '/') {
                rel = rel.substring(1);
            }
            int lastSlash = rel.lastIndexOf(47);
            String dir = null;
            if (lastSlash > 0) {
                dir = rel.substring(0, lastSlash);
            }
            String file = rel.substring(lastSlash + 1);
            String outdir = msgContext.getStrProp("jws.classDir");
            if (outdir == null) {
                outdir = ".";
            }
            if (dir != null) {
                outdir = String.valueOf(outdir) + File.separator + dir;
            }
            if (!(outDirectory = new File(outdir)).exists()) {
                outDirectory.mkdirs();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("jwsFile: " + jwsFile));
            }
            String jFile = String.valueOf(outdir) + File.separator + file.substring(0, file.length() - 3) + "java";
            String cFile = String.valueOf(outdir) + File.separator + file.substring(0, file.length() - 3) + "class";
            if (log.isDebugEnabled()) {
                log.debug((Object)("jFile: " + jFile));
                log.debug((Object)("cFile: " + cFile));
                log.debug((Object)("outdir: " + outdir));
            }
            File f1 = new File(cFile);
            File f2 = new File(jwsFile);
            String clsName = null;
            if (clsName == null) {
                clsName = f2.getName();
            }
            if (clsName != null && clsName.charAt(0) == '/') {
                clsName = clsName.substring(1);
            }
            clsName = clsName.substring(0, clsName.length() - 4);
            clsName = clsName.replace('/', '.');
            if (log.isDebugEnabled()) {
                log.debug((Object)("ClsName: " + clsName));
            }
            if (!f1.exists() || f2.lastModified() > f1.lastModified()) {
                int rc;
                log.debug((Object)JavaUtils.getMessage("compiling00", jwsFile));
                log.debug((Object)JavaUtils.getMessage("copy00", jwsFile, jFile));
                FileReader fr = new FileReader(jwsFile);
                FileWriter fw = new FileWriter(jFile);
                char[] buf = new char[4096];
                while ((rc = fr.read(buf, 0, 4095)) >= 0) {
                    fw.write(buf, 0, rc);
                }
                fw.close();
                fr.close();
                log.debug((Object)("javac " + jFile));
                Compiler compiler = CompilerFactory.getCompiler();
                Object args = null;
                compiler.setClasspath(this.getDefaultClasspath(msgContext));
                compiler.setDestination(outdir);
                compiler.setFile(jFile);
                boolean result = compiler.compile();
                new File(jFile).delete();
                if (!result) {
                    new File(cFile).delete();
                    Document doc = XMLUtils.newDocument();
                    Element root = doc.createElementNS("", "Errors");
                    StringBuffer message = new StringBuffer("Error compiling ");
                    message.append(jFile);
                    message.append(":\n");
                    List errors = compiler.getErrors();
                    int count = errors.size();
                    int i = 0;
                    while (i < count) {
                        CompilerError error = (CompilerError)errors.get(i);
                        if (i > 0) {
                            message.append("\n");
                        }
                        message.append("Line ");
                        message.append(error.getStartLine());
                        message.append(", column ");
                        message.append(error.getStartColumn());
                        message.append(": ");
                        message.append(error.getMessage());
                        ++i;
                    }
                    root.appendChild(doc.createTextNode(message.toString()));
                    throw new AxisFault("Server.compileError", JavaUtils.getMessage("badCompile00", jFile), null, new Element[]{root});
                }
                JWSClassLoader.removeClassLoader(clsName);
            }
            if ((cl = JWSClassLoader.getClassLoader(clsName)) == null) {
                cl = new JWSClassLoader(clsName, msgContext.getClassLoader(), cFile);
            }
            msgContext.setClassLoader(cl);
            SOAPService rpc = new SOAPService(new RPCProvider());
            msgContext.setService(rpc);
            rpc.setOption("className", clsName);
            rpc.setOption("allowedMethods", "*");
            rpc.init();
            if (doWsdl) {
                rpc.generateWSDL(msgContext);
            } else {
                rpc.invoke(msgContext);
            }
            rpc.cleanup();
        }
        catch (Exception e) {
            log.debug((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "JWSProcessor::invoke"));
        }
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        this.invokeImpl(msgContext, true);
    }

    private String getDefaultClasspath(MessageContext msgContext) {
        StringBuffer classpath = new StringBuffer();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)cl).getURLs();
                int i = 0;
                while (urls != null && i < urls.length) {
                    block18: {
                        String path = urls[i].getPath();
                        if (path.charAt(0) == '/' && path.charAt(2) == ':') {
                            path = path.substring(1);
                        }
                        classpath.append(path);
                        classpath.append(File.pathSeparatorChar);
                        File file = new File(urls[i].getFile());
                        if (file.isFile()) {
                            FileInputStream fis = null;
                            try {
                                Attributes attributes;
                                JarFile jar;
                                Manifest manifest;
                                fis = new FileInputStream(file);
                                if (JWSProcessor.isJar(fis) && (manifest = (jar = new JarFile(file)).getManifest()) != null && (attributes = manifest.getMainAttributes()) != null) {
                                    String s = attributes.getValue(Attributes.Name.CLASS_PATH);
                                    String base = file.getParent();
                                    if (s != null) {
                                        StringTokenizer st = new StringTokenizer(s, " ");
                                        while (st.hasMoreTokens()) {
                                            String t = st.nextToken();
                                            classpath.append(String.valueOf(base) + File.separatorChar + t);
                                            classpath.append(File.pathSeparatorChar);
                                        }
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                if (fis == null) break block18;
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            cl = cl.getParent();
        }
        String webBase = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION);
        if (webBase != null) {
            classpath.append(String.valueOf(webBase) + File.separatorChar + "classes" + File.pathSeparatorChar);
            try {
                String libBase = String.valueOf(webBase) + File.separatorChar + "lib";
                File libDir = new File(libBase);
                String[] jarFiles = libDir.list();
                int i = 0;
                while (i < jarFiles.length) {
                    String jarFile = jarFiles[i];
                    if (jarFile.endsWith(".jar")) {
                        classpath.append(String.valueOf(libBase) + File.separatorChar + jarFile + File.pathSeparatorChar);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (System.getProperty("sun.boot.class.path") != null) {
            classpath.append(System.getProperty("sun.boot.class.path"));
        }
        return classpath.toString();
    }

    public static boolean isJar(InputStream is) {
        try {
            JarInputStream jis = new JarInputStream(is);
            if (jis.getNextEntry() != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

