/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.StringTokenizer;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.security.AuthenticatedUser;
import org.apache.axis.security.SecurityProvider;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleAuthorizationHandler
extends BasicHandler {
    protected static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.handlers.SimpleAuthorizationHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        AuthenticatedUser user;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "SimpleAuthorizationHandler::invoke"));
        }
        boolean allowByDefault = false;
        String optVal = (String)this.getOption("allowByDefault");
        if (optVal != null && optVal.equalsIgnoreCase("true")) {
            allowByDefault = true;
        }
        if ((user = (AuthenticatedUser)msgContext.getProperty(MessageContext.AUTHUSER)) == null) {
            throw new AxisFault("Server.NoUser", JavaUtils.getMessage("needUser00"), null, null);
        }
        String userID = user.getName();
        SOAPService serviceHandler = msgContext.getService();
        if (serviceHandler == null) {
            throw new AxisFault(JavaUtils.getMessage("needService00"));
        }
        String serviceName = serviceHandler.getName();
        String allowedRoles = (String)serviceHandler.getOption("allowedRoles");
        if (allowedRoles == null) {
            if (allowByDefault) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("noRoles00"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("noRoles01"));
                }
                throw new AxisFault("Server.Unauthorized", JavaUtils.getMessage("notAuth00", userID, serviceName), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("exit00", "SimpleAuthorizationHandler::invoke"));
            }
            return;
        }
        SecurityProvider provider = (SecurityProvider)msgContext.getProperty("securityProvider");
        if (provider == null) {
            throw new AxisFault(JavaUtils.getMessage("noSecurity00"));
        }
        StringTokenizer st = new StringTokenizer(allowedRoles, ",");
        while (st.hasMoreTokens()) {
            String thisRole = st.nextToken();
            if (!provider.userMatches(user, thisRole)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("auth01", userID, serviceName));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("exit00", "SimpleAuthorizationHandler::invoke"));
            }
            return;
        }
        throw new AxisFault("Server.Unauthorized", JavaUtils.getMessage("cantAuth02", userID, serviceName), null, null);
    }

    public void undo(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "SimpleAuthorizationHandler::undo"));
            log.debug((Object)JavaUtils.getMessage("exit00", "SimpleAuthorizationHandler::undo"));
        }
    }
}

