/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleSessionHandler
extends BasicHandler {
    protected static Log log;
    public static final String SESSION_ID = "SimpleSession.id";
    public static final String SESSION_NS = "http://xml.apache.org/axis/session";
    public static final String SESSION_LOCALPART = "sessionID";
    public static final QName sessionHeaderName;
    private Hashtable activeSessions = new Hashtable();
    private long curSessionID = 0L;
    private long reapPeriodicity = 30000L;
    private long lastReapTime = 0L;
    private int defaultSessionTimeout = 60;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.handlers.SimpleSessionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        sessionHeaderName = new QName(SESSION_NS, SESSION_LOCALPART);
    }

    public void invoke(MessageContext context) throws AxisFault {
        long curTime = System.currentTimeMillis();
        boolean reap = false;
        SimpleSessionHandler simpleSessionHandler = this;
        synchronized (simpleSessionHandler) {
            if (curTime > this.lastReapTime + this.reapPeriodicity) {
                reap = true;
                this.lastReapTime = curTime;
            }
        }
        if (reap) {
            Set keys = this.activeSessions.keySet();
            HashSet victims = new HashSet();
            Iterator<Object> i = keys.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                SimpleSession session = (SimpleSession)this.activeSessions.get(key);
                if ((long)(session.getTimeout() * 1000) <= curTime - session.getLastAccessTime()) continue;
                log.debug((Object)JavaUtils.getMessage("timeout00", key.toString()));
                victims.add(key);
            }
            i = victims.iterator();
            while (i.hasNext()) {
                this.activeSessions.remove(i.next());
            }
        }
        if (context.isClient()) {
            this.doClient(context);
        } else {
            this.doServer(context);
        }
    }

    public void doClient(MessageContext context) throws AxisFault {
        if (context.getPastPivot()) {
            Message msg = context.getResponseMessage();
            if (msg == null) {
                return;
            }
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeader header = env.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (header == null) {
                return;
            }
            try {
                Long id = (Long)header.getValueAsType(Constants.XSD_LONG);
                AxisEngine engine = context.getAxisEngine();
                engine.setOption(SESSION_ID, id);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        } else {
            AxisEngine engine = context.getAxisEngine();
            Long id = (Long)engine.getOption(SESSION_ID);
            if (id == null) {
                return;
            }
            Message msg = context.getRequestMessage();
            if (msg == null) {
                throw new AxisFault(JavaUtils.getMessage("noRequest00"));
            }
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeader header = new SOAPHeader(SESSION_NS, SESSION_LOCALPART, id);
            env.addHeader(header);
        }
    }

    public void doServer(MessageContext context) throws AxisFault {
        if (context.getPastPivot()) {
            Long id = (Long)context.getProperty(SESSION_ID);
            if (id == null) {
                return;
            }
            Message msg = context.getResponseMessage();
            if (msg == null) {
                return;
            }
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeader header = new SOAPHeader(SESSION_NS, SESSION_LOCALPART, id);
            env.addHeader(header);
        } else {
            Long id;
            Message msg = context.getRequestMessage();
            if (msg == null) {
                throw new AxisFault(JavaUtils.getMessage("noRequest00"));
            }
            SOAPEnvelope env = msg.getSOAPEnvelope();
            SOAPHeader header = env.getHeaderByName(SESSION_NS, SESSION_LOCALPART);
            if (header != null) {
                try {
                    id = (Long)header.getValueAsType(Constants.XSD_LONG);
                }
                catch (Exception e) {
                    throw AxisFault.makeFault(e);
                }
            } else {
                id = this.getNewSession();
            }
            SimpleSession session = (SimpleSession)this.activeSessions.get(id);
            if (session == null) {
                id = this.getNewSession();
                session = (SimpleSession)this.activeSessions.get(id);
            }
            session.touch();
            context.setSession(session);
            context.setProperty(SESSION_ID, id);
        }
    }

    private synchronized Long getNewSession() {
        Long id = new Long(this.curSessionID++);
        SimpleSession session = new SimpleSession();
        session.setTimeout(this.defaultSessionTimeout);
        this.activeSessions.put(id, session);
        return id;
    }

    public void setReapPeriodicity(long reapTime) {
        this.reapPeriodicity = reapTime;
    }

    public void setDefaultSessionTimeout(int defaultSessionTimeout) {
        this.defaultSessionTimeout = defaultSessionTimeout;
    }
}

