/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers.soap;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPService
extends SimpleTargetedChain {
    protected static Log log;
    private Vector validTransports = null;
    private TypeMappingRegistry tmr;
    private ServiceDesc serviceDescription = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.handlers.soap.SOAPService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public SOAPService() {
        this.initTypeMappingRegistry();
    }

    public SOAPService(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        this.init(reqHandler, new SOAPRequestHandler(), pivHandler, null, respHandler);
        this.initTypeMappingRegistry();
    }

    private void initTypeMappingRegistry() {
        this.tmr = new TypeMappingRegistryImpl();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry map) {
        this.tmr = map;
    }

    public SOAPService(Handler serviceHandler) {
        this.init(null, new SOAPRequestHandler(), serviceHandler, null, null);
        this.initTypeMappingRegistry();
    }

    public void setEngine(AxisEngine engine) {
        this.tmr.delegate(engine.getTypeMappingRegistry());
    }

    public boolean availableFromTransport(String transportName) {
        if (this.validTransports != null) {
            int i = 0;
            while (i < this.validTransports.size()) {
                if (((String)this.validTransports.elementAt(i)).equals(transportName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public int getStyle() {
        if (this.serviceDescription == null) {
            this.serviceDescription = new ServiceDesc();
        }
        return this.serviceDescription.getStyle();
    }

    public void setStyle(int style) {
        if (this.serviceDescription == null) {
            this.serviceDescription = new ServiceDesc();
        }
        this.serviceDescription.setStyle(style);
    }

    public ServiceDesc getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(ServiceDesc serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public void start() {
    }

    public void stop() {
    }

    public void enableTransport(String transportName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enableTransport00", "" + this, transportName));
        }
        if (this.validTransports == null) {
            this.validTransports = new Vector();
        }
        this.validTransports.addElement(transportName);
    }

    public void disableTransport(String transportName) {
        if (this.validTransports != null) {
            this.validTransports.removeElement(transportName);
        }
    }

    private class SOAPRequestHandler
    extends BasicHandler {
        public void invoke(MessageContext msgContext) throws AxisFault {
            if (BasicHandler.log.isDebugEnabled()) {
                BasicHandler.log.debug((Object)JavaUtils.getMessage("semanticCheck00"));
            }
            ArrayList actors = msgContext.getAxisEngine().getActorURIs();
            SOAPEnvelope env = msgContext.getRequestMessage().getSOAPEnvelope();
            Vector headers = env.getHeadersByActor(actors);
            Vector<SOAPHeader> misunderstoodHeaders = null;
            Enumeration enumeration = headers.elements();
            while (enumeration.hasMoreElements()) {
                SOAPHeader header = (SOAPHeader)enumeration.nextElement();
                if (!header.isMustUnderstand() || header.isProcessed()) continue;
                if (misunderstoodHeaders == null) {
                    misunderstoodHeaders = new Vector<SOAPHeader>();
                }
                misunderstoodHeaders.addElement(header);
            }
            boolean doMisunderstoodHeaders = true;
            if (misunderstoodHeaders != null) {
                if (doMisunderstoodHeaders) {
                    Message respMsg = msgContext.getResponseMessage();
                    if (respMsg == null) {
                        respMsg = new Message(new SOAPEnvelope());
                        msgContext.setResponseMessage(respMsg);
                    }
                    env = respMsg.getSOAPEnvelope();
                    enumeration = misunderstoodHeaders.elements();
                    while (enumeration.hasMoreElements()) {
                        SOAPHeader badHeader = (SOAPHeader)enumeration.nextElement();
                        QName badQName = new QName(badHeader.getNamespaceURI(), badHeader.getName());
                        SOAPHeader newHeader = new SOAPHeader("http://www.w3.org/2001/06/soap-faults", "Misunderstood");
                        newHeader.addAttribute(null, "qname", badQName);
                        env.addHeader(newHeader);
                    }
                }
                throw new AxisFault(Constants.FAULT_MUSTUNDERSTAND, JavaUtils.getMessage("noUnderstand00"), null, null);
            }
        }
    }
}

