/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.BodyBuilder;
import org.apache.axis.message.HeaderBuilder;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnvelopeBuilder
extends SOAPHandler {
    private MessageElement element;
    private SOAPEnvelope envelope;
    private boolean gotHeader = false;
    private boolean gotBody = false;
    private static final QName headerQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    private static final QName bodyQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");

    public EnvelopeBuilder(String messageType) {
        this.envelope = new SOAPEnvelope(false);
        this.envelope.setMessageType(messageType);
        this.myElement = this.envelope;
    }

    public EnvelopeBuilder(SOAPEnvelope env, String messageType) {
        this.envelope = env;
        this.envelope.setMessageType(messageType);
        this.myElement = this.envelope;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public void startElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        if (!namespace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            throw new SAXException(JavaUtils.getMessage("badNamespace00", namespace));
        }
        if (!localName.equals("Envelope")) {
            throw new SAXException(JavaUtils.getMessage("badTag00", localName));
        }
        String prefix = "";
        int idx = qName.indexOf(":");
        if (idx > 0) {
            prefix = qName.substring(0, idx);
        }
        this.envelope.setPrefix(prefix);
        this.envelope.setNamespaceURI(namespace);
        this.envelope.setNSMappings(context.getCurrentNSMappings());
        context.pushNewElement(this.envelope);
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        QName thisQName = new QName(namespace, localName);
        if (thisQName.equals(headerQName)) {
            if (this.gotHeader) {
                throw new SAXException(JavaUtils.getMessage("only1Header00"));
            }
            this.gotHeader = true;
            return new HeaderBuilder(this.envelope);
        }
        if (thisQName.equals(bodyQName)) {
            if (this.gotBody) {
                throw new SAXException(JavaUtils.getMessage("only1Body00"));
            }
            this.gotBody = true;
            return new BodyBuilder(this.envelope);
        }
        if (!this.gotBody) {
            throw new SAXException(JavaUtils.getMessage("noCustomElems00"));
        }
        return null;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) {
        if (this.element != null) {
            this.envelope.addTrailer(this.element);
        }
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        this.envelope.setDirty(false);
    }
}

