/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MessageElement
implements SOAPElement {
    protected static Log log;
    private static final Mapping encMapping;
    protected String name;
    protected String prefix;
    protected String namespaceURI;
    protected AttributesImpl attributes;
    protected String id;
    protected String href;
    protected boolean _isRoot = true;
    protected SOAPEnvelope message = null;
    protected boolean _isDirty = false;
    protected DeserializationContext context;
    protected QName typeQName = null;
    protected Vector qNameAttrs = null;
    protected SAX2EventRecorder recorder = null;
    protected int startEventIndex = 0;
    protected int startContentsIndex = 0;
    protected int endEventIndex = -1;
    protected Element elementRep = null;
    protected MessageElement parent = null;
    public ArrayList namespaces = null;
    protected String encodingStyle = null;
    private Object objectValue = null;
    Deserializer fixupDeserializer;
    private ArrayList children = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.message.MessageElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        encMapping = new Mapping("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
    }

    public MessageElement() {
    }

    MessageElement(String namespace, String localPart) {
        this.namespaceURI = namespace;
        this.name = localPart;
    }

    MessageElement(String namespace, String localPart, Object value) {
        this(namespace, localPart);
        this.objectValue = value;
    }

    MessageElement(Element elem) {
        this.elementRep = elem;
        this.namespaceURI = elem.getNamespaceURI();
        this.name = elem.getLocalName();
    }

    public MessageElement(String namespace, String localPart, String qName, Attributes attributes, DeserializationContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("newElem00", super.toString(), "" + qName));
            int i = 0;
            while (attributes != null && i < attributes.getLength()) {
                log.debug((Object)("  " + attributes.getQName(i) + " = '" + attributes.getValue(i) + "'"));
                ++i;
            }
        }
        this.namespaceURI = namespace;
        this.name = localPart;
        int idx = qName.indexOf(":");
        if (idx > 0) {
            this.prefix = qName.substring(0, idx);
        }
        this.context = context;
        this.startEventIndex = context.getStartOfMappingsPos();
        this.setNSMappings(context.getCurrentNSMappings());
        this.recorder = context.getRecorder();
        if (attributes == null) {
            this.attributes = new AttributesImpl();
        } else {
            this.attributes = new AttributesImpl(attributes);
            this.typeQName = context.getTypeFromAttributes(namespace, localPart, attributes);
            String rootVal = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "root");
            if (rootVal != null) {
                this._isRoot = rootVal.equals("1");
            }
            this.id = attributes.getValue("id");
            if (this.id != null) {
                context.registerElementByID(this.id, this);
            }
            this.href = attributes.getValue("href");
            if (attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType") != null) {
                this.typeQName = Constants.SOAP_ARRAY;
            }
            this.encodingStyle = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "encodingStyle");
        }
    }

    public void setFixupDeserializer(Deserializer dser) {
        this.fixupDeserializer = dser;
    }

    public Deserializer getFixupDeserializer() {
        return this.fixupDeserializer;
    }

    public void setEndIndex(int endIndex) {
        this.endEventIndex = endIndex;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean dirty) {
        this._isDirty = dirty;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getID() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String nsURI) {
        this.namespaceURI = nsURI;
    }

    public QName getType() {
        MessageElement referent;
        if (this.typeQName == null && this.href != null && this.context != null && (referent = this.context.getElementByID(this.href)) != null) {
            this.typeQName = referent.getType();
        }
        return this.typeQName;
    }

    public void setType(QName qName) {
        this.typeQName = qName;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder rec) {
        this.recorder = rec;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.parent == null) {
                return "";
            }
            return this.parent.getEncodingStyle();
        }
        return this.encodingStyle;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (encodingStyle == null) {
            encodingStyle = "";
        }
        this.encodingStyle = encodingStyle;
        if (encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            this.addMapping(encMapping);
        }
    }

    public MessageElement getParent() {
        return this.parent;
    }

    public void setParent(MessageElement parent) throws SOAPException {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(MessageElement el) throws SOAPException {
        if (this.objectValue != null) {
            SOAPException exc = new SOAPException(JavaUtils.getMessage("valuePresent"));
            log.error((Object)JavaUtils.getMessage("valuePresent"), (Throwable)exc);
            throw exc;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(el);
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void setContentsIndex(int index) {
        this.startContentsIndex = index;
    }

    public void setNSMappings(ArrayList namespaces) {
        this.namespaces = namespaces;
    }

    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        if (this.href != null) {
            return this.getRealElement().getPrefix(namespaceURI);
        }
        if (this.namespaces != null) {
            int i = 0;
            while (i < this.namespaces.size()) {
                Mapping map = (Mapping)this.namespaces.get(i);
                if (map.getNamespaceURI().equals(namespaceURI)) {
                    return map.getPrefix();
                }
                ++i;
            }
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.href != null) {
            return this.getRealElement().getNamespaceURI(prefix);
        }
        if (this.namespaces != null) {
            int i = 0;
            while (i < this.namespaces.size()) {
                Mapping map = (Mapping)this.namespaces.get(i);
                if (map.getPrefix().equals(prefix)) {
                    return map.getNamespaceURI();
                }
                ++i;
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("noPrefix00", "" + this, prefix));
        }
        return null;
    }

    public Object getObjectValue() {
        if (this.objectValue == null) {
            try {
                this.objectValue = this.getValueAsType(this.getType());
            }
            catch (Exception e) {
                log.debug((Object)"getValue()", (Throwable)e);
            }
        }
        return this.objectValue;
    }

    public void setObjectValue(Object newValue) throws SOAPException {
        if (this.children != null && !this.children.isEmpty()) {
            SOAPException exc = new SOAPException(JavaUtils.getMessage("childPresent"));
            log.error((Object)JavaUtils.getMessage("childPresent"), (Throwable)exc);
            throw exc;
        }
        if (this.elementRep != null) {
            SOAPException exc = new SOAPException(JavaUtils.getMessage("xmlPresent"));
            log.error((Object)JavaUtils.getMessage("xmlPresent"), (Throwable)exc);
            throw exc;
        }
        this.objectValue = newValue;
    }

    public Object getValueAsType(QName type) throws Exception {
        if (this.context == null) {
            throw new Exception(JavaUtils.getMessage("noContext00"));
        }
        Deserializer dser = this.context.getDeserializerForType(type);
        if (dser == null) {
            throw new Exception(JavaUtils.getMessage("noDeser00", "" + type));
        }
        this.context.pushElementHandler(new EnvelopeHandler((SOAPHandler)((Object)dser)));
        this.publishToHandler((ContentHandler)((Object)this.context));
        return dser.getValue();
    }

    public void addAttribute(String namespace, String localName, QName value) {
        if (this.qNameAttrs == null) {
            this.qNameAttrs = new Vector();
        }
        QNameAttr attr = new QNameAttr();
        attr.name = new QName(namespace, localName);
        attr.value = value;
        this.qNameAttrs.addElement(attr);
    }

    public void addAttribute(String namespace, String localName, String value) {
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        this.attributes.addAttribute(namespace, localName, "", "CDATA", value);
    }

    public void setAttribute(String namespace, String localName, String value) {
        if (this.attributes != null) {
            int idx = this.attributes.getIndex(namespace, localName);
            if (idx > -1) {
                if (value != null) {
                    this.attributes.setValue(idx, value);
                } else {
                    this.attributes.removeAttribute(idx);
                }
                return;
            }
        } else if (value != null) {
            this.attributes = new AttributesImpl();
        }
        this.addAttribute(namespace, localName, value);
    }

    public String getAttributeValue(String localName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(localName);
    }

    public void setEnvelope(SOAPEnvelope env) {
        this.message = env;
    }

    public SOAPEnvelope getEnvelope() {
        return this.message;
    }

    public MessageElement getRealElement() {
        if (this.href == null) {
            return this;
        }
        Object obj = this.context.getObjectByRef(this.href);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof MessageElement)) {
            return null;
        }
        return (MessageElement)obj;
    }

    public Document getAsDocument() throws Exception {
        String elementString = this.getAsString();
        StringReader reader = new StringReader(elementString);
        Document doc = XMLUtils.newDocument(new InputSource(reader));
        if (doc == null) {
            throw new Exception(JavaUtils.getMessage("noDoc00", elementString));
        }
        return doc;
    }

    private String getAsString() throws Exception {
        SerializationContextImpl serializeContext = null;
        StringWriter writer = new StringWriter();
        MessageContext msgContext = this.context != null ? this.context.getMessageContext() : MessageContext.getCurrentContext();
        serializeContext = new SerializationContextImpl(writer, msgContext);
        serializeContext.setSendDecl(false);
        this.output(serializeContext);
        writer.close();
        return writer.getBuffer().toString();
    }

    public Element getAsDOM() throws Exception {
        return this.getAsDocument().getDocumentElement();
    }

    public void publishToHandler(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(JavaUtils.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startEventIndex, this.endEventIndex, handler);
    }

    public void publishContents(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(JavaUtils.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startContentsIndex, this.endEventIndex - 1, handler);
    }

    public final void output(SerializationContext context) throws Exception {
        if (this.recorder != null && !this._isDirty) {
            this.recorder.replay(this.startEventIndex, this.endEventIndex, new SAXOutputter(context));
            return;
        }
        if (this.qNameAttrs != null) {
            int i = 0;
            while (i < this.qNameAttrs.size()) {
                QNameAttr attr = (QNameAttr)this.qNameAttrs.get(i);
                QName attrName = attr.name;
                this.addAttribute(attrName.getNamespaceURI(), attrName.getLocalPart(), context.qName2String(attr.value));
                ++i;
            }
            this.qNameAttrs = null;
        }
        if (this.encodingStyle != null) {
            if (this.parent == null) {
                if (!this.encodingStyle.equals("")) {
                    this.setAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", this.encodingStyle);
                }
            } else if (!this.encodingStyle.equals(this.parent.getEncodingStyle())) {
                this.setAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", this.encodingStyle);
            }
        }
        this.outputImpl(context);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        if (this.elementRep != null) {
            boolean oldPretty = context.getPretty();
            context.setPretty(false);
            context.writeDOMElement(this.elementRep);
            context.setPretty(oldPretty);
            return;
        }
        if (this.prefix != null) {
            context.registerPrefixForURI(this.prefix, this.namespaceURI);
        }
        if (this.objectValue != null) {
            context.serialize(new QName(this.namespaceURI, this.name), this.attributes, this.objectValue, this.objectValue.getClass());
            return;
        }
        context.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        if (this.children != null) {
            Iterator it = ((AbstractList)this.children).iterator();
            while (it.hasNext()) {
                ((MessageElement)it.next()).output(context);
            }
        }
        context.endElement();
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (Exception exp) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exp);
            return null;
        }
    }

    public void addMapping(Mapping map) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(map);
    }

    public String getValue() {
        return null;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        try {
            this.setParent((MessageElement)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public SOAPElement getParentElement() {
        return this.getParent();
    }

    public void detachNode() {
    }

    public void recycleNode() {
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        MessageElement child = new MessageElement(name.getURI(), name.getLocalName());
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        MessageElement child = new MessageElement(this.getNamespaceURI(), localName);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        MessageElement child = new MessageElement(this.getNamespaceURI(prefix), localName);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        MessageElement child = new MessageElement(uri, localName);
        child.addNamespaceDeclaration(prefix, uri);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        try {
            this.addChild((MessageElement)element);
            return element;
        }
        catch (ClassCastException e) {
            throw new SOAPException(e);
        }
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        throw new SOAPException("Text nodes not supported");
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        try {
            this.addAttribute(name.getURI(), name.getLocalName(), value);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        try {
            Mapping map = new Mapping(uri, prefix);
            this.addMapping(map);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        return this.attributes.getValue(name.getURI(), name.getLocalName());
    }

    public Iterator getAllAttributes() {
        int num = this.attributes.getLength();
        Vector<NameImpl> attrs = new Vector<NameImpl>(num);
        int i = 0;
        while (i < num) {
            int idx;
            String q = this.attributes.getQName(i);
            String prefix = "";
            if (q != null && (idx = q.indexOf(":")) > 0) {
                prefix = q.substring(0, idx);
            }
            attrs.add(new NameImpl(this.attributes.getURI(i), this.attributes.getLocalName(i), prefix));
            ++i;
        }
        return ((AbstractList)attrs).iterator();
    }

    public Iterator getNamespacePrefixes() {
        int num = this.namespaces.size();
        Vector<String> prefixes = new Vector<String>(num);
        int i = 0;
        while (i < num) {
            prefixes.add(((Mapping)this.namespaces.get(i)).getPrefix());
            ++i;
        }
        return ((AbstractList)prefixes).iterator();
    }

    public Name getElementName() {
        return new NameImpl(this.getNamespaceURI(), this.getName(), this.getPrefix());
    }

    public boolean removeAttribute(Name name) {
        boolean removed = false;
        int i = 0;
        while (i < this.attributes.getLength() && !removed) {
            if (this.attributes.getURI(i).equals(name.getURI()) && this.attributes.getLocalName(i).equals(name.getLocalName())) {
                this.attributes.removeAttribute(i);
                removed = true;
            }
            ++i;
        }
        return removed;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        boolean removed = false;
        int i = 0;
        while (i < this.namespaces.size() && !removed) {
            if (((Mapping)this.namespaces.get(i)).getPrefix().equals(prefix)) {
                this.namespaces.remove(i);
                removed = true;
            }
            ++i;
        }
        return removed;
    }

    public Iterator getChildElements() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return ((AbstractList)this.children).iterator();
    }

    public Iterator getChildElements(Name name) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        int num = this.children.size();
        Vector<MessageElement> c = new Vector<MessageElement>(num);
        int i = 0;
        while (i < num) {
            MessageElement child = (MessageElement)this.children.get(i);
            Name cname = child.getElementName();
            if (cname.getURI().equals(name.getURI()) && cname.getLocalName().equals(name.getLocalName())) {
                c.add(child);
            }
            ++i;
        }
        return ((AbstractList)c).iterator();
    }

    protected static class QNameAttr {
        QName name;
        QName value;

        protected QNameAttr() {
        }
    }

    protected static class NameImpl
    implements Name {
        private QName qName;
        private String prefix;

        public NameImpl(String uri, String localName, String pre) {
            this.qName = new QName(uri, localName);
            this.prefix = pre;
        }

        public String getLocalName() {
            return this.qName.getLocalPart();
        }

        public String getQualifiedName() {
            return this.qName.toString();
        }

        public String getURI() {
            return this.qName.getNamespaceURI();
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

