/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RPCElement
extends SOAPBodyElement {
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    protected boolean elementIsFirstParam = false;
    protected Class[] defaultParamTypes = null;

    public RPCElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context, OperationDesc operation) {
        super(namespace, localName, prefix, attributes, context);
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.needDeser = true;
        if (operation != null) {
            this.name = operation.getName();
            this.elementIsFirstParam = operation.getStyle() == 1;
        }
    }

    public RPCElement(String namespace, String methodName, Object[] args) {
        this.setNamespaceURI(namespace);
        this.name = methodName;
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        int i = 0;
        while (args != null && i < args.length) {
            if (args[i] instanceof RPCParam) {
                this.addParam((RPCParam)args[i]);
            } else {
                String name = null;
                if (name == null) {
                    name = "arg" + i;
                }
                this.addParam(new RPCParam(name, args[i]));
            }
            ++i;
        }
    }

    public RPCElement(String methodName) {
        this.encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.name = methodName;
    }

    public String getMethodName() {
        return this.name;
    }

    public Class[] getJavaParamTypes() {
        return this.defaultParamTypes;
    }

    public void deserialize() throws SAXException {
        this.needDeser = false;
        MessageContext msgContext = this.context.getMessageContext();
        SOAPService service = msgContext.getService();
        String clsName = null;
        if (service != null) {
            clsName = (String)service.getOption("className");
        }
        if (clsName != null) {
            int numChildren;
            ClassLoader cl = msgContext.getClassLoader();
            ClassCache cache = msgContext.getAxisEngine().getClassCache();
            JavaClass jc = null;
            try {
                jc = cache.lookup(clsName, cl);
            }
            catch (ClassNotFoundException e) {
                throw new SAXException(e);
            }
            if (MessageElement.log.isDebugEnabled()) {
                MessageElement.log.debug((Object)JavaUtils.getMessage("lookup00", this.name, clsName));
            }
            Method[] method = jc.getMethod(this.name);
            int n = numChildren = this.getChildren() == null ? 0 : this.getChildren().size();
            if (method != null) {
                int i = 0;
                while (i < method.length) {
                    block14: {
                        this.defaultParamTypes = method[i].getParameterTypes();
                        if (this.defaultParamTypes.length >= numChildren) {
                            try {
                                if (this.elementIsFirstParam) {
                                    this.context.pushElementHandler(new RPCHandler(this));
                                    this.context.setCurElement(null);
                                } else {
                                    this.context.pushElementHandler(new EnvelopeHandler(new RPCHandler(this)));
                                    this.context.setCurElement(this);
                                }
                                this.publishToHandler((ContentHandler)((Object)this.context));
                            }
                            catch (SAXException e) {
                                this.params = new Vector();
                                break block14;
                            }
                            return;
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.elementIsFirstParam) {
            this.context.pushElementHandler(new RPCHandler(this));
            this.context.setCurElement(null);
        } else {
            this.context.pushElementHandler(new EnvelopeHandler(new RPCHandler(this)));
            this.context.setCurElement(this);
        }
        this.publishToHandler((ContentHandler)((Object)this.context));
    }

    public RPCParam getParam(String name) throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        int i = 0;
        while (i < this.params.size()) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (param.getName().equals(name)) {
                return param;
            }
            ++i;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        return this.params;
    }

    public void addParam(RPCParam param) {
        param.setRPCCall(this);
        this.params.addElement(param);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        MessageContext msgContext = context.getMessageContext();
        boolean isRPC = true;
        if (msgContext != null && msgContext.getOperationStyle() != 0 && msgContext.getOperationStyle() != 2) {
            isRPC = false;
        }
        if (isRPC) {
            if (this.encodingStyle.equals("")) {
                context.registerPrefixForURI("", this.getNamespaceURI());
            }
            context.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        }
        int i = 0;
        while (i < this.params.size()) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (!isRPC && this.encodingStyle.equals("")) {
                context.registerPrefixForURI("", param.getQName().getNamespaceURI());
            }
            param.serialize(context);
            ++i;
        }
        if (isRPC) {
            context.endElement();
        }
    }
}

