/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SymbolTable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAX2EventRecorder {
    private static final byte STATE_SET_DOCUMENT_LOCATOR = 0;
    private static final byte STATE_START_DOCUMENT = 1;
    private static final byte STATE_END_DOCUMENT = 2;
    private static final byte STATE_START_PREFIX_MAPPING = 3;
    private static final byte STATE_END_PREFIX_MAPPING = 4;
    private static final byte STATE_START_ELEMENT = 5;
    private static final byte STATE_END_ELEMENT = 6;
    private static final byte STATE_CHARACTERS = 7;
    private static final byte STATE_IGNORABLE_WHITESPACE = 8;
    private static final byte STATE_PROCESSING_INSTRUCTION = 9;
    private static final byte STATE_SKIPPED_ENTITY = 10;
    private static final byte STATE_NEWELEMENT = 11;
    Locator locator;
    intArrayVector events = new intArrayVector();
    Object[] attrs = new Object[20];
    int numattrs = 0;
    SymbolTable st = new SymbolTable();
    ArrayList elements = new ArrayList();

    public void clear() {
        this.locator = null;
        this.events = new intArrayVector();
        this.attrs = new Object[20];
        this.numattrs = 0;
        this.st = new SymbolTable();
    }

    public int getLength() {
        return this.events.getLength();
    }

    public int setDocumentLocator(Locator p1) {
        this.locator = p1;
        return this.events.add(0, 0, 0, 0, 0);
    }

    public int startDocument() {
        return this.events.add(1, 0, 0, 0, 0);
    }

    public int endDocument() {
        return this.events.add(2, 0, 0, 0, 0);
    }

    public int startPrefixMapping(String p1, String p2) {
        return this.events.add(3, this.st.addSymbol(p1), this.st.addSymbol(p2), 0, 0);
    }

    public int endPrefixMapping(String p1) {
        return this.events.add(4, this.st.addSymbol(p1), 0, 0, 0);
    }

    public int startElement(String p1, String p2, String p3, Attributes p4) {
        if (this.numattrs == this.attrs.length) {
            Object[] nattrs = new Object[this.numattrs * 2];
            System.arraycopy(this.attrs, 0, nattrs, 0, this.numattrs);
            this.attrs = nattrs;
        }
        this.attrs[this.numattrs++] = new AttributesImpl(p4);
        return this.events.add(5, this.st.addSymbol(p1), this.st.addSymbol(p2), this.st.addSymbol(p3), this.numattrs - 1);
    }

    public int endElement(String p1, String p2, String p3) {
        return this.events.add(6, this.st.addSymbol(p1), this.st.addSymbol(p2), this.st.addSymbol(p3), 0);
    }

    public int characters(char[] p1, int p2, int p3) {
        return this.events.add(7, this.st.addSymbol(p1, p2, p3), 0, p3, 0);
    }

    public int ignorableWhitespace(char[] p1, int p2, int p3) {
        return this.events.add(8, this.st.addSymbol(p1, p2, p3), p2, p3, 0);
    }

    public int processingInstruction(String p1, String p2) {
        return this.events.add(9, this.st.addSymbol(p1), this.st.addSymbol(p2), 0, 0);
    }

    public int skippedEntity(String p1) {
        return this.events.add(10, this.st.addSymbol(p1), 0, 0, 0);
    }

    public int newElement(MessageElement elem) {
        return this.events.add(11, this.addElement(elem), 0, 0, 0);
    }

    private int addElement(MessageElement elem) {
        this.elements.add(elem);
        return this.elements.size() - 1;
    }

    public void replay(ContentHandler handler) throws SAXException {
        this.replay(0, this.events.getLength() - 1, handler);
    }

    public void replay(int start, int stop, ContentHandler handler) throws SAXException {
        if (start == 0 && stop == -1) {
            this.replay(handler);
            return;
        }
        if (stop + 1 > this.events.getLength() || stop < start) {
            return;
        }
        int n = start;
        while (n <= stop) {
            switch (this.events.get(n, 0)) {
                case 0: {
                    handler.setDocumentLocator(this.locator);
                    break;
                }
                case 1: {
                    handler.startDocument();
                    break;
                }
                case 2: {
                    handler.endDocument();
                    break;
                }
                case 3: {
                    handler.startPrefixMapping(this.st.getSymbol(this.events.get(n, 1)), this.st.getSymbol(this.events.get(n, 2)));
                    break;
                }
                case 4: {
                    handler.endPrefixMapping(this.st.getSymbol(this.events.get(n, 1)));
                    break;
                }
                case 5: {
                    int attrIdx = this.events.get(n, 4);
                    handler.startElement(this.st.getSymbol(this.events.get(n, 1)), this.st.getSymbol(this.events.get(n, 2)), this.st.getSymbol(this.events.get(n, 3)), (Attributes)this.attrs[this.events.get(n, 4)]);
                    break;
                }
                case 6: {
                    handler.endElement(this.st.getSymbol(this.events.get(n, 1)), this.st.getSymbol(this.events.get(n, 2)), this.st.getSymbol(this.events.get(n, 3)));
                    break;
                }
                case 7: {
                    handler.characters(this.st.getSymbol(this.events.get(n, 1)).toCharArray(), this.events.get(n, 2), this.events.get(n, 3));
                    break;
                }
                case 8: {
                    handler.characters(this.st.getSymbol(this.events.get(n, 1)).toCharArray(), this.events.get(n, 2), this.events.get(n, 3));
                    break;
                }
                case 9: {
                    handler.processingInstruction(this.st.getSymbol(this.events.get(n, 1)), this.st.getSymbol(this.events.get(n, 2)));
                    break;
                }
                case 10: {
                    handler.skippedEntity(this.st.getSymbol(this.events.get(n, 1)));
                    break;
                }
                case 11: {
                    if (!(handler instanceof DeserializationContext)) break;
                    DeserializationContext context = (DeserializationContext)((Object)handler);
                    context.setCurElement((MessageElement)this.elements.get(this.events.get(n, 1)));
                }
            }
            ++n;
        }
    }

    class intArrayVector {
        private int RECORD_SIZE = 5;
        private int currentSize = 0;
        private int[] intarray = new int[50 * this.RECORD_SIZE];

        intArrayVector() {
        }

        public int add(int p1, int p2, int p3, int p4, int p5) {
            if (this.currentSize == this.intarray.length) {
                int[] newarray = new int[this.currentSize * 2];
                System.arraycopy(this.intarray, 0, newarray, 0, this.currentSize);
                this.intarray = newarray;
            }
            int pos = this.currentSize / this.RECORD_SIZE;
            this.intarray[this.currentSize++] = p1;
            this.intarray[this.currentSize++] = p2;
            this.intarray[this.currentSize++] = p3;
            this.intarray[this.currentSize++] = p4;
            this.intarray[this.currentSize++] = p5;
            return pos;
        }

        public int[] get(int pos) {
            int[] ints = new int[]{this.intarray[pos * 5], this.intarray[pos * 5 + 1], this.intarray[pos * 5 + 2], this.intarray[pos * 5 + 3], this.intarray[pos * 5 + 4]};
            return ints;
        }

        public int get(int pos, int fld) {
            return this.intarray[pos * this.RECORD_SIZE + fld];
        }

        public int getLength() {
            return this.currentSize / this.RECORD_SIZE;
        }
    }
}

