/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class SOAPEnvelope
extends MessageElement {
    protected static Log log;
    public Vector headers = new Vector();
    public Vector bodyElements = new Vector();
    public Vector trailers = new Vector();
    public String messageType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.message.SOAPEnvelope");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public SOAPEnvelope() {
        this(true);
    }

    public SOAPEnvelope(boolean registerPrefixes) {
        if (registerPrefixes) {
            if (this.namespaces == null) {
                this.namespaces = new ArrayList();
            }
            this.namespaces.add(new Mapping("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV"));
            this.namespaces.add(new Mapping("http://www.w3.org/2001/XMLSchema", "xsd"));
            this.namespaces.add(new Mapping("http://www.w3.org/2001/XMLSchema-instance", "xsi"));
        }
        this.setDirty(true);
    }

    public SOAPEnvelope(InputStream input) {
        try {
            InputSource is = new InputSource(input);
            DeserializationContextImpl dser = null;
            AxisClient tmpEngine = new AxisClient(new NullProvider());
            MessageContext msgContext = new MessageContext(tmpEngine);
            dser = new DeserializationContextImpl(is, msgContext, "request", this);
            dser.parse();
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            throw new RuntimeException(e.toString());
        }
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public Vector getBodyElements() throws AxisFault {
        return this.bodyElements;
    }

    public Vector getTrailers() {
        return this.trailers;
    }

    public SOAPBodyElement getFirstBody() throws AxisFault {
        if (this.bodyElements.isEmpty()) {
            return null;
        }
        return (SOAPBodyElement)this.bodyElements.elementAt(0);
    }

    public Vector getHeaders() throws AxisFault {
        return this.headers;
    }

    public Vector getHeadersByActor(ArrayList actors) {
        Vector<SOAPHeader> results = new Vector<SOAPHeader>();
        Iterator i = ((AbstractList)this.headers).iterator();
        while (i.hasNext()) {
            SOAPHeader header = (SOAPHeader)i.next();
            if (!"http://schemas.xmlsoap.org/soap/actor/next".equals(header.getActor()) && (actors == null || !actors.contains(header.getActor()))) continue;
            results.add(header);
        }
        return results;
    }

    public void addHeader(SOAPHeader header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("addHeader00"));
        }
        header.setEnvelope(this);
        this.headers.addElement(header);
        this._isDirty = true;
    }

    public void addBodyElement(SOAPBodyElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("addBody00"));
        }
        element.setEnvelope(this);
        this.bodyElements.addElement(element);
        this._isDirty = true;
    }

    public void removeHeader(SOAPHeader header) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeHeader00"));
        }
        this.headers.removeElement(header);
        this._isDirty = true;
    }

    public void removeBodyElement(SOAPBodyElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeBody00"));
        }
        this.bodyElements.removeElement(element);
        this._isDirty = true;
    }

    public void removeTrailer(MessageElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeTrailer00"));
        }
        this.trailers.removeElement(element);
        this._isDirty = true;
    }

    public void clearBody() {
        if (!this.bodyElements.isEmpty()) {
            this.bodyElements.removeAllElements();
        }
        this._isDirty = true;
    }

    public void addTrailer(MessageElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("removeTrailer00"));
        }
        element.setEnvelope(this);
        this.trailers.addElement(element);
        this._isDirty = true;
    }

    public SOAPHeader getHeaderByName(String namespace, String localPart) throws AxisFault {
        return this.getHeaderByName(namespace, localPart, false);
    }

    public SOAPHeader getHeaderByName(String namespace, String localPart, boolean accessAllHeaders) throws AxisFault {
        MessageContext mc;
        SOAPHeader header = (SOAPHeader)this.findElement(this.headers, namespace, localPart);
        if (!accessAllHeaders && (mc = MessageContext.getCurrentContext()) != null && header != null) {
            String actor = header.getActor();
            ArrayList actors = mc.getAxisEngine().getActorURIs();
            if (!(actor == null || "http://schemas.xmlsoap.org/soap/actor/next".equals(actor) || actors != null && actors.contains(actor))) {
                header = null;
            }
        }
        return header;
    }

    public SOAPBodyElement getBodyByName(String namespace, String localPart) throws AxisFault {
        return (SOAPBodyElement)this.findElement(this.bodyElements, namespace, localPart);
    }

    protected MessageElement findElement(Vector vec, String namespace, String localPart) {
        if (vec.isEmpty()) {
            return null;
        }
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            MessageElement element = (MessageElement)e.nextElement();
            if (!element.getNamespaceURI().equals(namespace) || !element.getName().equals(localPart)) continue;
            return element;
        }
        return null;
    }

    public Enumeration getHeadersByName(String namespace, String localPart) throws AxisFault {
        return this.getHeadersByName(namespace, localPart, false);
    }

    public Enumeration getHeadersByName(String namespace, String localPart, boolean accessAllHeaders) throws AxisFault {
        ArrayList actors = null;
        boolean firstTime = false;
        Vector<SOAPHeader> v = new Vector<SOAPHeader>();
        Enumeration e = this.headers.elements();
        while (e.hasMoreElements()) {
            SOAPHeader header = (SOAPHeader)e.nextElement();
            if (!header.getNamespaceURI().equals(namespace) || !header.getName().equals(localPart)) continue;
            if (!accessAllHeaders) {
                String actor;
                if (firstTime) {
                    MessageContext mc = MessageContext.getCurrentContext();
                    if (mc != null) {
                        actors = mc.getAxisEngine().getActorURIs();
                    }
                    firstTime = false;
                }
                if ((actor = header.getActor()) != null && !"http://schemas.xmlsoap.org/soap/actor/next".equals(actor) && (actors == null || !actors.contains(actor))) continue;
            }
            v.addElement(header);
        }
        return v.elements();
    }

    public void outputImpl(SerializationContext context) throws Exception {
        Enumeration enumeration;
        boolean oldPretty = context.getPretty();
        context.setPretty(true);
        if (this.namespaces != null) {
            Iterator i = ((AbstractList)this.namespaces).iterator();
            while (i.hasNext()) {
                Mapping mapping = (Mapping)i.next();
                context.registerPrefixForURI(mapping.getPrefix(), mapping.getNamespaceURI());
            }
        }
        context.startElement(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope"), this.attributes);
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(this.headers.size()) + " " + JavaUtils.getMessage("headers00")));
        }
        if (!this.headers.isEmpty()) {
            context.startElement(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), null);
            enumeration = this.headers.elements();
            while (enumeration.hasMoreElements()) {
                SOAPHeader header = (SOAPHeader)enumeration.nextElement();
                header.output(context);
            }
            context.endElement();
        }
        this.bodyElements.isEmpty();
        context.startElement(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), null);
        enumeration = this.bodyElements.elements();
        while (enumeration.hasMoreElements()) {
            SOAPBodyElement body = (SOAPBodyElement)enumeration.nextElement();
            body.output(context);
        }
        context.outputMultiRefs();
        context.endElement();
        enumeration = this.trailers.elements();
        while (enumeration.hasMoreElements()) {
            MessageElement element = (MessageElement)enumeration.nextElement();
            element.output(context);
        }
        context.endElement();
        context.setPretty(oldPretty);
    }
}

