/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.IOException;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.SOAPBodyElement;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SOAPFaultElement
extends SOAPBodyElement {
    protected AxisFault fault;

    public SOAPFaultElement(String namespace, String localName, String prefix, Attributes attrs, DeserializationContext context) {
        super(namespace, localName, prefix, attrs, context);
    }

    public SOAPFaultElement(AxisFault fault) {
        this.fault = fault;
        this.namespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
        this.name = "Fault";
    }

    public void outputImpl(SerializationContext context) throws IOException {
        context.registerPrefixForURI(this.prefix, this.namespaceURI);
        context.startElement(new QName(this.getNamespaceURI(), this.getName()), this.attributes);
        if (this.fault instanceof AxisFault) {
            Element[] faultDetails;
            AxisFault axisFault = this.fault;
            if (axisFault.getFaultCode() != null) {
                String faultCode = context.qName2String(axisFault.getFaultCode());
                context.startElement(Constants.QNAME_FAULTCODE, null);
                context.writeSafeString(faultCode);
                context.endElement();
            }
            if (axisFault.getFaultString() != null) {
                context.startElement(Constants.QNAME_FAULTSTRING, null);
                context.writeSafeString(axisFault.getFaultString());
                context.endElement();
            }
            if (axisFault.getFaultActor() != null) {
                context.startElement(Constants.QNAME_FAULTACTOR, null);
                context.writeSafeString(axisFault.getFaultActor());
                context.endElement();
            }
            if ((faultDetails = axisFault.getFaultDetails()) != null) {
                context.startElement(Constants.QNAME_FAULTDETAILS, null);
                int i = 0;
                while (i < faultDetails.length) {
                    context.writeDOMElement(faultDetails[i]);
                    ++i;
                }
                context.endElement();
            }
        }
        context.endElement();
    }

    public AxisFault getFault() {
        return this.fault;
    }

    public void setFault(AxisFault fault) {
        this.fault = fault;
    }
}

