/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.utils.JavaUtils;

public class EJBProvider
extends RPCProvider {
    private static final String beanNameOption = "beanJndiName";
    private static final String homeInterfaceNameOption = "homeInterfaceName";
    private static final String remoteInterfaceNameOption = "remoteInterfaceName";
    public static final String jndiContextClass = "jndiContextClass";
    public static final String jndiURL = "jndiURL";
    public static final String jndiUsername = "jndiUser";
    public static final String jndiPassword = "jndiPassword";
    public static InitialContext cached_context = null;
    public static final Class[] empty_class_array = new Class[0];
    public static final Object[] empty_object_array = new Object[0];

    protected Object getNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        SOAPService serviceHandler = msgContext.getService();
        Object ejbHome = this.getEJBHome(msgContext, clsName);
        String homeName = this.getStrOption(homeInterfaceNameOption, serviceHandler);
        if (homeName == null) {
            throw new AxisFault(JavaUtils.getMessage("noOption00", homeInterfaceNameOption, msgContext.getTargetService()));
        }
        Class<?> homeClass = msgContext.getClassLoader().loadClass(homeName);
        Object ehome = PortableRemoteObject.narrow((Object)ejbHome, homeClass);
        Method createMethod = homeClass.getMethod("create", empty_class_array);
        Object result = createMethod.invoke(ehome, empty_object_array);
        return result;
    }

    protected String getServiceClassNameOptionName() {
        return beanNameOption;
    }

    private String getStrOption(String optionName, Handler service) {
        String value = null;
        if (service != null) {
            value = (String)service.getOption(optionName);
        }
        if (value == null) {
            value = (String)this.getOption(optionName);
        }
        return value;
    }

    protected Class getServiceClass(MessageContext msgContext, String beanJndiName) throws Exception {
        SOAPService serviceHandler = msgContext.getService();
        Class interfaceClass = null;
        String remoteName = this.getStrOption(remoteInterfaceNameOption, serviceHandler);
        if (remoteName != null) {
            interfaceClass = msgContext.getClassLoader().loadClass(remoteName);
        } else {
            Object ejbHome = this.getEJBHome(msgContext, beanJndiName);
            String homeName = this.getStrOption(homeInterfaceNameOption, serviceHandler);
            if (homeName == null) {
                throw new AxisFault(JavaUtils.getMessage("noOption00", homeInterfaceNameOption, msgContext.getTargetService()));
            }
            Class<?> homeClass = msgContext.getClassLoader().loadClass(homeName);
            Object ehome = PortableRemoteObject.narrow((Object)ejbHome, homeClass);
            Method getEJBMetaData = homeClass.getMethod("getEJBMetaData", empty_class_array);
            Object metaData = getEJBMetaData.invoke(ehome, empty_object_array);
            Method getRemoteInterfaceClass = metaData.getClass().getMethod("getRemoteInterfaceClass", empty_class_array);
            interfaceClass = (Class)getRemoteInterfaceClass.invoke(metaData, empty_object_array);
        }
        return interfaceClass;
    }

    private Object getEJBHome(MessageContext msgContext, String beanJndiName) throws AxisFault {
        Object ejbHome;
        SOAPService serviceHandler = msgContext.getService();
        Properties properties = null;
        try {
            String contextUrl;
            String factoryClass;
            String password;
            String username = this.getStrOption(jndiUsername, serviceHandler);
            if (username == null) {
                username = msgContext.getUsername();
            }
            if (username != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.security.principal", username);
            }
            if ((password = this.getStrOption(jndiPassword, serviceHandler)) == null) {
                password = msgContext.getPassword();
            }
            if (password != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.security.credentials", password);
            }
            if ((factoryClass = this.getStrOption(jndiContextClass, serviceHandler)) != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.factory.initial", factoryClass);
            }
            if ((contextUrl = this.getStrOption(jndiURL, serviceHandler)) != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("java.naming.provider.url", contextUrl);
            }
            InitialContext context = null;
            if (properties != null) {
                context = new InitialContext(properties);
            } else {
                if (cached_context == null) {
                    cached_context = new InitialContext();
                }
                context = cached_context;
            }
            if (context == null) {
                throw new AxisFault(JavaUtils.getMessage("cannotCreateInitialContext00"));
            }
            ejbHome = context.lookup(beanJndiName);
            if (ejbHome == null) {
                throw new AxisFault(JavaUtils.getMessage("cannotFindJNDIHome00", beanJndiName));
            }
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        return ejbHome;
    }
}

