/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisServiceConfig;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public abstract class JavaProvider
extends BasicProvider {
    protected static Log log;
    public static final String OPTION_CLASSNAME = "className";
    public static final String OPTION_IS_STATIC = "isStatic";
    public static final String OPTION_CLASSPATH = "classPath";
    private String classNameOption = "className";
    private String allowedMethodsOption = "allowedMethods";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.providers.java.JavaProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public Object getServiceObject(MessageContext msgContext, Handler service, String clsName) throws Exception {
        String serviceName = msgContext.getService().getName();
        String scope = (String)service.getOption("scope");
        if (scope == null) {
            scope = "Request";
        }
        if (scope.equalsIgnoreCase("Request")) {
            return this.getNewServiceObject(msgContext, clsName);
        }
        if (scope.equalsIgnoreCase("Session")) {
            if (serviceName == null) {
                serviceName = msgContext.getService().toString();
            }
            if (msgContext.getSession() != null) {
                JavaProvider javaProvider = this;
                synchronized (javaProvider) {
                    Object obj = msgContext.getSession().get(serviceName);
                    if (obj == null) {
                        obj = this.getNewServiceObject(msgContext, clsName);
                        msgContext.getSession().set(serviceName, obj);
                    }
                    return obj;
                }
            }
            return this.getNewServiceObject(msgContext, clsName);
        }
        if (scope.equalsIgnoreCase("Application")) {
            AxisEngine engine = msgContext.getAxisEngine();
            if (engine.getApplicationSession() != null) {
                JavaProvider javaProvider = this;
                synchronized (javaProvider) {
                    Object obj = engine.getApplicationSession().get(serviceName);
                    if (obj == null) {
                        obj = this.getNewServiceObject(msgContext, clsName);
                        engine.getApplicationSession().set(serviceName, obj);
                    }
                    return obj;
                }
            }
            return this.getNewServiceObject(msgContext, clsName);
        }
        return null;
    }

    public abstract void processMessage(MessageContext var1, String var2, String var3, SOAPEnvelope var4, SOAPEnvelope var5, JavaClass var6, Object var7) throws Exception;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "JavaProvider::invoke (" + this + ")"));
        }
        String serviceName = msgContext.getTargetService();
        SOAPService service = msgContext.getService();
        String clsName = this.getServiceClassName(service);
        String allowedMethods = this.getAllowedMethods(service);
        if (clsName == null || clsName.equals("")) {
            throw new AxisFault("Server.NoClassForService", JavaUtils.getMessage("noOption00", this.getServiceClassNameOptionName(), serviceName), null, null);
        }
        if (allowedMethods == null || allowedMethods.equals("")) {
            throw new AxisFault("Server.NoMethodConfig", JavaUtils.getMessage("noOption00", this.allowedMethodsOption, serviceName), null, null);
        }
        if (allowedMethods.equals("*")) {
            allowedMethods = null;
        }
        try {
            AxisServiceConfig axisConfig;
            SOAPEnvelope resEnv;
            Object obj = this.getServiceObject(msgContext, service, clsName);
            JavaClass jc = JavaClass.find(obj.getClass());
            Message reqMsg = msgContext.getRequestMessage();
            SOAPEnvelope reqEnv = reqMsg.getSOAPEnvelope();
            Message resMsg = msgContext.getResponseMessage();
            SOAPEnvelope sOAPEnvelope = resEnv = resMsg == null ? new SOAPEnvelope() : resMsg.getSOAPEnvelope();
            if (msgContext.getResponseMessage() == null) {
                resMsg = new Message(resEnv);
                msgContext.setResponseMessage(resMsg);
            }
            if ((axisConfig = this.getConfiguration(obj)) != null) {
                allowedMethods = axisConfig.getAllowedMethods();
            }
            this.processMessage(msgContext, clsName, allowedMethods, reqEnv, resEnv, jc, obj);
        }
        catch (Exception exp) {
            log.debug((Object)JavaUtils.getMessage("exception00"), (Throwable)exp);
            throw AxisFault.makeFault(exp);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "JavaProvider::invoke (" + this + ")"));
        }
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "JavaProvider::generateWSDL (" + this + ")"));
        }
        String serviceName = msgContext.getTargetService();
        SOAPService service = msgContext.getService();
        String allowedMethods = this.getAllowedMethods(service);
        if (allowedMethods == null || allowedMethods.equals("")) {
            throw new AxisFault("Server.NoMethodConfig", JavaUtils.getMessage("noOption00", this.getServiceClassNameOptionName(), serviceName), null, null);
        }
        if (allowedMethods.equals("*")) {
            allowedMethods = null;
        }
        try {
            String url = msgContext.getStrProp(MessageContext.TRANS_URL);
            String urn = msgContext.getTargetService();
            String description = "Service";
            Class cls = this.getServiceClass(msgContext, this.getServiceClassName(service));
            AxisServiceConfig axisConfig = this.getConfiguration(cls);
            if (axisConfig != null) {
                allowedMethods = axisConfig.getAllowedMethods();
            }
            Emitter emitter = new Emitter();
            emitter.setMode(service.getStyle());
            emitter.setClsSmart(cls, url);
            emitter.setAllowedMethods(allowedMethods);
            emitter.setIntfNamespace(url);
            emitter.setLocationUrl(url);
            emitter.setTypeMapping((TypeMapping)msgContext.getTypeMappingRegistry().getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/"));
            emitter.setDefaultTypeMapping((TypeMapping)msgContext.getTypeMappingRegistry().getDefaultTypeMapping());
            Document doc = emitter.emit(0);
            msgContext.setProperty("WSDL", doc);
        }
        catch (NoClassDefFoundError e) {
            throw new AxisFault(e.toString(), e);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "JavaProvider::generateWSDL (" + this + ")"));
        }
    }

    private String getAllowedMethods(Handler service) {
        String val = (String)service.getOption(this.allowedMethodsOption);
        if (val == null || val.length() == 0) {
            val = (String)service.getOption("methodName");
        }
        return val;
    }

    protected Object getNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        ClassLoader cl = msgContext.getClassLoader();
        ClassCache cache = msgContext.getAxisEngine().getClassCache();
        JavaClass jc = cache.lookup(clsName, cl);
        return jc.getJavaClass().newInstance();
    }

    protected String getServiceClassName(Handler service) {
        return (String)service.getOption(this.getServiceClassNameOptionName());
    }

    protected String getServiceClassNameOptionName() {
        return this.classNameOption;
    }

    protected Class getServiceClass(MessageContext msgContext, String clsName) throws Exception {
        SOAPService service = msgContext.getService();
        Object obj = this.getServiceObject(msgContext, service, clsName);
        return obj.getClass();
    }

    public AxisServiceConfig getConfiguration(Object obj) {
        Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        try {
            Method method = cls.getDeclaredMethod("getAxisServiceConfig", new Class[0]);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                return (AxisServiceConfig)method.invoke(null, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }
}

