/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.util.Map;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.DefaultEngineConfigurationFactory;
import org.apache.axis.server.AxisServerFactory;
import org.apache.axis.server.DefaultAxisServerFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServer
extends AxisEngine {
    protected static Log log;
    private static AxisServerFactory factory;
    private AxisEngine clientEngine;
    private boolean running = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.server.AxisServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        factory = null;
    }

    public static AxisServer getServer(Map environment) throws AxisFault {
        if (factory == null) {
            String factoryClassName = System.getProperty("axis.ServerFactory");
            if (factoryClassName != null) {
                try {
                    Class<?> factoryClass = Class.forName(factoryClassName);
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.apache.axis.server.AxisServerFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isAssignableFrom(factoryClass)) {
                        factory = (AxisServerFactory)factoryClass.newInstance();
                    }
                }
                catch (Exception e) {
                    log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                }
            }
            if (factory == null) {
                factory = new DefaultAxisServerFactory();
            }
        }
        return factory.getServer(environment);
    }

    public AxisServer() {
        this(new DefaultEngineConfigurationFactory().getServerEngineConfig());
    }

    public AxisServer(EngineConfiguration config) {
        super(config);
        this.shouldSaveConfig = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.init();
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public synchronized AxisEngine getClientEngine() {
        if (this.clientEngine == null) {
            this.clientEngine = new AxisClient();
        }
        return this.clientEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        MessageContext previousContext;
        block19: {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("enter00", "AxisServer::invoke"));
            }
            if (!this.isRunning()) {
                throw new AxisFault("Server.disabled", JavaUtils.getMessage("serverDisabled00"), null, null);
            }
            String hName = null;
            Handler h = null;
            previousContext = AxisEngine.getCurrentMessageContext();
            try {
                try {
                    AxisEngine.setCurrentMessageContext(msgContext);
                    hName = msgContext.getStrProp(MessageContext.ENGINE_HANDLER);
                    if (hName != null) {
                        h = this.getHandler(hName);
                        if (h == null) {
                            ClassLoader cl = msgContext.getClassLoader();
                            try {
                                log.debug((Object)JavaUtils.getMessage("tryingLoad00", hName));
                                Class<?> cls = cl.loadClass(hName);
                                h = (Handler)cls.newInstance();
                            }
                            catch (Exception e) {
                                h = null;
                            }
                        }
                        if (h == null) throw new AxisFault("Server.error", JavaUtils.getMessage("noHandler00", hName), null, null);
                        h.invoke(msgContext);
                        break block19;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("defaultLogic00"));
                    }
                    hName = msgContext.getTransportName();
                    SimpleTargetedChain transportChain = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("transport01", "AxisServer.invoke", hName));
                    }
                    if (hName != null && (h = this.getTransport(hName)) != null && h instanceof SimpleTargetedChain && (h = (transportChain = (SimpleTargetedChain)h).getRequestHandler()) != null) {
                        h.invoke(msgContext);
                    }
                    if ((h = this.getGlobalRequest()) != null) {
                        h.invoke(msgContext);
                    }
                    if ((h = msgContext.getService()) == null) {
                        Message rm = msgContext.getRequestMessage();
                        rm.getSOAPEnvelope().getFirstBody();
                        h = msgContext.getService();
                        if (h == null) {
                            throw new AxisFault("Server.NoService", JavaUtils.getMessage("noService05", "" + msgContext.getTargetService()), null, null);
                        }
                    }
                    h.invoke(msgContext);
                    h = this.getGlobalResponse();
                    if (h != null) {
                        h.invoke(msgContext);
                    }
                    if (transportChain != null && (h = transportChain.getResponseHandler()) != null) {
                        h.invoke(msgContext);
                    }
                }
                catch (AxisFault e) {
                    throw e;
                }
                catch (Exception e) {
                    throw AxisFault.makeFault(e);
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                AxisEngine.setCurrentMessageContext(previousContext);
                throw throwable;
            }
        }
        Object var7_14 = null;
        AxisEngine.setCurrentMessageContext(previousContext);
        if (!log.isDebugEnabled()) return;
        log.debug((Object)JavaUtils.getMessage("exit00", "AxisServer::invoke"));
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        block18: {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("enter00", "AxisServer::generateWSDL"));
            }
            if (!this.isRunning()) {
                throw new AxisFault("Server.disabled", JavaUtils.getMessage("serverDisabled00"), null, null);
            }
            String hName = null;
            Handler h = null;
            try {
                hName = msgContext.getStrProp(MessageContext.ENGINE_HANDLER);
                if (hName != null) {
                    h = this.getHandler(hName);
                    if (h == null) {
                        ClassLoader cl = msgContext.getClassLoader();
                        try {
                            log.debug((Object)JavaUtils.getMessage("tryingLoad00", hName));
                            Class<?> cls = cl.loadClass(hName);
                            h = (Handler)cls.newInstance();
                        }
                        catch (Exception e) {
                            throw new AxisFault("Server.error", JavaUtils.getMessage("noHandler00", hName), null, null);
                        }
                    }
                    h.generateWSDL(msgContext);
                    break block18;
                }
                log.debug((Object)JavaUtils.getMessage("defaultLogic00"));
                hName = msgContext.getTransportName();
                SimpleTargetedChain transportChain = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("transport01", "AxisServer.generateWSDL", hName));
                }
                if (hName != null && (h = this.getTransport(hName)) != null && h instanceof SimpleTargetedChain && (h = (transportChain = (SimpleTargetedChain)h).getRequestHandler()) != null) {
                    h.generateWSDL(msgContext);
                }
                if ((h = this.getGlobalRequest()) != null) {
                    h.generateWSDL(msgContext);
                }
                if ((h = msgContext.getService()) == null) {
                    Message rm = msgContext.getRequestMessage();
                    if (rm != null) {
                        rm.getSOAPEnvelope().getFirstBody();
                        h = msgContext.getService();
                    }
                    if (h == null) {
                        throw new AxisFault("Server.NoService", JavaUtils.getMessage("noService05", "" + msgContext.getTargetService()), null, null);
                    }
                }
                h.generateWSDL(msgContext);
                h = this.getGlobalResponse();
                if (h != null) {
                    h.generateWSDL(msgContext);
                }
                if (transportChain != null && (h = transportChain.getResponseHandler()) != null) {
                    h.generateWSDL(msgContext);
                }
            }
            catch (AxisFault e) {
                throw e;
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "AxisServer::generateWSDL"));
        }
    }
}

