/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.io.File;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.AxisServerFactory;

public class DefaultAxisServerFactory
implements AxisServerFactory {
    public AxisServer getServer(Map environment) throws AxisFault {
        File attdirFile;
        EngineConfiguration config = null;
        try {
            config = (EngineConfiguration)environment.get("engineConfig");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        AxisServer ret = DefaultAxisServerFactory.createNewServer(config);
        String attachmentsdirservlet = null;
        if (ret != null && environment != null) {
            attachmentsdirservlet = (String)environment.get("axis.attachments.Directory");
            if (attachmentsdirservlet != null) {
                ret.setOption("attachments.Directory", attachmentsdirservlet);
            }
            if ((attachmentsdirservlet = (String)ret.getOption("attachments.Directory")) == null && (attachmentsdirservlet = (String)environment.get("servlet.realpath")) != null) {
                ret.setOption("attachments.Directory", attachmentsdirservlet);
            }
        }
        if (ret != null && !(attdirFile = new File(attachmentsdirservlet = (String)ret.getOption("attachments.Directory"))).isDirectory()) {
            attdirFile.mkdirs();
        }
        return ret;
    }

    private static AxisServer createNewServer(EngineConfiguration config) {
        String configClass;
        if (config == null && (configClass = System.getProperty("axis.engineConfigClass")) != null) {
            try {
                Class<?> cls = Class.forName(configClass);
                config = (EngineConfiguration)cls.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (config == null) {
            return new AxisServer();
        }
        return new AxisServer(config);
    }
}

