/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.AxisServerFactory;

public class JNDIAxisServerFactory
implements AxisServerFactory {
    public AxisServer getServer(Map environment) throws AxisFault {
        AxisServer server = null;
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        EngineConfiguration config = null;
        try {
            config = (EngineConfiguration)environment.get("engineConfig");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (context != null) {
            ServletContext servletContext = (ServletContext)environment.get("servletContext");
            if (servletContext != null) {
                String name = servletContext.getRealPath("/WEB-INF/Server");
                try {
                    server = (AxisServer)context.lookup(name);
                }
                catch (NamingException e) {
                    server = JNDIAxisServerFactory.createNewServer(config);
                    try {
                        context.bind(name, (Object)server);
                    }
                    catch (NamingException e1) {}
                }
            } else {
                server = JNDIAxisServerFactory.createNewServer(config);
            }
        }
        return server;
    }

    private static AxisServer createNewServer(EngineConfiguration config) {
        if (config != null) {
            return new AxisServer(config);
        }
        String configClass = System.getProperty("axis.engineConfigClass");
        if (configClass != null) {
            try {
                Class<?> cls = Class.forName(configClass);
                config = (EngineConfiguration)cls.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (config == null) {
            return new AxisServer();
        }
        return new AxisServer(config);
    }
}

