/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.ServletEngineConfigurationFactory;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFaultElement;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class AxisServlet
extends HttpServlet {
    protected static Log log;
    private String transportName = "http";
    private AxisEngine engine = null;
    private ServletSecurityProvider securityProvider = null;
    private boolean enableList = false;
    private static final String AXIS_ENGINE = "AxisEngine";
    private boolean isDebug = false;
    private String webInfPath = null;
    private String jwsClassDir = null;
    private String homeDir = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.transport.http.AxisServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public void init() {
        String param;
        ServletContext context = this.getServletConfig().getServletContext();
        this.webInfPath = context.getRealPath("/WEB-INF");
        this.homeDir = context.getRealPath("/");
        this.isDebug = log.isDebugEnabled();
        if (this.isDebug) {
            log.debug((Object)"In servlet init");
        }
        if ((param = this.getInitParameter("transport.name")) == null) {
            param = context.getInitParameter("transport.name");
        }
        if (param != null) {
            this.transportName = param;
        }
        if ((param = this.getInitParameter("use-servlet-security")) != null && param.equalsIgnoreCase("true")) {
            this.securityProvider = new ServletSecurityProvider();
        }
        if ((param = System.getProperty("axis.enableListQuery")) != null && param.equalsIgnoreCase("true")) {
            this.enableList = true;
        }
        this.jwsClassDir = (param = System.getProperty("axis.jws.servletClassDir")) != null ? String.valueOf(this.homeDir) + param : context.getRealPath("/");
    }

    public AxisServer getEngine() throws AxisFault {
        return AxisServlet.getEngine(this);
    }

    public static AxisServer getEngine(HttpServlet servlet) throws AxisFault {
        ServletContext context = servlet.getServletContext();
        if (context.getAttribute(AXIS_ENGINE) == null) {
            String webInfPath = context.getRealPath("/WEB-INF");
            EngineConfiguration config = new ServletEngineConfigurationFactory(context).getServerEngineConfig();
            HashMap<String, Object> environment = new HashMap<String, Object>();
            environment.put("servletContext", context);
            String attdir = servlet.getInitParameter("axis.attachments.Directory");
            if (attdir != null) {
                environment.put("axis.attachments.Directory", attdir);
            }
            if (webInfPath != null) {
                environment.put("servlet.realpath", String.valueOf(webInfPath) + File.separator + "attachments");
            }
            environment.put("engineConfig", config);
            context.setAttribute(AXIS_ENGINE, (Object)AxisServer.getServer(environment));
        }
        return (AxisServer)context.getAttribute(AXIS_ENGINE);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.isDebug) {
            log.debug((Object)"In doGet");
        }
        PrintWriter writer = res.getWriter();
        if (this.engine == null) {
            try {
                this.engine = this.getEngine();
            }
            catch (AxisFault fault) {
                res.setContentType("text/html");
                writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                writer.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                writer.println("<pre>" + fault.toString() + " </pre>");
                return;
            }
        }
        ServletContext context = this.getServletConfig().getServletContext();
        MessageContext msgContext = new MessageContext(this.engine);
        msgContext.setProperty("jws.classDir", this.jwsClassDir);
        msgContext.setProperty("home.dir", this.homeDir);
        String realpath = context.getRealPath(req.getServletPath());
        String configPath = this.webInfPath;
        if (realpath != null) {
            block29: {
                msgContext.setProperty("path", req.getServletPath());
                msgContext.setProperty("realpath", realpath);
                msgContext.setProperty("configPath", configPath);
                msgContext.setTransportName(this.transportName);
                msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
                msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
                msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
                msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.webInfPath);
                msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, req.getPathInfo());
                msgContext.setProperty("Authorization", req.getHeader("Authorization"));
                msgContext.setProperty("remoteaddr", req.getRemoteAddr());
                try {
                    try {
                        String url = HttpUtils.getRequestURL((HttpServletRequest)req).toString();
                        msgContext.setProperty(MessageContext.TRANS_URL, url);
                        boolean wsdlRequested = false;
                        boolean listRequested = false;
                        String queryString = req.getQueryString();
                        if (queryString != null) {
                            if (queryString.equalsIgnoreCase("wsdl")) {
                                wsdlRequested = true;
                            } else if (queryString.equalsIgnoreCase("list")) {
                                listRequested = true;
                            }
                        }
                        if (wsdlRequested) {
                            this.engine.generateWSDL(msgContext);
                            Document doc = (Document)msgContext.getProperty("WSDL");
                            if (doc != null) {
                                res.setContentType("text/xml");
                                XMLUtils.DocumentToWriter(doc, writer);
                            } else {
                                res.setContentType("text/html");
                                writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                                writer.println("<p>" + JavaUtils.getMessage("noWSDL00") + "</p>");
                            }
                            break block29;
                        }
                        if (listRequested) {
                            if (this.enableList) {
                                Document doc = Admin.listConfig(this.engine);
                                if (doc != null) {
                                    res.setContentType("text/xml");
                                    XMLUtils.DocumentToWriter(doc, writer);
                                } else {
                                    res.setContentType("text/html");
                                    writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                                    writer.println("<p>" + JavaUtils.getMessage("noDeploy00") + "</p>");
                                }
                            } else {
                                res.setContentType("text/html");
                                writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                                writer.println("<p><i>?list</i>" + JavaUtils.getMessage("disabled00") + "</p>");
                            }
                            break block29;
                        }
                        if (req.getParameterNames().hasMoreElements()) {
                            res.setContentType("text/html");
                            Enumeration enumeration = req.getParameterNames();
                            String method = null;
                            String args = "";
                            while (enumeration.hasMoreElements()) {
                                String param = (String)enumeration.nextElement();
                                if (param.equalsIgnoreCase("method")) {
                                    method = req.getParameter(param);
                                    continue;
                                }
                                args = String.valueOf(args) + "<" + param + ">" + req.getParameter(param) + "</" + param + ">";
                            }
                            if (method == null) {
                                writer.println("<h2>" + JavaUtils.getMessage("error00") + ":  " + JavaUtils.getMessage("invokeGet00") + "</h2>");
                                writer.println("<p>" + JavaUtils.getMessage("noMethod01") + "</p>");
                            } else {
                                String body = "<" + method + ">" + args + "</" + method + ">";
                                String msgtxt = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + body + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
                                ByteArrayInputStream istream = new ByteArrayInputStream(msgtxt.getBytes());
                                Message msg = new Message(istream, false);
                                msgContext.setRequestMessage(msg);
                                this.engine.invoke(msgContext);
                                Message respMsg = msgContext.getResponseMessage();
                                if (respMsg != null) {
                                    writer.println("<p>" + JavaUtils.getMessage("gotResponse00") + "</p>");
                                    writer.println(respMsg.getSOAPPart().getAsString());
                                } else {
                                    writer.println("<p>" + JavaUtils.getMessage("noResponse01") + "</p>");
                                }
                            }
                            break block29;
                        }
                        res.setContentType("text/html");
                        writer.println("<h1>" + req.getRequestURI() + "</h1>");
                        writer.println("<p>" + JavaUtils.getMessage("axisService00") + "</p>");
                        writer.println("<i>" + JavaUtils.getMessage("perhaps00") + "</i>");
                    }
                    catch (AxisFault fault) {
                        res.setContentType("text/html");
                        writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                        writer.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                        writer.println("<pre>" + fault.toString() + " </pre>");
                    }
                    catch (Exception e) {
                        res.setContentType("text/html");
                        writer.println("<h2>" + JavaUtils.getMessage("error00") + "</h2>");
                        writer.println("<p>" + JavaUtils.getMessage("somethingWrong00") + "</p>");
                        writer.println("<pre>Exception - " + e + "<br>");
                        e.printStackTrace(res.getWriter());
                        writer.println("</pre>");
                    }
                }
                catch (Throwable throwable) {}
            }
            writer.close();
            return;
        }
        res.setContentType("text/html");
        writer.println("<html><h1>Axis HTTP Servlet</h1>");
        writer.println(JavaUtils.getMessage("reachedServlet00"));
        writer.println("<p>" + JavaUtils.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
        writer.println("</html>");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.isDebug) {
            log.debug((Object)"In doPost");
        }
        if (this.engine == null) {
            try {
                this.engine = this.getEngine();
            }
            catch (AxisFault fault) {
                log.debug((Object)fault);
                Message msg = new Message(fault);
                res.setContentType(msg.getContentType());
                res.setContentLength(msg.getContentLength());
                msg.writeContentToStream((OutputStream)res.getOutputStream());
                return;
            }
        }
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        res.setBufferSize(8192);
        if (this.engine == null) {
            this.engine = (AxisEngine)context.getAttribute(AXIS_ENGINE);
        }
        if (this.engine == null) {
            ServletException se = new ServletException(JavaUtils.getMessage("noEngine00"));
            log.debug((Object)se);
            throw se;
        }
        MessageContext msgContext = new MessageContext(this.engine);
        if (this.isDebug) {
            log.debug((Object)("MessageContext:" + msgContext));
        }
        if (this.isDebug) {
            log.debug((Object)("HEADER_CONTENT_TYPE:" + req.getHeader("Content-Type")));
        }
        if (this.isDebug) {
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + req.getHeader("Content-Location")));
        }
        Message msg = new Message(req.getInputStream(), false, req.getHeader("Content-Type"), req.getHeader("Content-Location"));
        if (this.isDebug) {
            log.debug((Object)("Message:" + msg));
        }
        msgContext.setRequestMessage(msg);
        msgContext.setTransportName(this.transportName);
        msgContext.setProperty("jws.classDir", this.jwsClassDir);
        msgContext.setProperty("home.dir", this.homeDir);
        msgContext.setProperty("path", req.getServletPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.webInfPath);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, req.getPathInfo());
        msgContext.setProperty("Authorization", req.getHeader("Authorization"));
        msgContext.setProperty("remoteaddr", req.getRemoteAddr());
        if (this.securityProvider != null) {
            msgContext.setProperty("securityProvider", this.securityProvider);
        }
        if (this.isDebug) {
            log.debug((Object)("Constants.MC_HOME_DIR:" + context.getRealPath("/")));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + req.getServletPath()));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + this.webInfPath));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + req.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + req.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + req.getRemoteAddr()));
            log.debug((Object)("securityProvider:" + this.securityProvider));
        }
        String tmp = req.getHeader("SOAPAction");
        if (this.isDebug) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + tmp));
        }
        try {
            if (tmp == null) {
                AxisFault af = new AxisFault("Client.NoSOAPAction", JavaUtils.getMessage("noHeader00", "SOAPAction"), null, null);
                log.debug((Object)af);
                throw af;
            }
            if ("".equals(tmp)) {
                tmp = req.getContextPath();
            }
            if (tmp != null) {
                msgContext.setUseSOAPAction(true);
                msgContext.setSOAPActionURI(tmp);
            }
            msgContext.setSession(new AxisHttpSession(req));
            String realpath = context.getRealPath(req.getServletPath());
            if (realpath != null) {
                msgContext.setProperty("realpath", realpath);
            }
            String configPath = this.webInfPath;
            if (this.isDebug) {
                log.debug((Object)("configPath:" + configPath));
            }
            msgContext.setProperty("configPath", configPath);
            if (this.isDebug) {
                log.debug((Object)"Invoking Axis Engine.");
            }
            this.engine.invoke(msgContext);
            if (this.isDebug) {
                log.debug((Object)"Return from Axis Engine.");
            }
        }
        catch (Exception e2) {
            AxisFault e2;
            log.debug((Object)e2);
            if (e2 instanceof AxisFault) {
                AxisFault af = (AxisFault)e2;
                if ("Server.Unauthorized".equals(af.getFaultCode().getLocalPart())) {
                    res.setStatus(401);
                } else {
                    res.setStatus(500);
                }
            } else {
                res.setStatus(500);
            }
            if (!(e2 instanceof AxisFault)) {
                e2 = AxisFault.makeFault(e2);
            }
            if (msg == null) {
                msg = new Message(e2);
                msgContext.setResponseMessage(msg);
            }
            try {
                SOAPEnvelope env = msg.getSOAPEnvelope();
                env.clearBody();
                env.addBodyElement(new SOAPFaultElement(e2));
                msgContext.setResponseMessage(msg);
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
        }
        if ((msg = msgContext.getResponseMessage()) == null) {
            if (this.isDebug) {
                log.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
            String resp = JavaUtils.getMessage("noData00");
            res.setContentLength(resp.getBytes().length);
            res.getWriter().print(resp);
        } else {
            if (this.isDebug) {
                log.debug((Object)("Returned Content-Type:" + msg.getContentType()));
            }
            int respContentlength = 0;
            res.setContentType(msg.getContentType());
            respContentlength = msg.getContentLength();
            res.setContentLength(respContentlength);
            if (this.isDebug) {
                log.debug((Object)("Returned Content-Length:" + respContentlength));
            }
            msg.writeContentToStream((OutputStream)res.getOutputStream());
        }
        if (!res.isCommitted()) {
            res.flushBuffer();
        }
        if (this.isDebug) {
            log.debug((Object)"Response sent.");
        }
    }
}

