/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPSender
extends BasicHandler {
    protected static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.transport.http.HTTPSender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "HTTPSender::invoke"));
        }
        String targetURL = null;
        Message outMsg = null;
        String reqEnv = null;
        targetURL = msgContext.getStrProp(MessageContext.TRANS_URL);
        try {
            String action;
            int port = 80;
            URL tmpURL = new URL(targetURL);
            int returnCode = 0;
            boolean useFullURL = false;
            String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
            if (action == null) {
                action = "";
            }
            String host = tmpURL.getHost();
            port = tmpURL.getPort();
            if (port == -1) {
                port = 80;
            }
            Socket sock = null;
            StringBuffer otherHeaders = new StringBuffer();
            if (tmpURL.getProtocol().equalsIgnoreCase("https")) {
                port = tmpURL.getPort();
                if (port == -1) {
                    port = 443;
                }
                String tunnelHost = System.getProperty("https.proxyHost");
                String tunnelPortStr = System.getProperty("https.proxyPort");
                if (tunnelHost == null) {
                    tunnelHost = System.getProperty("http.proxyHost");
                }
                if (tunnelPortStr == null) {
                    tunnelPortStr = System.getProperty("http.proxyPort");
                }
                try {
                    Class<?> SSLSocketFactoryClass = Class.forName("javax.net.ssl.SSLSocketFactory");
                    Class<?> SSLSocketClass = Class.forName("javax.net.ssl.SSLSocket");
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$1 = clazz2;
                    }
                    classArray[0] = clazz;
                    classArray[1] = Integer.TYPE;
                    Method createSocketMethod = SSLSocketFactoryClass.getMethod("createSocket", classArray);
                    Method getDefaultMethod = SSLSocketFactoryClass.getMethod("getDefault", new Class[0]);
                    Method startHandshakeMethod = SSLSocketClass.getMethod("startHandshake", new Class[0]);
                    Object factory = getDefaultMethod.invoke(null, new Object[0]);
                    Object sslSocket = null;
                    if (tunnelHost == null || tunnelHost.equals("")) {
                        sslSocket = createSocketMethod.invoke(factory, host, new Integer(port));
                    } else {
                        Class<?> clazz3;
                        Class[] classArray2 = new Class[4];
                        Class clazz4 = class$2;
                        if (clazz4 == null) {
                            Class clazz5;
                            try {
                                clazz5 = Class.forName("java.net.Socket");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz4 = classArray2[0] = (class$2 = clazz5);
                        }
                        if ((clazz3 = class$1) == null) {
                            Class<?> clazz6;
                            try {
                                clazz6 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz3 = class$1 = clazz6;
                        }
                        classArray2[1] = clazz3;
                        classArray2[2] = Integer.TYPE;
                        classArray2[3] = Boolean.TYPE;
                        Method createSocketMethod2 = SSLSocketFactoryClass.getMethod("createSocket", classArray2);
                        int tunnelPort = tunnelPortStr != null ? (Integer.parseInt(tunnelPortStr) < 0 ? 80 : Integer.parseInt(tunnelPortStr)) : 80;
                        Socket tunnel = new Socket(tunnelHost, tunnelPort);
                        OutputStream tunnelOutputStream = (OutputStream)SSLSocketClass.getMethod("getOutputStream", new Class[0]).invoke((Object)tunnel, new Object[0]);
                        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
                        out.print("CONNECT " + host + ":" + port + " HTTP/1.0\n" + "User-Agent: AxisClient" + "\r\n\r\n");
                        out.flush();
                        InputStream tunnelInputStream = (InputStream)SSLSocketClass.getMethod("getInputStream", new Class[0]).invoke((Object)tunnel, new Object[0]);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)JavaUtils.getMessage("isNull00", "tunnelInputStream", "" + (tunnelInputStream == null)));
                        }
                        String replyStr = "";
                        int newlinesSeen = 0;
                        boolean headerDone = false;
                        while (true) {
                            if (newlinesSeen >= 2) {
                                if (replyStr.startsWith("HTTP/1.0 200") || replyStr.startsWith("HTTP/1.1 200")) break;
                                throw new IOException(JavaUtils.getMessage("cantTunnel00", new String[]{tunnelHost, "" + tunnelPort, replyStr}));
                            }
                            int i = tunnelInputStream.read();
                            if (i < 0) {
                                throw new IOException("Unexpected EOF from proxy");
                            }
                            if (i == 10) {
                                headerDone = true;
                                ++newlinesSeen;
                                continue;
                            }
                            if (i == 13) continue;
                            newlinesSeen = 0;
                            if (headerDone) continue;
                            replyStr = String.valueOf(replyStr) + String.valueOf((char)i);
                        }
                        sslSocket = createSocketMethod2.invoke(factory, tunnel, host, new Integer(port), new Boolean(true));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)JavaUtils.getMessage("setupTunnel00", tunnelHost, "" + tunnelPort));
                        }
                    }
                    startHandshakeMethod.invoke(sslSocket, new Object[0]);
                    sock = (Socket)sslSocket;
                }
                catch (ClassNotFoundException cnfe) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("noJSSE00"));
                    }
                    throw AxisFault.makeFault(cnfe);
                }
                catch (NumberFormatException nfe) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("badProxy00", tunnelPortStr));
                    }
                    throw AxisFault.makeFault(nfe);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("createdSSL00"));
                }
            } else {
                String proxyHost = System.getProperty("http.proxyHost");
                String proxyPort = System.getProperty("http.proxyPort");
                String nonProxyHosts = System.getProperty("http.nonProxyHosts");
                boolean hostInNonProxyList = this.isHostInNonProxyList(host, nonProxyHosts);
                String proxyUsername = System.getProperty("http.proxyUser");
                String proxyPassword = System.getProperty("http.proxyPassword");
                if (proxyUsername != null) {
                    StringBuffer tmpBuf = new StringBuffer();
                    tmpBuf.append(proxyUsername).append(":").append(proxyPassword == null ? "" : proxyPassword);
                    otherHeaders.append("Proxy-Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\n");
                }
                if ((port = tmpURL.getPort()) == -1) {
                    port = 80;
                }
                if (proxyHost == null || proxyHost.equals("") || proxyPort == null || proxyPort.equals("") || hostInNonProxyList) {
                    sock = new Socket(host, port);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("createdHTTP00"));
                    }
                } else {
                    sock = new Socket(proxyHost, (int)new Integer(proxyPort));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)JavaUtils.getMessage("createdHTTP01", proxyHost, proxyPort));
                    }
                    useFullURL = true;
                }
            }
            if (msgContext.getTimeout() != 0) {
                sock.setSoTimeout(msgContext.getTimeout());
            }
            BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream(), 8192);
            String userID = null;
            String passwd = null;
            userID = msgContext.getUsername();
            passwd = msgContext.getPassword();
            if (userID == null && tmpURL.getUserInfo() != null) {
                String info = tmpURL.getUserInfo();
                int sep = info.indexOf(58);
                if (sep >= 0 && sep + 1 < info.length()) {
                    userID = info.substring(0, sep);
                    passwd = info.substring(sep + 1);
                } else {
                    userID = info;
                }
            }
            if (userID != null) {
                StringBuffer tmpBuf = new StringBuffer();
                tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
                otherHeaders.append("Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\n");
            }
            if (msgContext.getMaintainSession()) {
                String cookie = msgContext.getStrProp("Cookie");
                String cookie2 = msgContext.getStrProp("Cookie2");
                if (cookie != null) {
                    otherHeaders.append("Cookie").append(": ").append(cookie).append("\r\n");
                }
                if (cookie2 != null) {
                    otherHeaders.append("Cookie2").append(": ").append(cookie2).append("\r\n");
                }
            }
            StringBuffer header = new StringBuffer();
            header.append("POST").append(" ");
            if (useFullURL) {
                header.append(tmpURL.toExternalForm());
            } else {
                header.append(tmpURL.getFile() == null || tmpURL.getFile().equals("") ? "/" : tmpURL.getFile());
            }
            Message reqMessage = msgContext.getRequestMessage();
            header.append(" HTTP/1.0\r\n").append("Content-Length").append(": ").append(reqMessage.getContentLength()).append("\r\n").append("Host").append(": ").append(host).append("\r\n").append("Content-Type").append(": ").append(reqMessage.getContentType()).append("\r\n").append(otherHeaders == null ? "" : otherHeaders.toString()).append("SOAPAction").append(": \"").append(action).append("\"\r\n");
            header.append("\r\n");
            ((OutputStream)out).write(header.toString().getBytes("iso-8859-1"));
            reqMessage.writeContentToStream(out);
            ((OutputStream)out).flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("xmlSent00"));
                log.debug((Object)"---------------------------------------------------");
                log.debug((Object)(header + reqEnv));
            }
            int len = 0;
            int colonIndex = -1;
            Hashtable<String, String> headers = new Hashtable<String, String>();
            String statusMessage = "";
            BufferedInputStream inp = new BufferedInputStream(sock.getInputStream());
            boolean readTooMuch = false;
            int b = 0;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4097);
            while (true) {
                String value;
                String name;
                byte[] hdata;
                if (!readTooMuch) {
                    b = (byte)inp.read();
                }
                if (b == -1) break;
                readTooMuch = false;
                if (b != 13 && b != 10) {
                    if (b == 58 && colonIndex == -1) {
                        colonIndex = len;
                    }
                    ++len;
                    buf.write(b);
                    continue;
                }
                if (b == 13) continue;
                if (len == 0) break;
                b = (byte)inp.read();
                readTooMuch = true;
                if (b == 32 || b == 9) continue;
                if (colonIndex != -1) {
                    buf.close();
                    hdata = buf.toByteArray();
                    buf.reset();
                    name = new String(hdata, 0, colonIndex, "iso-8859-1");
                    value = new String(hdata, colonIndex + 1, len - 1 - colonIndex, "iso-8859-1");
                    colonIndex = -1;
                } else {
                    buf.close();
                    hdata = buf.toByteArray();
                    buf.reset();
                    name = new String(hdata, 0, len, "iso-8859-1");
                    value = "";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(name) + value));
                }
                if (msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                    int start = name.indexOf(32) + 1;
                    String tmp = name.substring(start).trim();
                    int end = tmp.indexOf(32);
                    if (end != -1) {
                        tmp = tmp.substring(0, end);
                    }
                    returnCode = Integer.parseInt(tmp);
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(returnCode));
                    statusMessage = name.substring(start + end + 1);
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, statusMessage);
                } else {
                    headers.put(name.toLowerCase(), value);
                }
                len = 0;
            }
            String contentType = (String)headers.get("Content-Type".toLowerCase());
            String string2 = contentType = contentType == null ? null : contentType.trim();
            if (!(returnCode > 199 && returnCode < 300 || !contentType.equals("text/html") && returnCode > 499 && returnCode < 600)) {
                ByteArrayOutputStream buf2 = new ByteArrayOutputStream(4097);
                while (true) {
                    byte by = (byte)inp.read();
                    b = by;
                    if (-1 == by) {
                        AxisFault fault = new AxisFault("HTTP", statusMessage, null, null);
                        fault.setFaultDetailString(JavaUtils.getMessage("return01", "" + returnCode, buf2.toString()));
                        throw fault;
                    }
                    buf2.write(b);
                }
            }
            if (b != -1) {
                String contentLocation = (String)headers.get("Content-Location".toLowerCase());
                contentLocation = contentLocation == null ? null : contentLocation.trim();
                String contentLength = (String)headers.get("Content-Length".toLowerCase());
                contentLength = contentLength == null ? null : contentLength.trim();
                outMsg = new Message(inp, false, contentType, contentLocation);
                outMsg.setMessageType("response");
                msgContext.setResponseMessage(outMsg);
                if (log.isDebugEnabled()) {
                    if (contentLength == null) {
                        log.debug((Object)("\n" + JavaUtils.getMessage("no00", "Content-Length")));
                    }
                    log.debug((Object)("\n" + JavaUtils.getMessage("xmlRecd00")));
                    log.debug((Object)"-----------------------------------------------");
                    log.debug((Object)outMsg.getSOAPPart().getAsString());
                }
            }
            if (msgContext.getMaintainSession()) {
                this.handleCookie("Cookie", "Set-Cookie", headers, msgContext);
                this.handleCookie("Cookie2", "Set-Cookie2", headers, msgContext);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "HTTPDispatchHandler::invoke"));
        }
    }

    public void handleCookie(String cookieName, String setCookieName, Hashtable headers, MessageContext msgContext) {
        if (headers.containsKey(setCookieName.toLowerCase())) {
            String cookie = (String)headers.get(setCookieName.toLowerCase());
            int index = (cookie = cookie.trim()).indexOf(59);
            if (index != -1) {
                cookie = cookie.substring(0, index);
            }
            msgContext.setProperty(cookieName, cookie);
        }
    }

    private boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("match00", new String[]{"HTTPSender", host, pattern}));
            }
            if (!HTTPSender.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (isCaseSensitive && ch != strArr[i]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl36
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl36:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl37:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl51
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl51:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl52:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl92
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block27: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (!(isCaseSensitive && ch != strArr[strIdxStart + i + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block27;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl92:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl93:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

