/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.deployment.wsdd.WSDDChain;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.WSDDTransport;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Admin {
    protected static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.utils.Admin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    private static void getOptions(Element root, Handler handler) {
        NodeList list = root.getElementsByTagName("option");
        int i = 0;
        while (list != null && i < list.getLength()) {
            Element elem = (Element)list.item(i);
            String name = elem.getAttribute("name");
            String value = elem.getAttribute("value");
            if (name != null && value != null) {
                handler.setOption(name, value);
            }
            ++i;
        }
    }

    private static void getOptions(Element root, Hashtable table) {
        NodeList list = root.getElementsByTagName("option");
        int i = 0;
        while (list != null && i < list.getLength()) {
            Element elem = (Element)list.item(i);
            String name = elem.getAttribute("name");
            String value = elem.getAttribute("value");
            if (name != null && value != null) {
                table.put(name, value);
            }
            ++i;
        }
    }

    private static void registerTypeMappings(Element root, WSDDService service) throws Exception {
        Element el;
        NodeList list = root.getElementsByTagName("beanMappings");
        int i = 0;
        while (list != null && i < list.getLength()) {
            el = (Element)list.item(i);
            Admin.registerTypes(el, service, true);
            ++i;
        }
        list = root.getElementsByTagName("typeMappings");
        i = 0;
        while (list != null && i < list.getLength()) {
            el = (Element)list.item(i);
            Admin.registerTypes(el, service, false);
            ++i;
        }
    }

    private static void registerTypes(Element root, WSDDTypeMappingContainer container, boolean isBean) throws Exception {
        NodeList list = root.getChildNodes();
        int i = 0;
        while (list != null && i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                Admin.registerTypeMapping((Element)list.item(i), container, isBean);
            }
            ++i;
        }
    }

    public Element[] AdminService(MessageContext msgContext, Vector xml) throws Exception {
        log.debug((Object)JavaUtils.getMessage("enter00", "Admin:AdminService"));
        Document doc = this.process(msgContext, (Element)xml.get(0));
        Element[] result = new Element[]{doc.getDocumentElement()};
        log.debug((Object)JavaUtils.getMessage("exit00", "Admin:AdminService"));
        return result;
    }

    protected static Document processWSDD(AxisEngine engine, Element root) throws Exception {
        Document doc = null;
        WSDDDocument wsddDoc = new WSDDDocument(root);
        EngineConfiguration config = engine.getConfig();
        if (config instanceof FileProvider) {
            FileProvider wsddProvider = (FileProvider)config;
            WSDDDeployment deployment = wsddProvider.getDeployment();
            wsddDoc.deploy(deployment);
        }
        engine.refreshGlobalOptions();
        engine.saveConfiguration();
        doc = XMLUtils.newDocument();
        root = doc.createElementNS("", "Admin");
        doc.appendChild(root);
        root.appendChild(doc.createTextNode(JavaUtils.getMessage("done00")));
        return doc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document process(MessageContext msgContext, Element root) throws Exception {
        String remoteIP;
        String remoteAdmin;
        SOAPService serviceHandler = msgContext.getService();
        if (!(serviceHandler == null || (remoteAdmin = (String)serviceHandler.getOption("enableRemoteAdmin")) != null && remoteAdmin.equals("true") || (remoteIP = msgContext.getStrProp("remoteaddr")) == null || remoteIP.equals("127.0.0.1"))) {
            try {
                InetAddress myAddr = InetAddress.getLocalHost();
                InetAddress remoteAddr = InetAddress.getByName(remoteIP);
                if (!myAddr.equals(remoteAddr)) {
                    throw new AxisFault("Server.Unauthorized", JavaUtils.getMessage("noAdminAccess00"), null, null);
                }
            }
            catch (UnknownHostException e) {
                throw new AxisFault("Server.UnknownHost", JavaUtils.getMessage("unknownHost00"), null, null);
            }
        }
        String rootNS = root.getNamespaceURI();
        String rootName = root.getLocalName();
        AxisEngine engine = msgContext.getAxisEngine();
        if (rootNS != null && rootNS.equals("http://xml.apache.org/axis/wsdd/")) {
            return Admin.processWSDD(engine, root);
        }
        Document doc = null;
        try {
            String action = rootName;
            ClassLoader cl = msgContext.getClassLoader();
            if (!(action.equals("clientdeploy") || action.equals("deploy") || action.equals("undeploy") || action.equals("list") || action.equals("quit") || action.equals("passwd"))) {
                throw new AxisFault("Admin.error", JavaUtils.getMessage("badRootElem00"), null, null);
            }
            if (action.equals("passwd")) {
                String newPassword = root.getFirstChild().getNodeValue();
                engine.setAdminPassword(newPassword);
                doc = XMLUtils.newDocument();
                root = doc.createElementNS("", "Admin");
                doc.appendChild(root);
                root.appendChild(doc.createTextNode(JavaUtils.getMessage("done00")));
                return doc;
            }
            if (action.equals("quit")) {
                log.error((Object)JavaUtils.getMessage("quitRequest00"));
                if (msgContext != null) {
                    msgContext.setProperty(MessageContext.QUIT_REQUESTED, "true");
                }
                doc = XMLUtils.newDocument();
                root = doc.createElementNS("", "Admin");
                doc.appendChild(root);
                root.appendChild(doc.createTextNode(JavaUtils.getMessage("quit00", "")));
                return doc;
            }
            if (action.equals("list")) {
                return Admin.listConfig(engine);
            }
            if (action.equals("clientdeploy")) {
                engine = engine.getClientEngine();
            }
            WSDDDeployment dep = null;
            try {
                FileProvider config = (FileProvider)engine.getConfig();
                dep = config.getDeployment();
            }
            catch (Exception config) {
                // empty catch block
            }
            NodeList list = root.getChildNodes();
            int loop = 0;
            while (loop < list.getLength()) {
                Node node = list.item(loop);
                if (node.getNodeType() == 1) {
                    Element elem = (Element)node;
                    String type = elem.getTagName();
                    String name = elem.getAttribute("name");
                    if (action.equals("undeploy")) {
                        if (type.equals("service")) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)JavaUtils.getMessage("undeploy00", String.valueOf(type) + ": " + name));
                            }
                            dep.undeployService(new QName(null, name));
                        } else {
                            if (!type.equals("handler") && !type.equals("chain")) throw new AxisFault("Admin.error", JavaUtils.getMessage("unknownType00", type), null, null);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)JavaUtils.getMessage("undeploy00", String.valueOf(type) + ": " + name));
                            }
                            dep.undeployHandler(new QName(null, name));
                        }
                    } else if (type.equals("handler")) {
                        Admin.registerHandler(elem, dep);
                    } else if (type.equals("chain")) {
                        Admin.registerChain(elem, dep);
                    } else if (type.equals("service")) {
                        Admin.registerService(elem, dep, engine instanceof AxisServer);
                    } else if (type.equals("transport")) {
                        Admin.registerTransport(elem, dep);
                    } else if (type.equals("beanMappings")) {
                        Admin.registerTypes(elem, dep, true);
                    } else {
                        if (!type.equals("typeMappings")) throw new AxisFault("Admin.error", JavaUtils.getMessage("unknownType01", String.valueOf(action) + ": " + type), null, null);
                        Admin.registerTypes(elem, dep, false);
                    }
                }
                ++loop;
            }
            engine.saveConfiguration();
            doc = XMLUtils.newDocument();
            root = doc.createElementNS("", "Admin");
            doc.appendChild(root);
            root.appendChild(doc.createTextNode(JavaUtils.getMessage("done00")));
            return doc;
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
    }

    public static Document listConfig(AxisEngine engine) throws AxisFault {
        StringWriter writer = new StringWriter();
        SerializationContextImpl context = new SerializationContextImpl(writer, null);
        context.setPretty(true);
        try {
            FileProvider config = (FileProvider)engine.getConfig();
            WSDDDeployment deployment = config.getDeployment();
            deployment.writeToContext(context);
        }
        catch (Exception e) {
            throw new AxisFault(JavaUtils.getMessage("noEngineWSDD"));
        }
        try {
            writer.close();
            return XMLUtils.newDocument(new InputSource(new StringReader(writer.getBuffer().toString())));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void registerChain(Element elem, WSDDDeployment deployment) throws Exception {
        Object tmpH = null;
        String name = elem.getAttribute("name");
        String flow = elem.getAttribute("flow");
        String request = elem.getAttribute("request");
        String pivot = elem.getAttribute("pivot");
        String response = elem.getAttribute("response");
        Hashtable options = new Hashtable();
        if ("".equals(flow)) {
            flow = null;
        }
        if ("".equals(request)) {
            request = null;
        }
        if ("".equals(response)) {
            response = null;
        }
        if ("".equals(pivot)) {
            pivot = null;
        }
        if ("".equals(name)) {
            name = null;
        }
        if (flow != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("deployChain00", name));
            }
            Vector names = new Vector();
            Admin.getOptions(elem, options);
            WSDDChain chain = new WSDDChain();
            chain.setName(name);
            chain.setOptionsHashtable(options);
            StringTokenizer st = new StringTokenizer(flow, " \t\n\r\f,");
            while (st.hasMoreElements()) {
                String handlerName = st.nextToken();
                WSDDHandler handler = new WSDDHandler();
                handler.setType(new QName("", handlerName));
                chain.addHandler(handler);
            }
            deployment.deployHandler(chain);
        }
    }

    public static void registerService(Element elem, WSDDDeployment deployment, boolean isServer) throws Exception {
        String name = elem.getAttribute("name");
        String request = elem.getAttribute("request");
        String pivot = elem.getAttribute("pivot");
        String response = elem.getAttribute("response");
        if (request != null && request.equals("")) {
            request = null;
        }
        if (response != null && response.equals("")) {
            response = null;
        }
        if (pivot != null && pivot.equals("")) {
            pivot = null;
        }
        if (name != null && name.equals("")) {
            name = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("deployService01", name));
        }
        String hName = null;
        Object tmpH = null;
        StringTokenizer st = null;
        if (pivot == null && request == null && response == null) {
            throw new AxisFault("Admin.error", JavaUtils.getMessage("noChains00"), null, null);
        }
        WSDDService serv = new WSDDService();
        serv.setName(name);
        if (request != null && !"".equals(request)) {
            st = new StringTokenizer(request, " \t\n\r\f,");
            WSDDRequestFlow req = new WSDDRequestFlow();
            serv.setRequestFlow(req);
            while (st.hasMoreElements()) {
                hName = st.nextToken();
                WSDDHandler h = new WSDDHandler();
                h.setType(new QName("", hName));
                req.addHandler(h);
            }
        }
        Hashtable opts = new Hashtable();
        Admin.getOptions(elem, opts);
        serv.setOptionsHashtable(opts);
        if (isServer) {
            Handler pivotHandler = deployment.getHandler(new QName("", pivot));
            if (pivotHandler == null) {
                throw new AxisFault(JavaUtils.getMessage("noPivot00", pivot));
            }
            Class<?> pivotClass = pivotHandler.getClass();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.axis.providers.java.RPCProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (pivotClass == clazz) {
                serv.setProviderQName(WSDDConstants.JAVARPC_PROVIDER);
            } else {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.apache.axis.providers.java.MsgProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (pivotClass == clazz2) {
                    serv.setProviderQName(WSDDConstants.JAVAMSG_PROVIDER);
                } else {
                    serv.setParameter("handlerClass", pivotClass.getName());
                    serv.setProviderQName(WSDDConstants.HANDLER_PROVIDER);
                }
            }
        }
        if (response != null && !"".equals(response)) {
            st = new StringTokenizer(response, " \t\n\r\f,");
            WSDDResponseFlow resp = new WSDDResponseFlow();
            serv.setResponseFlow(resp);
            while (st.hasMoreElements()) {
                hName = st.nextToken();
                WSDDHandler h = new WSDDHandler();
                h.setType(new QName("", hName));
                resp.addHandler(h);
            }
        }
        try {
            Admin.registerTypeMappings(elem, serv);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        deployment.deployService(serv);
    }

    public static void registerHandler(Element elem, WSDDDeployment deployment) throws Exception {
        String cls;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = elem.getAttribute("name");
        if (name != null && name.equals("")) {
            name = null;
        }
        if ((cls = elem.getAttribute("class")) != null && cls.equals("")) {
            cls = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("deployHandler00", name));
        }
        WSDDHandler handler = new WSDDHandler();
        handler.setQName(new QName(null, name));
        Admin.getOptions(elem, handler.getParametersTable());
        deployment.deployHandler(handler);
    }

    public static void registerTransport(Element elem, WSDDDeployment deployment) throws Exception {
        WSDDHandler h;
        String name = elem.getAttribute("name");
        String request = elem.getAttribute("request");
        String sender = elem.getAttribute("pivot");
        String response = elem.getAttribute("response");
        Hashtable options = new Hashtable();
        if (request != null && request.equals("")) {
            request = null;
        }
        if (response != null && response.equals("")) {
            response = null;
        }
        if (sender != null && sender.equals("")) {
            sender = null;
        }
        if (name != null && name.equals("")) {
            name = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("deployTransport00", name));
        }
        StringTokenizer st = null;
        Vector reqNames = new Vector();
        Vector respNames = new Vector();
        WSDDTransport transport = new WSDDTransport();
        transport.setName(name);
        if (request != null) {
            WSDDRequestFlow req = new WSDDRequestFlow();
            transport.setRequestFlow(req);
            st = new StringTokenizer(request, " \t\n\r\f,");
            while (st.hasMoreElements()) {
                h = new WSDDHandler();
                h.setType(new QName("", st.nextToken()));
                req.addHandler(h);
            }
        }
        if (response != null) {
            WSDDResponseFlow resp = new WSDDResponseFlow();
            transport.setResponseFlow(resp);
            st = new StringTokenizer(response, " \t\n\r\f,");
            while (st.hasMoreElements()) {
                h = new WSDDHandler();
                h.setType(new QName("", st.nextToken()));
                resp.addHandler(h);
            }
        }
        Admin.getOptions(elem, options);
        transport.setOptionsHashtable(options);
        deployment.deployTransport(transport);
    }

    private static void registerTypeMapping(Element elem, WSDDTypeMappingContainer container, boolean isBean) throws Exception {
        Class<?> cls;
        WSDDTypeMapping mapping = new WSDDTypeMapping();
        String classname = elem.getAttribute("classname");
        if (classname == null || classname.equals("")) {
            throw new AxisFault("Server.Admin.error", JavaUtils.getMessage("noClassname00"), null, null);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            cls = cl.loadClass(classname);
        }
        catch (Exception e) {
            throw new AxisFault("Admin.error", e.toString(), null, null);
        }
        mapping.setLanguageSpecificType(cls);
        if (isBean) {
            String namespaceURI = elem.getNamespaceURI();
            String localName = elem.getLocalName();
            QName qn = new QName(namespaceURI, localName);
            log.debug((Object)JavaUtils.getMessage("registerTypeMap00", "" + qn, classname));
            mapping.setQName(qn);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.apache.axis.encoding.ser.BeanSerializerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            mapping.setSerializer(clazz);
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("org.apache.axis.encoding.ser.BeanDeserializerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            mapping.setDeserializer(clazz2);
        } else {
            String typeName = elem.getAttribute("type");
            int idx = typeName.indexOf(58);
            String prefix = typeName.substring(0, idx);
            String localPart = typeName.substring(idx + 1);
            QName qn = new QName(XMLUtils.getNamespace(prefix, elem), localPart);
            mapping.setQName(qn);
            classname = elem.getAttribute("serializer");
            log.debug((Object)JavaUtils.getMessage("serializer00", classname));
            try {
                cls = cl.loadClass(classname);
                mapping.setSerializer(cls);
            }
            catch (Exception e) {
                throw new AxisFault("Admin.error", JavaUtils.getMessage("noSerializer01", e.toString()), null, null);
            }
            classname = elem.getAttribute("deserializerFactory");
            log.debug((Object)JavaUtils.getMessage("deserFact00", classname));
            try {
                cls = cl.loadClass(classname);
                mapping.setDeserializer(cls);
            }
            catch (Exception e) {
                throw new AxisFault("Admin.error", JavaUtils.getMessage("noDeserFact00", e.toString()), null, null);
            }
        }
        container.deployTypeMapping(mapping);
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        if (args.length < 2 || !args[0].equals("client") && !args[0].equals("server")) {
            log.error((Object)JavaUtils.getMessage("usage00", "Admin client|server <xml-file>"));
            log.error((Object)JavaUtils.getMessage("where00", "<xml-file>"));
            log.error((Object)"<deploy>");
            log.error((Object)"  <handler name=a class=className/>");
            log.error((Object)"  <chain name=a flow=\"a,b,c\" />");
            log.error((Object)"  <chain name=a request=\"a,b,c\" pivot=\"d\"");
            log.error((Object)"                  response=\"e,f,g\" />");
            log.error((Object)"  <service name=a handler=b />");
            log.error((Object)"</deploy>");
            log.error((Object)"<undeploy>");
            log.error((Object)"  <handler name=a/>");
            log.error((Object)"  <chain name=a/>");
            log.error((Object)"  <service name=a/>");
            log.error((Object)"</undeploy>");
            log.error((Object)"<list/>");
            throw new IllegalArgumentException();
        }
        Admin admin = new Admin();
        AxisEngine engine = args[0].equals("client") ? new AxisClient() : new AxisServer();
        engine.setShouldSaveConfig(true);
        engine.init();
        MessageContext msgContext = new MessageContext(engine);
        try {
            i = 1;
            while (i < args.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("process00", args[i]));
                }
                Document doc = XMLUtils.newDocument(new FileInputStream(args[i]));
                admin.process(msgContext, doc.getDocumentElement());
                ++i;
            }
        }
        catch (AxisFault af) {
            log.error((Object)JavaUtils.getMessage("axisFault01", af.dumpToString()));
            throw af;
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("errorProcess00", args[i]), (Throwable)e);
            throw e;
        }
    }
}

