/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.axis.utils.cache.JavaClass;

public class AxisClassLoader
extends ClassLoader {
    static Hashtable classLoaders = new Hashtable();
    Hashtable classCache = new Hashtable();

    public AxisClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public static synchronized AxisClassLoader getClassLoader() {
        ClassLoader baseCL = Thread.currentThread().getContextClassLoader();
        AxisClassLoader cl = null;
        cl = (AxisClassLoader)classLoaders.get(baseCL);
        if (cl == null) {
            cl = new AxisClassLoader();
            classLoaders.put(baseCL, cl);
        }
        return cl;
    }

    public static void removeClassLoader(String name) {
        if (name != null) {
            classLoaders.remove(name);
        }
    }

    public void registerClass(String name, String classFile) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(classFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            baos.write(buf, 0, i);
        }
        fis.close();
        baos.close();
        byte[] data = baos.toByteArray();
        Class<?> cls = this.defineClass(name, data, 0, data.length);
        this.registerClass(name, cls);
    }

    public synchronized void registerClass(String name, Class cls) {
        JavaClass oldClass = (JavaClass)this.classCache.get(name);
        if (oldClass != null && oldClass.getJavaClass() == cls) {
            return;
        }
        this.classCache.put(name, new JavaClass(cls));
    }

    public synchronized void deregisterClass(String name) {
        this.classCache.remove(name);
    }

    public boolean isClassRegistered(String name) {
        return this.classCache != null && this.classCache.get(name) != null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Object obj;
        if (this.classCache != null && (obj = this.classCache.get(name)) != null) {
            return ((JavaClass)obj).getJavaClass();
        }
        Class<?> cls = super.loadClass(name);
        this.registerClass(name, cls);
        return cls;
    }

    public JavaClass lookup(String className) throws ClassNotFoundException {
        JavaClass jc = (JavaClass)this.classCache.get(className);
        if (jc == null) {
            this.loadClass(className);
            jc = (JavaClass)this.classCache.get(className);
        }
        return jc;
    }
}

