/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import com.techtrader.modules.tools.bytecode.BCClass;
import com.techtrader.modules.tools.bytecode.BCMethod;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.LocalVariable;
import com.techtrader.modules.tools.bytecode.LocalVariableTableAttribute;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.encoding.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils {
    protected static Log log;
    private static Hashtable ttClassCache;
    static final String[] keywords;
    static final Collator englishCollator;
    static final char keywordPrefix = '_';
    private static ResourceBundle messages;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.utils.JavaUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        ttClassCache = new Hashtable();
        keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
        englishCollator = Collator.getInstance(Locale.ENGLISH);
        messages = null;
    }

    public static Object convert(Object arg, Class destClass) {
        Class hintClass;
        if (destClass == null) {
            return arg;
        }
        if (log.isDebugEnabled()) {
            String clsName = "null";
            if (arg != null) {
                clsName = arg.getClass().getName();
            }
            log.debug((Object)JavaUtils.getMessage("convert00", clsName, destClass.getName()));
        }
        Object destValue = null;
        if (arg instanceof ConvertCache && (destValue = ((ConvertCache)arg).getConvertedValue(destClass)) != null) {
            return destValue;
        }
        Class destHeldType = JavaUtils.getHolderValueType(destClass);
        Class argHeldType = null;
        if (arg != null) {
            argHeldType = JavaUtils.getHolderValueType(arg.getClass());
        }
        if (arg instanceof Hex) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[B");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (destClass == clazz) {
                return ((Hex)arg).getBytes();
            }
        }
        if (arg instanceof byte[]) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.apache.axis.encoding.Hex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (destClass == clazz) {
                return new Hex((byte[])arg);
            }
        }
        if (!(arg instanceof List) && (arg == null || !arg.getClass().isArray()) && (destHeldType == null && argHeldType == null || destHeldType != null && argHeldType != null)) {
            return arg;
        }
        if (destHeldType != null) {
            Object newArg = JavaUtils.convert(arg, destHeldType);
            Object argHolder = null;
            try {
                argHolder = destClass.newInstance();
                JavaUtils.setHolderValue(argHolder, newArg);
                return argHolder;
            }
            catch (Exception e) {
                return arg;
            }
        }
        if (argHeldType != null) {
            try {
                Object newArg = JavaUtils.getHolderValue(arg);
                return JavaUtils.convert(newArg, destClass);
            }
            catch (HolderException e) {
                return arg;
            }
        }
        if (arg instanceof ConvertCache && ((ConvertCache)arg).getDestClass() != destClass && (hintClass = ((ConvertCache)arg).getDestClass()) != null && hintClass.isArray() && destClass.isArray() && destClass.isAssignableFrom(hintClass) && (destValue = ((ConvertCache)arg).getConvertedValue(destClass = hintClass)) != null) {
            return destValue;
        }
        if (arg == null) {
            return arg;
        }
        int length = 0;
        length = arg.getClass().isArray() ? Array.getLength(arg) : ((List)arg).size();
        if (destClass.isArray()) {
            if (destClass.getComponentType().isPrimitive()) {
                Object array = Array.newInstance(destClass.getComponentType(), length);
                if (arg.getClass().isArray()) {
                    int i = 0;
                    while (i < length) {
                        Array.set(array, i, Array.get(arg, i));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < length) {
                        Array.set(array, i, ((List)arg).get(i));
                        ++i;
                    }
                }
                destValue = array;
            } else {
                Object[] array;
                try {
                    array = (Object[])Array.newInstance(destClass.getComponentType(), length);
                }
                catch (Exception e) {
                    return arg;
                }
                if (arg.getClass().isArray()) {
                    int i = 0;
                    while (i < length) {
                        array[i] = JavaUtils.convert(Array.get(arg, i), destClass.getComponentType());
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < length) {
                        array[i] = JavaUtils.convert(((List)arg).get(i), destClass.getComponentType());
                        ++i;
                    }
                }
                destValue = array;
            }
        } else {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(destClass)) {
                List newList = null;
                try {
                    newList = (List)destClass.newInstance();
                }
                catch (Exception e) {
                    return arg;
                }
                if (arg.getClass().isArray()) {
                    int j = 0;
                    while (j < length) {
                        newList.add(Array.get(arg, j));
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < length) {
                        newList.add(((List)arg).get(j));
                        ++j;
                    }
                }
                destValue = newList;
            } else {
                destValue = arg;
            }
        }
        if (arg instanceof ConvertCache) {
            ((ConvertCache)arg).setConvertedValue(destClass, destValue);
        }
        return destValue;
    }

    public static boolean isJavaId(String id) {
        if (id == null || id.equals("") || JavaUtils.isJavaKeyword(id)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < id.length()) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return String.valueOf('_') + keyword;
    }

    public static String getLoadableClassName(String text) {
        if (text == null || text.indexOf("[") < 0 || text.charAt(0) == '[') {
            return text;
        }
        String className = text.substring(0, text.indexOf("["));
        className = className.equals("byte") ? "B" : (className.equals("char") ? "C" : (className.equals("double") ? "D" : (className.equals("float") ? "F" : (className.equals("int") ? "I" : (className.equals("long") ? "J" : (className.equals("short") ? "S" : (className.equals("boolean") ? "Z" : "L" + className + ";")))))));
        int i = text.indexOf("]");
        while (i > 0) {
            className = "[" + className;
            i = text.indexOf("]", i + 1);
        }
        return className;
    }

    public static String getTextClassName(String text) {
        if (text == null || text.indexOf("[") != 0) {
            return text;
        }
        String className = "";
        int index = 0;
        while (index < text.length() && text.charAt(index) == '[') {
            ++index;
            className = String.valueOf(className) + "[]";
        }
        if (index < text.length()) {
            className = text.charAt(index) == 'B' ? "byte" + className : (text.charAt(index) == 'C' ? "char" + className : (text.charAt(index) == 'D' ? "double" + className : (text.charAt(index) == 'F' ? "float" + className : (text.charAt(index) == 'I' ? "int" + className : (text.charAt(index) == 'J' ? "long" + className : (text.charAt(index) == 'S' ? "short" + className : (text.charAt(index) == 'Z' ? "boolean" + className : String.valueOf(text.substring(index + 1, text.indexOf(";"))) + className)))))));
        }
        return className;
    }

    public static String xmlNameToJava(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        int i = 0;
        while (i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i]))) {
            ++i;
        }
        if (i < nameLen) {
            if (Character.isUpperCase(nameArray[i])) {
                result.append(Character.toLowerCase(nameArray[i]));
            } else {
                result.append(nameArray[i]);
            }
            wordStart = !Character.isLetter(nameArray[i]);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_" + nameArray[0]);
        } else {
            result.append("_" + nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = !Character.isLetter(c);
            }
            ++i;
        }
        String newName = result.toString();
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '_' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static ResourceBundle getMessageResourceBundle() {
        if (messages == null) {
            JavaUtils.initializeMessages();
        }
        return messages;
    }

    public static String getMessage(String key) throws MissingResourceException {
        if (messages == null) {
            JavaUtils.initializeMessages();
        }
        return messages.getString(key);
    }

    public static String getMessage(String key, String var) throws MissingResourceException {
        Object[] args = new String[]{var};
        return MessageFormat.format(JavaUtils.getMessage(key), args);
    }

    public static String getMessage(String key, String var1, String var2) throws MissingResourceException {
        Object[] args = new String[]{var1, var2};
        return MessageFormat.format(JavaUtils.getMessage(key), args);
    }

    public static String getMessage(String key, String[] vars) throws MissingResourceException {
        return MessageFormat.format(JavaUtils.getMessage(key), vars);
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("org.apache.axis.utils.resources");
    }

    public static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new String(sb);
    }

    public static Class getHolderValueType(Class type) {
        if (type != null) {
            Field field;
            Class<?>[] intf = type.getInterfaces();
            boolean isHolder = false;
            int i = 0;
            while (i < intf.length) {
                Class<?> clazz = intf[i];
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("javax.xml.rpc.holders.Holder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    isHolder = true;
                }
                ++i;
            }
            if (!isHolder) {
                return null;
            }
            try {
                field = type.getField("value");
            }
            catch (Exception e) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object holder) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException();
        }
        try {
            Field valueField = holder.getClass().getField("value");
            return valueField.get(holder);
        }
        catch (Exception e) {
            throw new HolderException();
        }
    }

    public static void setHolderValue(Object holder, Object value) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException();
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (valueField.getType().isPrimitive()) {
                if (value != null) {
                    valueField.set(holder, value);
                }
            } else {
                valueField.set(holder, value);
            }
        }
        catch (Exception e) {
            throw new HolderException();
        }
    }

    public static boolean isEnumClass(Class cls) {
        try {
            Method m = cls.getMethod("getValue", null);
            Method m2 = cls.getMethod("toString", null);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method m3 = cls.getMethod("fromString", classArray);
            if (m != null && m2 != null && m3 != null && cls.getMethod("fromValue", m.getReturnType()) != null) {
                try {
                    return cls.getMethod("setValue", m.getReturnType()) == null;
                }
                catch (NoSuchMethodException e) {
                    return true;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static String[] getParameterNamesFromDebugInfo(Method method) {
        BCMethod bmeth;
        Class<?> c = method.getDeclaringClass();
        int numParams = method.getParameterTypes().length;
        Vector<String> temp = new Vector<String>();
        if (numParams == 0) {
            return null;
        }
        BCClass bclass = (BCClass)ttClassCache.get(c);
        if (bclass == null) {
            try {
                bclass = new BCClass(c);
                ttClassCache.put(c, bclass);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((bmeth = bclass.getMethod(method.getName(), (Class[])method.getParameterTypes())) == null) {
            return null;
        }
        Code code = bmeth.getCode();
        if (code == null) {
            return null;
        }
        LocalVariableTableAttribute attr = (LocalVariableTableAttribute)code.getAttribute("LocalVariableTable");
        if (attr == null) {
            return null;
        }
        LocalVariable[] vars = attr.getLocalVariables();
        String[] argNames = new String[numParams + 1];
        argNames[0] = null;
        int j = 0;
        while (j < vars.length) {
            LocalVariable var = vars[j];
            if (!var.getName().equals("this")) {
                if (temp.size() < var.getIndex() + 1) {
                    temp.setSize(var.getIndex() + 1);
                }
                temp.setElementAt(var.getName(), var.getIndex());
            }
            ++j;
        }
        int k = 0;
        int j2 = 0;
        while (j2 < temp.size()) {
            if (temp.elementAt(j2) != null) {
                argNames[++k] = (String)temp.elementAt(j2);
                if (k + 1 == argNames.length) break;
            }
            ++j2;
        }
        return argNames;
    }

    public interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }

    public static class HolderException
    extends Exception {
    }
}

