/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NSStack {
    protected static Log log;
    private static final ArrayList EMPTY;
    private Stack stack = new Stack();
    private NSStack parent = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.utils.NSStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        EMPTY = new ArrayList();
    }

    public NSStack() {
    }

    public NSStack(ArrayList table) {
        this.push(table);
    }

    public NSStack(NSStack parent) {
        this.parent = parent;
    }

    public void push() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("NSPush (" + this.stack.size() + ")"));
        }
        this.stack.push(EMPTY);
    }

    public void push(ArrayList table) {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("NSPush (" + this.stack.size() + ")"));
        }
        if (table.size() == 0) {
            this.stack.push(EMPTY);
        } else {
            this.stack.push(table);
        }
    }

    public ArrayList peek() {
        if (this.stack.isEmpty()) {
            if (this.parent != null) {
                return this.parent.peek();
            }
            return EMPTY;
        }
        return (ArrayList)this.stack.peek();
    }

    public ArrayList pop() {
        if (this.stack.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("NSPop (" + JavaUtils.getMessage("empty00") + ")"));
            }
            if (this.parent != null) {
                return this.parent.pop();
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            ArrayList t = (ArrayList)this.stack.pop();
            log.trace((Object)("NSPop (" + this.stack.size() + ")"));
            return t;
        }
        return (ArrayList)this.stack.pop();
    }

    public void add(String namespaceURI, String prefix) {
        ArrayList<Mapping> table;
        if (this.stack.isEmpty()) {
            this.push();
        }
        if ((table = this.peek()) == EMPTY) {
            table = new ArrayList<Mapping>();
            this.stack.pop();
            this.stack.push(table);
        }
        table.add(new Mapping(namespaceURI, prefix));
    }

    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        if (!this.stack.isEmpty()) {
            int n = this.stack.size() - 1;
            while (n >= 0) {
                ArrayList t = (ArrayList)this.stack.get(n);
                int i = 0;
                while (i < t.size()) {
                    Mapping map = (Mapping)t.get(i);
                    if (map.getNamespaceURI().equals(namespaceURI)) {
                        return map.getPrefix();
                    }
                    ++i;
                }
                --n;
            }
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (!this.stack.isEmpty()) {
            int n = this.stack.size() - 1;
            while (n >= 0) {
                ArrayList t = (ArrayList)this.stack.get(n);
                int i = 0;
                while (i < t.size()) {
                    Mapping map = (Mapping)t.get(i);
                    if (map.getPrefix().equals(prefix)) {
                        return map.getNamespaceURI();
                    }
                    ++i;
                }
                --n;
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("--" + JavaUtils.getMessage("noPrefix00", "" + this, prefix)));
            this.dump("--");
            log.trace((Object)("--" + JavaUtils.getMessage("end00")));
        }
        return null;
    }

    public boolean isDeclared(String namespaceURI) {
        if (!this.stack.isEmpty()) {
            int n = this.stack.size() - 1;
            while (n >= 0) {
                ArrayList t = (ArrayList)this.stack.get(n);
                if (t != null && t != EMPTY) {
                    int i = 0;
                    while (i < t.size()) {
                        if (((Mapping)t.get(i)).getNamespaceURI().equals(namespaceURI)) {
                            return true;
                        }
                        ++i;
                    }
                }
                --n;
            }
        }
        if (this.parent != null) {
            return this.parent.isDeclared(namespaceURI);
        }
        return false;
    }

    public void dump(String dumpPrefix) {
        Enumeration e = this.stack.elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            if (list == null) {
                log.trace((Object)(String.valueOf(dumpPrefix) + JavaUtils.getMessage("nullTable00")));
                continue;
            }
            int i = 0;
            while (i < list.size()) {
                Mapping map = (Mapping)list.get(i);
                log.trace((Object)(String.valueOf(dumpPrefix) + map.getNamespaceURI() + " -> " + map.getPrefix()));
                ++i;
            }
        }
        if (this.parent != null) {
            log.trace((Object)(String.valueOf(dumpPrefix) + "--" + JavaUtils.getMessage("parent00")));
            this.parent.dump(String.valueOf(dumpPrefix) + "--");
        }
    }
}

