/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.utils.DOM2Writer;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    protected static Log log;
    private static DocumentBuilderFactory dbf;
    private static SAXParserFactory saxFactory;
    private static Stack saxParsers;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.utils.XMLUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        dbf = XMLUtils.initDOMFactory();
        saxParsers = new Stack();
        XMLUtils.initSAXFactory(null, true, false);
    }

    public static String xmlEncodeString(String orig) {
        if (orig == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        char[] chars = orig.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '&': {
                    strBuf.append("&amp;");
                    break;
                }
                case '\"': {
                    strBuf.append("&quot;");
                    break;
                }
                case '\'': {
                    strBuf.append("&apos;");
                    break;
                }
                case '<': {
                    strBuf.append("&lt;");
                    break;
                }
                case '\r': {
                    strBuf.append("&#xd;");
                    break;
                }
                case '>': {
                    strBuf.append("&gt;");
                    break;
                }
                default: {
                    if (chars[i] > '\u007f') {
                        strBuf.append("&#");
                        strBuf.append((int)chars[i]);
                        strBuf.append(";");
                        break;
                    }
                    strBuf.append(chars[i]);
                }
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static void initSAXFactory(String factoryClassName, boolean namespaceAware, boolean validating) {
        if (factoryClassName != null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", factoryClassName);
        }
        saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(namespaceAware);
        saxFactory.setValidating(validating);
    }

    public static DocumentBuilderFactory initDOMFactory() {
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
        }
        return dbf;
    }

    public static synchronized SAXParser getSAXParser() {
        try {
            if (saxParsers.empty()) {
                return saxFactory.newSAXParser();
            }
            return (SAXParser)saxParsers.pop();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)JavaUtils.getMessage("parserConfigurationException00"), (Throwable)e);
            return null;
        }
        catch (SAXException se) {
            log.error((Object)JavaUtils.getMessage("SAXException00"), (Throwable)se);
            return null;
        }
    }

    public static synchronized SAXParser releaseSAXParser(SAXParser parser) {
        return saxParsers.push(parser);
    }

    public static Document newDocument() {
        try {
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Document newDocument(InputSource inp) {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ParserErrorHandler());
            return db.parse(inp);
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            return null;
        }
    }

    public static Document newDocument(InputStream inp) {
        return XMLUtils.newDocument(new InputSource(inp));
    }

    public static Document newDocument(String uri) {
        return XMLUtils.newDocument(new InputSource(uri));
    }

    private static String privateElementToString(Element element, boolean omitXMLDecl) {
        return DOM2Writer.nodeToString(element, omitXMLDecl);
    }

    public static String ElementToString(Element element) {
        return XMLUtils.privateElementToString(element, true);
    }

    public static String DocumentToString(Document doc) {
        return XMLUtils.privateElementToString(doc.getDocumentElement(), false);
    }

    public static void privateElementToWriter(Element element, Writer writer, boolean omitXMLDecl, boolean pretty) {
        DOM2Writer.serializeAsXML(element, writer, omitXMLDecl, pretty);
    }

    public static void ElementToStream(Element element, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToStream(Element element, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void ElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void DocumentToStream(Document doc, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToStream(Document doc, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, true);
    }

    public static void DocumentToWriter(Document doc, Writer writer) {
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToWriter(Document doc, Writer writer) {
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, true);
    }

    public static Element StringToElement(String namespace, String name, String string) {
        Document doc = XMLUtils.newDocument();
        Element element = doc.createElementNS(namespace, name);
        Text text = doc.createTextNode(string);
        element.appendChild(text);
        return element;
    }

    public static String getInnerXMLString(Element element) {
        String elementString = XMLUtils.ElementToString(element);
        int start = elementString.indexOf(">") + 1;
        int end = elementString.lastIndexOf("</");
        if (end > 0) {
            return elementString.substring(start, end);
        }
        return null;
    }

    public static String getPrefix(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            int n = 0;
            while (n < attrs.getLength()) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (name.startsWith("xmlns:") && a.getNodeValue().equals(uri)) {
                    return name.substring(6);
                }
                ++n;
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String prefix, Node e) {
        while (e != null && e.getNodeType() == 1) {
            Attr attr = ((Element)e).getAttributeNodeNS(Constants.NS_URI_XMLNS, prefix);
            if (attr != null) {
                return attr.getValue();
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String str, Node e) {
        if (str == null || e == null) {
            return null;
        }
        int idx = str.indexOf(58);
        if (idx > -1) {
            String prefix = str.substring(0, idx);
            String ns = XMLUtils.getNamespace(prefix, e);
            if (ns == null) {
                return null;
            }
            return new QName(ns, str.substring(idx + 1));
        }
        return new QName("", str);
    }

    public String getStringForQName(QName qname, Element e) {
        String uri = qname.getNamespaceURI();
        String prefix = XMLUtils.getPrefix(uri, e);
        if (prefix == null) {
            int i = 1;
            prefix = "ns" + i;
            while (XMLUtils.getNamespace(prefix, e) != null) {
                prefix = "ns" + ++i;
            }
            e.setAttributeNS(Constants.NS_URI_XMLNS, "xmlns:" + prefix, uri);
        }
        return String.valueOf(prefix) + ":" + qname.getLocalPart();
    }

    private static Hashtable getPrefixes(Document d) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        NodeList list = d.getElementsByTagName("*");
        int i = 0;
        while (i < list.getLength()) {
            Element e = (Element)list.item(i);
            NamedNodeMap attrs = e.getAttributes();
            int n = 0;
            while (n < attrs.getLength()) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (name.startsWith("xmlns:")) {
                    result.put(name.substring(6), "");
                }
                ++n;
            }
            ++i;
        }
        return result;
    }

    public static String getNewPrefix(Document d, String nsUri) {
        Hashtable extantPrefixes = XMLUtils.getPrefixes(d);
        String winner = null;
        int j = 0;
        while (winner == null) {
            String candidate = "ns" + j;
            if (!extantPrefixes.containsKey(candidate)) {
                winner = candidate;
            }
            ++j;
        }
        d.getDocumentElement().setAttributeNS(Constants.NS_URI_XMLNS, "xmlns:" + winner, nsUri);
        return winner;
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        Node tempNode = parentEl.getFirstChild();
        StringBuffer strBuf = new StringBuffer();
        while (tempNode != null) {
            switch (tempNode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData charData = (CharacterData)tempNode;
                    strBuf.append(charData.getData());
                }
            }
            tempNode = tempNode.getNextSibling();
        }
        return strBuf.toString();
    }

    public static class ParserErrorHandler
    implements ErrorHandler {
        protected static Log log;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.axis.utils.XMLUtils$ParserErrorHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log = LogFactory.getLog((String)clazz.getName());
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("warning00", this.getParseExceptionInfo(spe)));
            }
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

