/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.compiler;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.compiler.AbstractCompiler;
import org.apache.axis.utils.compiler.CompilerError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.tools.javac.Main;

public class Javac
extends AbstractCompiler {
    protected static Log log;
    public static final String CLASSIC_CLASS = "sun.tools.javac.Main";
    public static final String MODERN_CLASS = "com.sun.tools.javac.Main";
    private boolean modern = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.utils.compiler.Javac");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public Javac() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            cl.loadClass(MODERN_CLASS);
            this.modern = true;
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)JavaUtils.getMessage("noModernCompiler"));
            try {
                cl.loadClass(CLASSIC_CLASS);
                this.modern = false;
            }
            catch (Exception ex) {
                log.error((Object)JavaUtils.getMessage("noCompiler00"), (Throwable)ex);
                throw new RuntimeException(JavaUtils.getMessage("noCompiler00"));
            }
        }
        log.debug((Object)JavaUtils.getMessage("compilerClass", this.modern ? MODERN_CLASS : CLASSIC_CLASS));
    }

    public boolean compile() throws IOException {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        Main compiler = new Main((OutputStream)err, "javac");
        boolean result = compiler.compile(this.toStringArray(this.fillArguments(new ArrayList())));
        this.errors = new ByteArrayInputStream(err.toByteArray());
        return result;
    }

    protected List parseStream(BufferedReader input) throws IOException {
        if (this.modern) {
            return this.parseModernStream(input);
        }
        return this.parseClassicStream(input);
    }

    protected List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    if (buffer.length() > 0) {
                        errors.add(new CompilerError("\n" + buffer.toString()));
                    }
                    return errors;
                }
                log.debug((Object)line);
                buffer.append(line);
                buffer.append('\n');
            } while (!line.endsWith("^"));
            errors.add(this.parseModernError(buffer.toString()));
        }
    }

    private CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        try {
            String pointer;
            int startcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            String message = tokens.nextToken("\n").substring(1);
            String context = tokens.nextToken("\n");
            int endcolumn = context.indexOf(" ", startcolumn = (pointer = tokens.nextToken("\n")).indexOf("^"));
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, false, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException nse) {
            return new CompilerError(JavaUtils.getMessage("noMoreTokens", error));
        }
        catch (Exception nse) {
            return new CompilerError(JavaUtils.getMessage("cantParse", error));
        }
    }

    protected List parseClassicStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = null;
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            int i = 0;
            while (i < 3) {
                line = input.readLine();
                if (line == null) {
                    return errors;
                }
                log.debug((Object)line);
                buffer.append(line);
                buffer.append('\n');
                ++i;
            }
            if (errors == null) {
                errors = new ArrayList<CompilerError>();
            }
            errors.add(this.parseClassicError(buffer.toString()));
        }
    }

    private CompilerError parseClassicError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        try {
            String pointer;
            int startcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            String last = tokens.nextToken();
            while (tokens.hasMoreElements()) {
                last = String.valueOf(last) + tokens.nextToken();
            }
            tokens = new StringTokenizer(last.trim(), "\n");
            String message = tokens.nextToken();
            String context = tokens.nextToken();
            int endcolumn = context.indexOf(" ", startcolumn = (pointer = tokens.nextToken()).indexOf("^"));
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(String.valueOf(this.srcDir) + File.separator + file, true, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException nse) {
            return new CompilerError(JavaUtils.getMessage("noMoreTokens", error));
        }
        catch (Exception nse) {
            return new CompilerError(JavaUtils.getMessage("cantParse", error));
        }
    }

    public String toString() {
        return JavaUtils.getMessage("sunJavac");
    }
}

