/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.rpc.namespace.QName;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.axis.encoding.DefaultSOAP12TypeMappingImpl;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BaseTypeMapping;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.apache.axis.wsdl.toJava.JavaWriterFactory;
import org.w3c.dom.Document;

public class WSDL2Java {
    protected static final int HELP_OPT = 104;
    protected static final int VERBOSE_OPT = 118;
    protected static final int SERVER_OPT = 115;
    protected static final int SKELETON_DEPLOY_OPT = 83;
    protected static final int NAMESPACE_OPT = 78;
    protected static final int NAMESPACE_FILE_OPT = 102;
    protected static final int OUTPUT_OPT = 111;
    protected static final int SCOPE_OPT = 100;
    protected static final int TEST_OPT = 116;
    protected static final int NOIMPORTS_OPT = 110;
    protected static final int PACKAGE_OPT = 112;
    protected static final int DEBUG_OPT = 68;
    protected static final int ALL_OPT = 97;
    protected static final int TYPEMAPPING_OPT = 84;
    public static final byte NO_EXPLICIT_SCOPE = 0;
    public static final byte APPLICATION_SCOPE = 1;
    public static final byte REQUEST_SCOPE = 16;
    public static final byte SESSION_SCOPE = 17;
    private Emitter emitter;
    private long timeoutms = 45000L;
    JavaWriterFactory writerFactory = new JavaWriterFactory();
    protected static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, JavaUtils.getMessage("optionHelp00")), new CLOptionDescriptor("verbose", 8, 118, JavaUtils.getMessage("optionVerbose00")), new CLOptionDescriptor("server-side", 8, 115, JavaUtils.getMessage("optionSkel00")), new CLOptionDescriptor("skeletonDeploy", 2, 83, JavaUtils.getMessage("optionSkeletonDeploy00")), new CLOptionDescriptor("NStoPkg", 48, 78, JavaUtils.getMessage("optionNStoPkg00")), new CLOptionDescriptor("fileNStoPkg", 2, 102, JavaUtils.getMessage("optionFileNStoPkg00")), new CLOptionDescriptor("package", 2, 112, JavaUtils.getMessage("optionPackage00")), new CLOptionDescriptor("output", 2, 111, JavaUtils.getMessage("optionOutput00")), new CLOptionDescriptor("deployScope", 2, 100, JavaUtils.getMessage("optionScope00")), new CLOptionDescriptor("testCase", 8, 116, JavaUtils.getMessage("optionTest00")), new CLOptionDescriptor("noImports", 8, 110, JavaUtils.getMessage("optionImport00")), new CLOptionDescriptor("all", 8, 97, JavaUtils.getMessage("optionAll00")), new CLOptionDescriptor("Debug", 8, 68, JavaUtils.getMessage("optionDebug00")), new CLOptionDescriptor("typeMappingVersion", 2, 84, JavaUtils.getMessage("optionTypeMapping00"))};
    static /* synthetic */ Class class$0;

    public WSDL2Java() {
        this.emitter = new Emitter(this.writerFactory);
        this.writerFactory.setEmitter(this.emitter);
    }

    public void generateServerSide(boolean value) {
        this.emitter.generateServerSide(value);
    }

    public boolean getGenerateServerSide() {
        return this.emitter.getGenerateServerSide();
    }

    public void deploySkeleton(boolean value) {
        this.emitter.deploySkeleton(value);
    }

    public boolean getDeploySkeleton() {
        return this.emitter.getDeploySkeleton();
    }

    public void generateTestCase(boolean value) {
        this.emitter.generateTestCase(value);
    }

    public Definition getCurrentDefinition() {
        return this.emitter.getCurrentDefinition();
    }

    public void generateImports(boolean generateImports) {
        this.emitter.generateImports(generateImports);
    }

    public void generateAll(boolean all) {
        this.emitter.generateAll(all);
    }

    public void debug(boolean value) {
        this.emitter.debug(value);
    }

    public boolean getDebug() {
        return this.emitter.getDebug();
    }

    public void verbose(boolean value) {
        this.emitter.verbose(value);
    }

    public boolean getVerbose() {
        return this.emitter.getVerbose();
    }

    public void setNamespaceMap(HashMap map) {
        this.emitter.setNamespaceMap(map);
    }

    public void setOutputDir(String outputDir) {
        this.emitter.setOutputDir(outputDir);
    }

    public String getPackageName() {
        return this.emitter.getPackageName();
    }

    public void setPackageName(String packageName) {
        this.emitter.setPackageName(packageName);
    }

    public String getOutputDir() {
        return this.emitter.getOutputDir();
    }

    public void setScope(byte scope) {
        this.emitter.setScope(scope);
    }

    public byte getScope() {
        return this.emitter.getScope();
    }

    public void setNStoPkg(String NStoPkgFilename) {
        this.emitter.setNStoPkg(NStoPkgFilename);
    }

    public void setNStoPkg(File NStoPkgFile) {
        this.emitter.setNStoPkg(NStoPkgFile);
    }

    public long getTimeout() {
        return this.timeoutms;
    }

    public void setTimeout(long timeout) {
        this.timeoutms = timeout;
    }

    public GeneratedFileInfo getGeneratedFileInfo() {
        return this.emitter.getGeneratedFileInfo();
    }

    public List getGeneratedClassNames() {
        return this.emitter.getGeneratedClassNames();
    }

    public List getGeneratedFileNames() {
        return this.emitter.getGeneratedFileNames();
    }

    public void emit(String wsdlURL) throws Exception {
        WSDLRunnable runnable = new WSDLRunnable(this.emitter, wsdlURL);
        Thread wsdlThread = new Thread(runnable);
        long timeout = new Date().getTime() + this.timeoutms;
        wsdlThread.start();
        try {
            if (this.timeoutms > 0L) {
                wsdlThread.join(this.timeoutms);
            } else {
                wsdlThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (wsdlThread.isAlive()) {
            wsdlThread.interrupt();
            throw new Exception(JavaUtils.getMessage("timedOut"));
        }
        if (runnable.getFailure() != null) {
            throw runnable.getFailure();
        }
    }

    public void emit(String context, Document doc) throws IOException, WSDLException {
        this.emitter.emit(context, doc);
    }

    public static void main(String[] args) {
        WSDL2Java wsdl2java = new WSDL2Java();
        boolean bServer = false;
        String skeletonDeploy = null;
        boolean bTestClass = false;
        String wsdlURI = null;
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        boolean bPackageOpt = false;
        String typeMappingVersion = "1.2";
        CLArgsParser parser = new CLArgsParser(args, options);
        if (parser.getErrorString() != null) {
            System.err.println(JavaUtils.getMessage("error01", parser.getErrorString()));
            WSDL2Java.printUsage();
        }
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        try {
            int i = 0;
            while (i < size) {
                CLOption option = (CLOption)clOptions.get(i);
                switch (option.getId()) {
                    case 0: {
                        if (wsdlURI != null) {
                            WSDL2Java.printUsage();
                        }
                        wsdlURI = option.getArgument();
                        break;
                    }
                    case 104: {
                        WSDL2Java.printUsage();
                        break;
                    }
                    case 118: {
                        wsdl2java.verbose(true);
                        break;
                    }
                    case 83: {
                        skeletonDeploy = option.getArgument(0);
                        if (skeletonDeploy.equalsIgnoreCase("true")) {
                            wsdl2java.deploySkeleton(true);
                        } else {
                            wsdl2java.deploySkeleton(false);
                        }
                    }
                    case 115: {
                        bServer = true;
                        wsdl2java.generateServerSide(true);
                        break;
                    }
                    case 78: {
                        String namespace = option.getArgument(0);
                        String packageName = option.getArgument(1);
                        namespaceMap.put(namespace, packageName);
                        break;
                    }
                    case 102: {
                        wsdl2java.setNStoPkg(option.getArgument());
                        break;
                    }
                    case 112: {
                        bPackageOpt = true;
                        wsdl2java.setPackageName(option.getArgument());
                        break;
                    }
                    case 111: {
                        wsdl2java.setOutputDir(option.getArgument());
                        break;
                    }
                    case 100: {
                        String scope = option.getArgument();
                        if ("Application".equals(scope)) {
                            wsdl2java.setScope((byte)1);
                            break;
                        }
                        if ("Request".equals(scope)) {
                            wsdl2java.setScope((byte)16);
                            break;
                        }
                        if ("Session".equals(scope)) {
                            wsdl2java.setScope((byte)17);
                            break;
                        }
                        System.err.println(JavaUtils.getMessage("badScope00", scope));
                        break;
                    }
                    case 116: {
                        bTestClass = true;
                        wsdl2java.generateTestCase(true);
                        break;
                    }
                    case 110: {
                        wsdl2java.generateImports(false);
                        break;
                    }
                    case 97: {
                        wsdl2java.generateAll(true);
                        break;
                    }
                    case 68: {
                        wsdl2java.debug(true);
                        break;
                    }
                    case 84: {
                        String tmValue = option.getArgument();
                        if (tmValue.equals("1.1")) {
                            typeMappingVersion = "1.1";
                            break;
                        }
                        if (tmValue.equals("1.2")) {
                            typeMappingVersion = "1.2";
                            break;
                        }
                        System.out.println(JavaUtils.getMessage("badTypeMappingOption00"));
                    }
                }
                ++i;
            }
            if (wsdlURI == null) {
                WSDL2Java.printUsage();
            }
            if (skeletonDeploy != null && !bServer) {
                System.out.println(JavaUtils.getMessage("badSkeleton00"));
                WSDL2Java.printUsage();
            }
            if (!namespaceMap.isEmpty() && bPackageOpt) {
                System.out.println(JavaUtils.getMessage("badpackage00"));
                WSDL2Java.printUsage();
            }
            if (!namespaceMap.isEmpty()) {
                wsdl2java.setNamespaceMap(namespaceMap);
            }
            wsdl2java.setTypeMappingVersion(typeMappingVersion);
            wsdl2java.emit(wsdlURI);
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public void setTypeMappingVersion(String typeMappingVersion) {
        if (typeMappingVersion.equals("1.1")) {
            this.writerFactory.setBaseTypeMapping(new BaseTypeMapping(){
                final TypeMapping defaultTM = DefaultTypeMappingImpl.create();

                public String getBaseName(javax.wsdl.QName qNameIn) {
                    QName qName = new QName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                    Class cls = this.defaultTM.getClassForQName(qName);
                    if (cls == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(cls.getName());
                }
            });
        } else {
            this.writerFactory.setBaseTypeMapping(new BaseTypeMapping(){
                final TypeMapping defaultTM = DefaultSOAP12TypeMappingImpl.create();

                public String getBaseName(javax.wsdl.QName qNameIn) {
                    QName qName = new QName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                    Class cls = this.defaultTM.getClassForQName(qName);
                    if (cls == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(cls.getName());
                }
            });
        }
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("WSDL2Java " + JavaUtils.getMessage("emitter00")).append(lSep);
        StringBuffer stringBuffer = new StringBuffer("java ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.wsdl.WSDL2Java");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        msg.append(JavaUtils.getMessage("usage00", stringBuffer.append(clazz.getName()).append(" [options] WSDL-URI").toString())).append(lSep);
        msg.append(JavaUtils.getMessage("options00")).append(lSep);
        msg.append(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
        System.out.println(msg.toString());
        System.exit(1);
    }

    private class WSDLRunnable
    implements Runnable {
        private Emitter emitter;
        private String uri;
        private boolean done = false;
        private Exception failure = null;

        public WSDLRunnable(Emitter emitter, String uri) {
            this.emitter = emitter;
            this.uri = uri;
        }

        public void run() {
            try {
                this.emitter.emit(this.uri);
            }
            catch (Exception e) {
                this.failure = e;
            }
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public Exception getFailure() {
            return this.failure;
        }
    }
}

