/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import org.apache.axis.encoding.DefaultSOAP12TypeMappingImpl;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.BuilderPortTypeClassRep;
import org.apache.axis.wsdl.fromJava.ClassRep;
import org.apache.axis.wsdl.fromJava.DefaultFactory;
import org.apache.axis.wsdl.fromJava.ExceptionRep;
import org.apache.axis.wsdl.fromJava.Java2WSDLFactory;
import org.apache.axis.wsdl.fromJava.MethodRep;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.ParamRep;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Document;

public class Emitter {
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    public static final int MODE_RPC = 0;
    public static final int MODE_DOCUMENT = 1;
    private Class cls;
    private Class implCls;
    private Vector allowedMethods = null;
    private Vector disallowedMethods = null;
    private Vector stopClasses = null;
    private boolean useInheritedMethods = false;
    private String intfNS;
    private String implNS;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private String targetService = null;
    private String description;
    private int mode = 0;
    private TypeMapping tm = null;
    private TypeMapping defaultTM = null;
    private Namespaces namespaces = new Namespaces();
    private Map exceptionMsg = null;
    private ArrayList encodingList;
    private Types types;
    private String clsName;
    private String portTypeName;
    private Java2WSDLFactory factory = new DefaultFactory();
    static /* synthetic */ Class class$0;

    public Emitter() {
        this.exceptionMsg = new HashMap();
    }

    public void emit(String filename1, String filename2) throws Exception {
        Definition intf = this.getIntfWSDL();
        Definition impl = this.getImplWSDL();
        if (filename1 == null) {
            filename1 = String.valueOf(this.getServicePortName()) + "_interface.wsdl";
        }
        if (filename2 == null) {
            filename2 = String.valueOf(this.getServicePortName()) + "_implementation.wsdl";
        }
        Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(intf);
        this.types.insertTypesFragment(doc);
        this.prettyDocumentToFile(doc, filename1);
        doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(impl);
        this.prettyDocumentToFile(doc, filename2);
    }

    public void emit(String filename) throws Exception {
        this.emit(filename, 0);
    }

    public Document emit(int mode) throws Exception {
        Document doc = null;
        Definition def = null;
        switch (mode) {
            case 0: {
                def = this.getWSDL();
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
                this.types.insertTypesFragment(doc);
                break;
            }
            case 1: {
                def = this.getIntfWSDL();
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
                this.types.insertTypesFragment(doc);
                break;
            }
            case 2: {
                def = this.getImplWSDL();
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
                break;
            }
            default: {
                throw new Exception("unrecognized output WSDL mode");
            }
        }
        return doc;
    }

    public String emitToString(int mode) throws Exception {
        Document doc = this.emit(mode);
        StringWriter sw = new StringWriter();
        XMLUtils.PrettyDocumentToWriter(doc, sw);
        return sw.toString();
    }

    public void emit(String filename, int mode) throws Exception {
        Document doc = this.emit(mode);
        if (filename == null) {
            filename = this.getServicePortName();
            switch (mode) {
                case 0: {
                    filename = String.valueOf(filename) + ".wsdl";
                    break;
                }
                case 1: {
                    filename = String.valueOf(filename) + "_interface.wsdl";
                    break;
                }
                case 2: {
                    filename = String.valueOf(filename) + "_implementation.wsdl";
                }
            }
        }
        this.prettyDocumentToFile(doc, filename);
    }

    public Definition getWSDL() throws Exception {
        this.init();
        Definition def = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(def, this.intfNS);
        this.types = new Types(def, this.tm, this.defaultTM, this.namespaces, this.intfNS, this.factory, this.stopClasses);
        Binding binding = this.writeBinding(def, true);
        this.writePortType(def, binding);
        this.writeService(def, binding);
        return def;
    }

    public Definition getIntfWSDL() throws Exception {
        this.init();
        Definition def = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(def, this.intfNS);
        this.types = new Types(def, this.tm, this.defaultTM, this.namespaces, this.intfNS, this.factory, this.stopClasses);
        Binding binding = this.writeBinding(def, true);
        this.writePortType(def, binding);
        return def;
    }

    public Definition getImplWSDL() throws Exception {
        this.init();
        Definition def = WSDLFactory.newInstance().newDefinition();
        this.writeDefinitions(def, this.implNS);
        this.writeImport(def, this.intfNS, this.importUrl);
        Binding binding = this.writeBinding(def, false);
        this.writeService(def, binding);
        return def;
    }

    private void init() throws Exception {
        if (this.encodingList == null) {
            this.clsName = this.cls.getName();
            this.clsName = this.clsName.substring(this.clsName.lastIndexOf(46) + 1);
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(this.clsName);
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(String.valueOf(this.getPortTypeName()) + "Service");
            }
            if (this.getServicePortName() == null) {
                String name = this.getLocationUrl();
                if (name != null && (name = name.lastIndexOf(47) > 0 ? name.substring(name.lastIndexOf(47) + 1) : (name.lastIndexOf(92) > 0 ? name.substring(name.lastIndexOf(92) + 1) : null)) != null && name.endsWith(".jws")) {
                    name = name.substring(0, name.length() - ".jws".length());
                }
                if (name == null || name.equals("")) {
                    name = this.clsName;
                }
                this.setServicePortName(name);
            }
            this.encodingList = new ArrayList();
            this.encodingList.add("http://schemas.xmlsoap.org/soap/encoding/");
            if (this.defaultTM == null || this.defaultTM instanceof DefaultTypeMappingImpl) {
                this.defaultTM = DefaultSOAP12TypeMappingImpl.create();
            }
            if (this.intfNS == null) {
                this.intfNS = this.namespaces.getCreate(this.cls.getPackage().getName());
            }
            if (this.implNS == null) {
                this.implNS = String.valueOf(this.intfNS) + "-impl";
            }
            this.namespaces.put(this.cls.getName(), this.intfNS, "intf");
            this.namespaces.putPrefix(this.implNS, "impl");
        }
    }

    private void writeDefinitions(Definition def, String tns) throws Exception {
        def.setTargetNamespace(tns);
        def.addNamespace("intf", this.intfNS);
        def.addNamespace("impl", this.implNS);
        def.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        def.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        def.addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC");
        def.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
    }

    private void writeImport(Definition def, String tns, String loc) throws Exception {
        Import imp = def.createImport();
        imp.setNamespaceURI(tns);
        if (loc != null && !loc.equals("")) {
            imp.setLocationURI(loc);
        }
        def.addImport(imp);
    }

    private Binding writeBinding(Definition def, boolean add) throws Exception {
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(this.intfNS, String.valueOf(this.getServicePortName()) + "SoapBinding"));
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        String modeStr = this.mode == 0 ? "rpc" : "document";
        soapBinding.setStyle(modeStr);
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        if (add) {
            def.addBinding(binding);
        }
        return binding;
    }

    private void writeService(Definition def, Binding binding) {
        Service service = def.createService();
        service.setQName(new QName(this.implNS, this.getServiceElementName()));
        def.addService(service);
        Port port = def.createPort();
        port.setBinding(binding);
        port.setName(this.getServicePortName());
        SOAPAddressImpl addr = new SOAPAddressImpl();
        addr.setLocationURI(this.locationUrl);
        port.addExtensibilityElement((ExtensibilityElement)addr);
        service.addPort(port);
    }

    private void writePortType(Definition def, Binding binding) throws Exception {
        PortType portType = def.createPortType();
        portType.setUndefined(false);
        portType.setQName(new QName(this.intfNS, this.getPortTypeName()));
        BuilderPortTypeClassRep builder = this.factory.getBuilderPortTypeClassRep();
        ClassRep classRep = builder.build(this.cls, this.useInheritedMethods, this.stopClasses, this.implCls);
        Vector methods = builder.getResolvedMethods(classRep, this.allowedMethods, this.disallowedMethods);
        int i = 0;
        while (i < methods.size()) {
            MethodRep method = (MethodRep)methods.elementAt(i);
            Operation oper = this.writeOperation(def, binding, method);
            this.writeMessages(def, oper, method);
            portType.addOperation(oper);
            ++i;
        }
        def.addPortType(portType);
        binding.setPortType(portType);
    }

    private void writeMessages(Definition def, Operation oper, MethodRep method) throws Exception {
        Input input = def.createInput();
        Message msg = this.writeRequestMessage(def, method);
        input.setMessage(msg);
        oper.setInput(input);
        def.addMessage(msg);
        msg = this.writeResponseMessage(def, method);
        Output output = def.createOutput();
        output.setMessage(msg);
        oper.setOutput(output);
        def.addMessage(msg);
        Vector exceptions = method.getExceptions();
        int i = 0;
        while (i < exceptions.size()) {
            msg = this.writeFaultMessage(def, (ExceptionRep)exceptions.elementAt(i));
            Fault fault = def.createFault();
            fault.setMessage(msg);
            fault.setName(((ExceptionRep)exceptions.elementAt(i)).getName());
            oper.addFault(fault);
            if (def.getMessage(msg.getQName()) == null) {
                def.addMessage(msg);
            }
            ++i;
        }
        Vector<String> names = new Vector<String>();
        int i2 = 0;
        while (i2 < method.getParameters().size()) {
            block11: {
                ParamRep parameter;
                block10: {
                    parameter = (ParamRep)method.getParameters().elementAt(i2);
                    if (i2 != 0) break block10;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.apache.axis.MessageContext");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(parameter.getType())) break block11;
                }
                names.add(parameter.getName());
            }
            ++i2;
        }
        if (names.size() > 0) {
            oper.setParameterOrdering(names);
        }
    }

    private Operation writeOperation(Definition def, Binding binding, MethodRep methodRep) {
        Operation oper = def.createOperation();
        oper.setName(methodRep.getName());
        oper.setUndefined(false);
        this.writeBindingOperation(def, binding, oper, methodRep);
        return oper;
    }

    private void writeBindingOperation(Definition def, Binding binding, Operation oper, MethodRep methodRep) {
        BindingOperation bindingOper = def.createBindingOperation();
        BindingInput bindingInput = def.createBindingInput();
        BindingOutput bindingOutput = def.createBindingOutput();
        bindingOper.setName(oper.getName());
        SOAPOperationImpl soapOper = new SOAPOperationImpl();
        String soapAction = methodRep.getMetaData("soapAction");
        if (soapAction == null) {
            soapAction = "";
        }
        soapOper.setSoapActionURI(soapAction);
        bindingOper.addExtensibilityElement((ExtensibilityElement)soapOper);
        SOAPBodyImpl soapBodyIn = new SOAPBodyImpl();
        if (this.mode == 0) {
            soapBodyIn.setUse("encoded");
            soapBodyIn.setEncodingStyles((List)this.encodingList);
        } else {
            soapBodyIn.setUse("literal");
        }
        if (this.targetService == null) {
            soapBodyIn.setNamespaceURI(this.intfNS);
        } else {
            soapBodyIn.setNamespaceURI(this.targetService);
        }
        String namespace = methodRep.getMetaData("inputNamespace");
        if (namespace != null) {
            soapBodyIn.setNamespaceURI(namespace);
        }
        soapBodyIn.setEncodingStyles((List)this.encodingList);
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBodyIn);
        SOAPBodyImpl soapBodyOut = new SOAPBodyImpl();
        if (this.mode == 0) {
            soapBodyOut.setUse("encoded");
            soapBodyOut.setEncodingStyles((List)this.encodingList);
        } else {
            soapBodyOut.setUse("literal");
        }
        if (this.targetService == null) {
            soapBodyOut.setNamespaceURI(this.intfNS);
        } else {
            soapBodyOut.setNamespaceURI(this.targetService);
        }
        namespace = methodRep.getMetaData("outputNamespace");
        if (namespace != null) {
            soapBodyOut.setNamespaceURI(namespace);
        }
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBodyOut);
        bindingOper.setBindingInput(bindingInput);
        bindingOper.setBindingOutput(bindingOutput);
        binding.addBindingOperation(bindingOper);
    }

    private Message writeRequestMessage(Definition def, MethodRep method) throws Exception {
        Message msg = def.createMessage();
        QName qName = this.createMessageName(def, method.getName(), "Request");
        msg.setQName(qName);
        msg.setUndefined(false);
        Vector parameters = method.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            block8: {
                ParamRep parameter;
                block7: {
                    parameter = (ParamRep)parameters.elementAt(i);
                    if (i != 0) break block7;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.apache.axis.MessageContext");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(parameter.getType())) break block8;
                }
                this.writePartToMessage(def, msg, true, parameter);
            }
            ++i;
        }
        return msg;
    }

    private Message writeResponseMessage(Definition def, MethodRep method) throws Exception {
        Message msg = def.createMessage();
        QName qName = this.createMessageName(def, method.getName(), "Response");
        msg.setQName(qName);
        msg.setUndefined(false);
        ParamRep retParam = method.getReturns();
        this.writePartToMessage(def, msg, false, retParam);
        Vector parameters = method.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            block8: {
                ParamRep parameter;
                block7: {
                    parameter = (ParamRep)parameters.elementAt(i);
                    if (i != 0) break block7;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.apache.axis.MessageContext");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(parameter.getType())) break block8;
                }
                this.writePartToMessage(def, msg, false, parameter);
            }
            ++i;
        }
        return msg;
    }

    private Message writeFaultMessage(Definition def, ExceptionRep exception) throws Exception {
        Message msg;
        block7: {
            String pkgAndClsName = exception.getName();
            String clsName = pkgAndClsName.substring(pkgAndClsName.lastIndexOf(46) + 1, pkgAndClsName.length());
            exception.setName(clsName);
            msg = (Message)this.exceptionMsg.get(pkgAndClsName);
            if (msg != null) break block7;
            msg = def.createMessage();
            QName qName = this.createMessageName(def, clsName, "");
            msg.setQName(qName);
            msg.setUndefined(false);
            Vector parameters = exception.getParameters();
            int i = 0;
            while (i < parameters.size()) {
                block9: {
                    ParamRep parameter;
                    block8: {
                        parameter = (ParamRep)parameters.elementAt(i);
                        if (i != 0) break block8;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.apache.axis.MessageContext");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.equals(parameter.getType())) break block9;
                    }
                    this.writePartToMessage(def, msg, true, parameter);
                }
                ++i;
            }
            this.exceptionMsg.put(pkgAndClsName, msg);
        }
        return msg;
    }

    public String writePartToMessage(Definition def, Message msg, boolean request, ParamRep param) throws Exception {
        if (param == null || param.getType() == Void.TYPE) {
            return null;
        }
        if (request && param.getMode() == ParamRep.OUT) {
            return null;
        }
        if (!request && param.getMode() == ParamRep.IN) {
            return null;
        }
        Part part = def.createPart();
        QName typeQName = this.types.writePartType(param.getType());
        if (typeQName != null) {
            part.setTypeName(typeQName);
            part.setName(param.getName());
        }
        msg.addPart(part);
        return param.getName();
    }

    private QName createMessageName(Definition def, String methodName, String suffix) {
        QName qName = new QName(this.intfNS, methodName.concat(suffix));
        int messageNumber = 1;
        while (def.getMessage(qName) != null) {
            StringBuffer namebuf = new StringBuffer(methodName.concat(suffix));
            namebuf.append(messageNumber);
            qName = new QName(this.intfNS, namebuf.toString());
            ++messageNumber;
        }
        return qName;
    }

    private void prettyDocumentToFile(Document doc, String filename) throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(filename));
        XMLUtils.PrettyDocumentToStream(doc, fos);
        fos.close();
    }

    public Class getCls() {
        return this.cls;
    }

    public void setCls(Class cls) {
        this.cls = cls;
    }

    public void setClsSmart(Class cls, String location) {
        if (cls == null || location == null) {
            return;
        }
        if (location.lastIndexOf(47) > 0) {
            location = location.substring(location.lastIndexOf(47) + 1);
        } else if (location.lastIndexOf(92) > 0) {
            location = location.substring(location.lastIndexOf(92) + 1);
        }
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        Class<?> intf = null;
        int i = 0;
        while (i < constructors.length && intf == null) {
            Class<?>[] parms = constructors[i].getParameterTypes();
            if (parms.length == 1 && parms[0].isInterface() && parms[0].getName() != null && Types.getLocalNameFromFullName(parms[0].getName()).equals(location)) {
                intf = parms[0];
            }
            ++i;
        }
        if (intf != null) {
            this.setCls(intf);
            if (this.implCls == null) {
                this.setImplCls(cls);
            }
        } else {
            this.setCls(cls);
        }
    }

    public void setCls(String className) {
        try {
            this.cls = Class.forName(className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Class getImplCls() {
        return this.implCls;
    }

    public void setImplCls(Class implCls) {
        this.implCls = implCls;
    }

    public void setImplCls(String className) {
        try {
            this.implCls = Class.forName(className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFactory(String className) {
        try {
            this.factory = (Java2WSDLFactory)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFactory(Java2WSDLFactory factory) {
        this.factory = factory;
    }

    public Java2WSDLFactory getFactory() {
        return this.factory;
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String ns) {
        this.intfNS = ns;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String ns) {
        this.implNS = ns;
    }

    public Vector getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            this.allowedMethods = new Vector();
            while (tokenizer.hasMoreTokens()) {
                this.allowedMethods.add(tokenizer.nextToken());
            }
        }
    }

    public void setAllowedMethods(Vector allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public boolean getUseInheritedMethods() {
        return this.useInheritedMethods;
    }

    public void setUseInheritedMethods(boolean useInheritedMethods) {
        this.useInheritedMethods = useInheritedMethods;
    }

    public void setDisallowedMethods(Vector disallowedMethods) {
        this.disallowedMethods = disallowedMethods;
    }

    public void setDisallowedMethods(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            this.disallowedMethods = new Vector();
            while (tokenizer.hasMoreTokens()) {
                this.disallowedMethods.add(tokenizer.nextToken());
            }
        }
    }

    public Vector getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setStopClasses(Vector stopClasses) {
        this.stopClasses = stopClasses;
    }

    public void setStopClasses(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            this.stopClasses = new Vector();
            while (tokenizer.hasMoreTokens()) {
                this.stopClasses.add(tokenizer.nextToken());
            }
        }
    }

    public Vector getStopClasses() {
        return this.stopClasses;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String locationUrl) {
        this.locationUrl = locationUrl;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String importUrl) {
        this.importUrl = importUrl;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String servicePortName) {
        this.servicePortName = servicePortName;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String serviceElementName) {
        this.serviceElementName = serviceElementName;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public void setTargetService(String targetService) {
        this.targetService = targetService;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping tm) {
        this.tm = tm;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public void setDefaultTypeMapping(TypeMapping defaultTM) {
        this.defaultTM = defaultTM;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }
}

