/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.BuilderBeanClassRep;
import org.apache.axis.wsdl.fromJava.Java2WSDLFactory;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Types {
    Definition def;
    Namespaces namespaces = null;
    TypeMapping tm;
    TypeMapping defaultTM;
    String targetNamespace;
    Element wsdlTypesElem = null;
    HashMap schemaTypes = null;
    HashMap schemaElementNames = null;
    HashMap schemaUniqueElementNames = null;
    BuilderBeanClassRep beanBuilder = null;
    Vector stopClasses = null;
    Document docHolder;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    public Types(Definition def, TypeMapping tm, TypeMapping defaultTM, Namespaces namespaces, String targetNamespace, Java2WSDLFactory factory, Vector stopClasses) {
        this.def = def;
        this.createDocumentFragment();
        this.tm = tm;
        this.defaultTM = defaultTM;
        this.namespaces = namespaces;
        this.targetNamespace = targetNamespace;
        this.stopClasses = stopClasses;
        this.schemaElementNames = new HashMap();
        this.schemaUniqueElementNames = new HashMap();
        this.schemaTypes = new HashMap();
        this.beanBuilder = factory.getBuilderBeanClassRep();
    }

    public javax.wsdl.QName writePartType(Class type) throws Exception {
        if (type.getName().equals("void")) {
            return null;
        }
        if (this.isSimpleType(type)) {
            QName qName = this.getTypeQName(type);
            return this.getWsdlQName(qName);
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        return this.writeTypeAsElement(type);
    }

    private javax.wsdl.QName writeTypeAsElement(Class type) throws Exception {
        String elementType;
        javax.wsdl.QName qName = this.writeTypeNamespace(type);
        Element element = this.createRootElement(qName, elementType = this.writeType(type), this.isNullable(type));
        if (element != null) {
            this.writeSchemaElement(qName, element);
        }
        return qName;
    }

    private javax.wsdl.QName writeTypeNamespace(Class type) {
        QName qName = this.getTypeQName(type);
        String pref = this.def.getPrefix(qName.getNamespaceURI());
        if (pref == null) {
            this.def.addNamespace(this.namespaces.getCreatePrefix(qName.getNamespaceURI()), qName.getNamespaceURI());
        }
        return this.getWsdlQName(qName);
    }

    private QName getTypeQName(Class javaType) {
        QName qName = null;
        QName dQName = null;
        if (this.defaultTM != null) {
            dQName = this.defaultTM.getTypeQName(javaType);
        }
        if (this.tm != null) {
            qName = this.tm.getTypeQName(javaType);
        }
        if (qName == null) {
            qName = dQName;
        } else if (qName != null && qName != dQName && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            qName = dQName;
        }
        if (javaType.isArray() && qName != null && Constants.equals(Constants.SOAP_ARRAY, qName)) {
            Class<?> componentType = javaType.getComponentType();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (componentType != clazz) {
                QName cqName = this.getTypeQName(componentType);
                if (this.targetNamespace.equals(cqName.getNamespaceURI())) {
                    qName = new QName(this.targetNamespace, "ArrayOf" + cqName.getLocalPart());
                } else {
                    String pre = this.namespaces.getCreatePrefix(cqName.getNamespaceURI());
                    qName = new QName(this.targetNamespace, "ArrayOf_" + pre + "_" + cqName.getLocalPart());
                }
            }
            return qName;
        }
        if (qName == null) {
            String pkg = Types.getPackageNameFromFullName(javaType.getName());
            String lcl = Types.getLocalNameFromFullName(javaType.getName());
            String ns = this.namespaces.getCreate(pkg);
            String pre = this.namespaces.getCreatePrefix(ns);
            String localPart = lcl.replace('$', '_');
            qName = new QName(ns, localPart);
        }
        return qName;
    }

    public static String getPackageNameFromFullName(String full) {
        if (full.lastIndexOf(46) < 0) {
            return "";
        }
        return full.substring(0, full.lastIndexOf(46));
    }

    public static String getLocalNameFromFullName(String full) {
        if (full.lastIndexOf(46) < 0) {
            return full;
        }
        return full.substring(full.lastIndexOf(46) + 1);
    }

    public void writeSchemaElement(javax.wsdl.QName qName, Element element) {
        Node schemaElem = null;
        NodeList nl = this.wsdlTypesElem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            NamedNodeMap attrs = nl.item(i).getAttributes();
            int n = 0;
            while (n < attrs.getLength()) {
                Attr a = (Attr)attrs.item(n);
                if (a.getName().equals("targetNamespace") && a.getValue().equals(qName.getNamespaceURI())) {
                    schemaElem = (Element)nl.item(i);
                }
                ++n;
            }
            ++i;
        }
        if (schemaElem == null) {
            schemaElem = this.docHolder.createElement("schema");
            this.wsdlTypesElem.appendChild(schemaElem);
            schemaElem.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            schemaElem.setAttribute("targetNamespace", qName.getNamespaceURI());
        }
        schemaElem.appendChild(element);
    }

    private void writeWsdlTypesElement() throws Exception {
        if (this.wsdlTypesElem == null) {
            this.wsdlTypesElem = this.docHolder.createElementNS("wsdl", "types");
        }
    }

    public String writeType(Class type) throws Exception {
        if (this.isSimpleSchemaType(type)) {
            return "xsd:" + this.getTypeQName(type).getLocalPart();
        }
        if (this.isSimpleSoapEncodingType(type)) {
            return "SOAP-ENC:" + this.getTypeQName(type).getLocalPart();
        }
        Serializer ser = null;
        SerializerFactory factory = null;
        factory = this.tm != null ? (SerializerFactory)this.tm.getSerializer(type) : (SerializerFactory)this.defaultTM.getSerializer(type);
        if (factory == null) {
            factory = new BeanSerializerFactory(type, this.getTypeQName(type));
        }
        if (factory != null) {
            ser = (Serializer)factory.getSerializerAs("Axis SAX Mechanism");
        }
        if (ser == null) {
            throw new AxisFault(JavaUtils.getMessage("NoSerializer00", type.getName()));
        }
        javax.wsdl.QName qName = this.writeTypeNamespace(type);
        String componentTypeName = null;
        Class<?> componentType = null;
        if (type.isArray()) {
            componentType = type.getComponentType();
            componentTypeName = this.writeType(componentType);
        }
        String soapTypeName = qName.getLocalPart();
        String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
        String prefixedName = String.valueOf(prefix) + ":" + soapTypeName;
        if (!this.addToTypesList(qName, soapTypeName)) {
            return prefixedName;
        }
        if (type.isArray()) {
            Element complexType = this.docHolder.createElement("complexType");
            this.writeSchemaElement(qName, complexType);
            complexType.setAttribute("name", soapTypeName);
            Element complexContent = this.docHolder.createElement("complexContent");
            complexType.appendChild(complexContent);
            Element restriction = this.docHolder.createElement("restriction");
            complexContent.appendChild(restriction);
            restriction.setAttribute("base", "SOAP-ENC:Array");
            Element attribute = this.docHolder.createElement("attribute");
            restriction.appendChild(attribute);
            attribute.setAttribute("ref", "SOAP-ENC:arrayType");
            attribute.setAttribute("wsdl:arrayType", String.valueOf(componentTypeName) + "[]");
        } else if (Types.isEnumClass(type)) {
            this.writeEnumType(qName, type);
        } else {
            ser.writeSchema(this);
        }
        return prefixedName;
    }

    public static boolean isEnumClass(Class cls) {
        try {
            Method m = cls.getMethod("getValue", null);
            Method m2 = cls.getMethod("toString", null);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method m3 = cls.getMethod("fromString", classArray);
            if (m != null && m2 != null && m3 != null && cls.getMethod("fromValue", m.getReturnType()) != null) {
                try {
                    return cls.getMethod("setValue", m.getReturnType()) == null;
                }
                catch (NoSuchMethodException e) {
                    return true;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void writeEnumType(javax.wsdl.QName qName, Class cls) throws Exception {
        if (!Types.isEnumClass(cls)) {
            return;
        }
        Method m = cls.getMethod("getValue", null);
        Class<?> base = m.getReturnType();
        Element simpleType = this.docHolder.createElement("simpleType");
        this.writeSchemaElement(qName, simpleType);
        simpleType.setAttribute("name", qName.getLocalPart());
        Element restriction = this.docHolder.createElement("restriction");
        simpleType.appendChild(restriction);
        String baseType = this.writeType(base);
        restriction.setAttribute("base", baseType);
        Field[] fields = cls.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int mod = field.getModifiers();
            if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && field.getType() == base) {
                Element enumeration = this.docHolder.createElement("enumeration");
                enumeration.setAttribute("value", field.get(null).toString());
                restriction.appendChild(enumeration);
            }
            ++i;
        }
    }

    private Element createRootElement(javax.wsdl.QName qName, String elementType, boolean nullable) {
        if (!this.addToElementsList(qName)) {
            return null;
        }
        Element element = this.docHolder.createElement("element");
        String name = elementType.substring(elementType.lastIndexOf(":") + 1);
        element.setAttribute("name", name);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public Element createElement(String elementName, String elementType, boolean nullable, Document docHolder) {
        Element element = docHolder.createElement("element");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public Element createAttributeElement(String elementName, String elementType, boolean nullable, Document docHolder) {
        Element element = docHolder.createElement("attribute");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public javax.wsdl.QName getWsdlQName(QName qName) {
        return new javax.wsdl.QName(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public boolean isSimpleSchemaType(Class type) {
        block28: {
            block27: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz || type == Boolean.TYPE || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE) break block27;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.math.BigInteger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz2) break block27;
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz3) break block27;
                Class<?> clazz4 = class$4;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$4 = Class.forName("javax.xml.rpc.namespace.QName");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz4) break block27;
                Class<?> clazz5 = class$5;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$5 = Class.forName("java.util.Calendar");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz5) break block27;
                Class<?> clazz6 = class$6;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$6 = Class.forName("[B");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type != clazz6) break block28;
            }
            return true;
        }
        return false;
    }

    boolean isSimpleSoapEncodingType(Class type) {
        block44: {
            block43: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz) break block43;
                Class<?> clazz2 = class$7;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$7 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz2) break block43;
                Class<?> clazz3 = class$8;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$8 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz3) break block43;
                Class<?> clazz4 = class$9;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$9 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz4) break block43;
                Class<?> clazz5 = class$10;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$10 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz5) break block43;
                Class<?> clazz6 = class$11;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$11 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz6) break block43;
                Class<?> clazz7 = class$12;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$12 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz7) break block43;
                Class<?> clazz8 = class$13;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$13 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz8) break block43;
                Class<?> clazz9 = class$3;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$3 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz9) break block43;
                Class<?> clazz10 = class$14;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$14 = Class.forName("[Ljava.lang.Byte;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type != clazz10) break block44;
            }
            return true;
        }
        return false;
    }

    boolean isSimpleType(Class type) {
        return this.isSimpleSchemaType(type) || this.isSimpleSoapEncodingType(type);
    }

    private String generateUniqueElementName(javax.wsdl.QName qName) {
        Integer count = (Integer)this.schemaUniqueElementNames.get(qName.getNamespaceURI());
        count = count == null ? new Integer(0) : new Integer(count + 1);
        this.schemaUniqueElementNames.put(qName.getNamespaceURI(), count);
        return "el" + count;
    }

    private boolean addToTypesList(javax.wsdl.QName qName, String typeName) {
        boolean added = false;
        ArrayList<String> types = (ArrayList<String>)this.schemaTypes.get(qName.getNamespaceURI());
        if (types == null) {
            types = new ArrayList<String>();
            types.add(typeName);
            this.schemaTypes.put(qName.getNamespaceURI(), types);
            added = true;
        } else if (!types.contains(typeName)) {
            types.add(typeName);
            added = true;
        }
        if (added) {
            String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
            return !prefix.equals("SOAP-ENV") && !prefix.equals("SOAP-ENC") && !prefix.equals("xsd") && !prefix.equals("wsdl") && !prefix.equals("wsdlsoap");
        }
        return false;
    }

    private boolean addToElementsList(javax.wsdl.QName qName) {
        boolean added = false;
        ArrayList<String> elements = (ArrayList<String>)this.schemaElementNames.get(qName.getNamespaceURI());
        if (elements == null) {
            elements = new ArrayList<String>();
            elements.add(qName.getLocalPart());
            this.schemaElementNames.put(qName.getNamespaceURI(), elements);
            added = true;
        } else if (!elements.contains(qName.getLocalPart())) {
            elements.add(qName.getLocalPart());
            added = true;
        }
        return added;
    }

    public boolean isNullable(Class type) {
        return !type.isPrimitive() && (!type.isArray() || type.getComponentType() != Byte.TYPE);
    }

    private void createDocumentFragment() {
        this.docHolder = XMLUtils.newDocument();
    }

    public void insertTypesFragment(Document doc) {
        if (this.wsdlTypesElem != null) {
            doc.getDocumentElement().insertBefore(doc.importNode(this.wsdlTypesElem, true), doc.getDocumentElement().getFirstChild());
        }
    }

    public Vector getStopClasses() {
        return this.stopClasses;
    }

    public BuilderBeanClassRep getBeanBuilder() {
        return this.beanBuilder;
    }

    public Element createElement(String elementName) {
        return this.docHolder.createElement(elementName);
    }
}

