/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.util.HashMap;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.SymTabEntry;

public class BindingEntry
extends SymTabEntry {
    public static final int STYLE_RPC = 0;
    public static final int STYLE_DOCUMENT = 1;
    public static final int TYPE_SOAP = 0;
    public static final int TYPE_HTTP_GET = 1;
    public static final int TYPE_HTTP_POST = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int USE_ENCODED = 0;
    public static final int USE_LITERAL = 1;
    private Binding binding;
    private int bindingType;
    private int bindingStyle;
    private boolean hasLiteral;
    private HashMap attributes;
    private HashMap parameters = new HashMap();

    public BindingEntry(Binding binding, int bindingType, int bindingStyle, boolean hasLiteral, HashMap attributes) {
        super(binding.getQName());
        this.binding = binding;
        this.bindingType = bindingType;
        this.bindingStyle = bindingStyle;
        this.hasLiteral = hasLiteral;
        this.attributes = attributes;
    }

    public Parameters getParameters(Operation operation) {
        return (Parameters)this.parameters.get(operation);
    }

    public HashMap getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap parameters) {
        this.parameters = parameters;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int getBindingType() {
        return this.bindingType;
    }

    public int getBindingStyle() {
        return this.bindingStyle;
    }

    public boolean hasLiteral() {
        return this.hasLiteral;
    }

    public int getInputBodyType(Operation operation) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            return 0;
        }
        return attr.getInputBodyType();
    }

    public int getOutputBodyType(Operation operation) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            return 0;
        }
        return attr.getOutputBodyType();
    }

    public int getFaultBodyType(Operation operation, String faultName) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            return 0;
        }
        HashMap m = attr.getFaultBodyTypeMap();
        if (!m.containsKey(faultName)) {
            return 0;
        }
        return (Integer)m.get(faultName);
    }

    protected static class OperationAttr {
        private int inputBodyType;
        private int outputBodyType;
        private HashMap faultBodyTypeMap;

        public OperationAttr(int inputBodyType, int outputBodyType, HashMap faultBodyTypeMap) {
            this.inputBodyType = inputBodyType;
            this.outputBodyType = outputBodyType;
            this.faultBodyTypeMap = faultBodyTypeMap;
        }

        public int getInputBodyType() {
            return this.inputBodyType;
        }

        public int getOutputBodyType() {
            return this.outputBodyType;
        }

        public HashMap getFaultBodyTypeMap() {
            return this.faultBodyTypeMap;
        }
    }
}

