/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.apache.axis.wsdl.toJava.MessageEntry;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.NoopWriterFactory;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Writer;
import org.apache.axis.wsdl.toJava.WriterFactory;
import org.w3c.dom.Document;

public class Emitter {
    public static final byte NO_EXPLICIT_SCOPE = 0;
    public static final byte APPLICATION_SCOPE = 1;
    public static final byte REQUEST_SCOPE = 16;
    public static final byte SESSION_SCOPE = 17;
    protected Document doc = null;
    protected Definition def = null;
    protected boolean bDebug = false;
    protected boolean bEmitServer = false;
    protected boolean bDeploySkeleton = true;
    protected boolean bEmitTestCase = false;
    protected boolean bVerbose = false;
    protected boolean bGenerateImports = true;
    protected boolean bGenerateAll = false;
    protected String outputDir = null;
    protected String packageName = null;
    protected byte scope = 0;
    protected GeneratedFileInfo fileInfo = new GeneratedFileInfo();
    protected Namespaces namespaces = null;
    protected HashMap delaySetMap = null;
    protected WriterFactory writerFactory = null;
    protected SymbolTable symbolTable = null;
    protected String currentWSDLURI = null;
    protected String NStoPkgFilename = "NStoPkg.properties";
    protected File NStoPkgFile = null;
    private static final int HELP_OPT = 104;
    private static final int VERBOSE_OPT = 118;
    private static final int DEBUG_OPT = 68;
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, JavaUtils.getMessage("optionHelp00")), new CLOptionDescriptor("verbose", 8, 118, JavaUtils.getMessage("optionVerbose00")), new CLOptionDescriptor("Debug", 8, 68, JavaUtils.getMessage("optionDebug00"))};
    static /* synthetic */ Class class$0;

    public Emitter(WriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void emit(String uri) throws IOException, WSDLException {
        if (this.bVerbose) {
            System.out.println(JavaUtils.getMessage("parsing00", uri));
        }
        this.emit(uri, XMLUtils.newDocument(uri));
    }

    public void emit(String context, Document doc) throws IOException, WSDLException {
        this.currentWSDLURI = context;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", this.bVerbose);
        this.def = reader.readWSDL(context, doc);
        this.doc = doc;
        this.namespaces = new Namespaces(this.outputDir);
        if (this.packageName != null) {
            this.namespaces.setDefaultPackage(this.packageName);
        } else {
            this.getNStoPkgFromPropsFile(this.namespaces);
            if (this.delaySetMap != null) {
                this.namespaces.putAll((Map)this.delaySetMap);
            }
        }
        this.symbolTable = new SymbolTable(this.namespaces, this.writerFactory.getBaseTypeMapping(), this.bGenerateImports, this.bDebug);
        this.symbolTable.add(context, this.def, doc);
        this.writerFactory.writerPass(this.def, this.symbolTable);
        if (this.bDebug) {
            this.symbolTable.dump(System.out);
        }
        this.emit(this.def, doc);
        Writer writer = this.writerFactory.getWriter(this.def, this.symbolTable);
        writer.write();
        this.currentWSDLURI = null;
    }

    private void emit(Definition def, Document doc) throws IOException, WSDLException {
        this.writeTypes();
        Iterator it = this.symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                block7: {
                    Writer writer;
                    block5: {
                        SymTabEntry entry;
                        block8: {
                            block6: {
                                block4: {
                                    entry = (SymTabEntry)v.elementAt(i);
                                    writer = null;
                                    if (!(entry instanceof MessageEntry)) break block4;
                                    writer = this.writerFactory.getWriter(((MessageEntry)entry).getMessage(), this.symbolTable);
                                    break block5;
                                }
                                if (!(entry instanceof PortTypeEntry)) break block6;
                                PortTypeEntry pEntry = (PortTypeEntry)entry;
                                if (pEntry.getPortType().isUndefined()) break block7;
                                writer = this.writerFactory.getWriter(pEntry.getPortType(), this.symbolTable);
                                break block5;
                            }
                            if (!(entry instanceof BindingEntry)) break block8;
                            BindingEntry bEntry = (BindingEntry)entry;
                            Binding binding = bEntry.getBinding();
                            if (binding.isUndefined()) break block7;
                            writer = this.writerFactory.getWriter(binding, this.symbolTable);
                            break block5;
                        }
                        if (entry instanceof ServiceEntry) {
                            writer = this.writerFactory.getWriter(((ServiceEntry)entry).getService(), this.symbolTable);
                        }
                    }
                    if (writer != null) {
                        writer.write();
                    }
                }
                ++i;
            }
        }
    }

    private void getNStoPkgFromPropsFile(HashMap namespaces) {
        try {
            Properties mappings = new Properties();
            if (this.NStoPkgFile != null) {
                mappings.load(new FileInputStream(this.NStoPkgFile));
            } else {
                mappings.load(new FileInputStream(this.NStoPkgFilename));
            }
            Enumeration<?> keys = mappings.propertyNames();
            while (keys.hasMoreElements()) {
                try {
                    String key = (String)keys.nextElement();
                    namespaces.put(key, mappings.getProperty(key));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void generateServerSide(boolean value) {
        this.bEmitServer = value;
    }

    public boolean getGenerateServerSide() {
        return this.bEmitServer;
    }

    public void deploySkeleton(boolean value) {
        this.bDeploySkeleton = value;
    }

    public boolean getDeploySkeleton() {
        return this.bDeploySkeleton;
    }

    public void generateTestCase(boolean value) {
        this.bEmitTestCase = value;
    }

    public Definition getCurrentDefinition() {
        return this.def;
    }

    public void generateImports(boolean generateImports) {
        this.bGenerateImports = generateImports;
    }

    public void generateAll(boolean all) {
        this.bGenerateAll = all;
    }

    public void debug(boolean value) {
        this.bDebug = value;
    }

    public boolean getDebug() {
        return this.bDebug;
    }

    public void verbose(boolean value) {
        this.bVerbose = value;
    }

    public boolean getVerbose() {
        return this.bVerbose;
    }

    public void setNamespaceMap(HashMap map) {
        this.delaySetMap = map;
    }

    public HashMap getNamespaceMap() {
        return this.delaySetMap;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setScope(byte scope) {
        this.scope = scope;
    }

    public byte getScope() {
        return this.scope;
    }

    public void setNStoPkg(String NStoPkgFilename) {
        if (NStoPkgFilename != null) {
            this.NStoPkgFilename = NStoPkgFilename;
        }
    }

    public void setNStoPkg(File NStoPkgFile) {
        this.NStoPkgFile = NStoPkgFile;
    }

    public List getGeneratedClassNames() {
        return this.fileInfo.getClassNames();
    }

    public List getGeneratedFileNames() {
        return this.fileInfo.getFileNames();
    }

    public GeneratedFileInfo getGeneratedFileInfo() {
        return this.fileInfo;
    }

    protected void writeTypes() throws IOException {
        Vector types = this.symbolTable.getTypes();
        int i = 0;
        while (i < types.size()) {
            TypeEntry type = (TypeEntry)types.elementAt(i);
            if (type.getNode() != null && type instanceof Type && type.isReferenced() && type.getBaseType() == null) {
                Writer writer = this.writerFactory.getWriter(type, this.symbolTable);
                writer.write();
            }
            ++i;
        }
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public String getWSDLURI() {
        return this.currentWSDLURI;
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer("java ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.wsdl.toJava.Emitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        msg.append(stringBuffer.append(clazz.getName()).append(" [options] WSDL-URI").toString()).append(lSep);
        msg.append(lSep);
        msg.append(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
        System.out.println(msg.toString());
        System.exit(1);
    }

    public static void main(String[] args) {
        String wsdlURI = null;
        HashMap namespaceMap = new HashMap();
        Emitter emitter = new Emitter(new NoopWriterFactory());
        CLArgsParser parser = new CLArgsParser(args, options);
        if (parser.getErrorString() != null) {
            Emitter.printUsage();
        }
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        try {
            int i = 0;
            while (i < size) {
                CLOption option = (CLOption)clOptions.get(i);
                switch (option.getId()) {
                    case 0: {
                        if (wsdlURI != null) {
                            Emitter.printUsage();
                        }
                        wsdlURI = option.getArgument();
                        break;
                    }
                    case 104: {
                        Emitter.printUsage();
                        break;
                    }
                    case 118: {
                        emitter.verbose(true);
                        break;
                    }
                    case 68: {
                        emitter.debug(true);
                    }
                }
                ++i;
            }
            if (wsdlURI == null) {
                Emitter.printUsage();
            }
            emitter.emit(wsdlURI);
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

