/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaComplexTypeWriter
extends JavaWriter {
    private TypeEntry type;
    private Vector elements;
    private Vector attributes;
    private TypeEntry extendType;
    private HashMap elementMappings = null;

    protected JavaComplexTypeWriter(Emitter emitter, TypeEntry type, Vector elements, TypeEntry extendType, Vector attributes) {
        super(emitter, type, "", "java", JavaUtils.getMessage("genType00"), "complexType");
        this.type = type;
        this.elements = elements;
        this.attributes = attributes;
        this.extendType = extendType;
    }

    protected void writeFileBody() throws IOException {
        String valueType = null;
        Node node = this.type.getNode();
        String extendsText = "";
        if (this.extendType != null && !this.type.isSimpleType()) {
            extendsText = " extends " + this.extendType.getName() + " ";
        }
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < this.elements.size()) {
            TypeEntry type = (TypeEntry)this.elements.get(i);
            String elemName = (String)this.elements.get(i + 1);
            String javaName = Utils.xmlNameToJava(elemName);
            if (!javaName.equals(elemName)) {
                if (this.elementMappings == null) {
                    this.elementMappings = new HashMap();
                }
                this.elementMappings.put(Utils.capitalizeFirstChar(javaName), new QName("", elemName));
            }
            names.add(type.getName());
            names.add(javaName);
            i += 2;
        }
        if (this.attributes != null) {
            i = 0;
            while (i < this.attributes.size()) {
                names.add(((TypeEntry)this.attributes.get(i)).getName());
                names.add(Utils.xmlNameToJava((String)this.attributes.get(i + 1)));
                i += 2;
            }
        }
        String implementsText = "";
        if (this.type.isSimpleType()) {
            implementsText = ", org.apache.axis.encoding.SimpleType";
        }
        this.pw.println("public class " + this.className + extendsText + " implements java.io.Serializable" + implementsText + " {");
        int i2 = 0;
        while (i2 < names.size()) {
            String variable = (String)names.get(i2 + 1);
            if (variable.equals("value")) {
                valueType = (String)names.get(i2);
            }
            this.pw.print("    private " + names.get(i2) + " " + variable + ";");
            if (i2 >= this.elements.size()) {
                this.pw.println("  // attribute");
            } else {
                this.pw.println();
            }
            i2 += 2;
        }
        this.pw.println();
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("    }");
        boolean fullConstructorGen = false;
        if (fullConstructorGen) {
            this.pw.println();
            if (names.size() > 0) {
                String variable;
                this.pw.print("    public " + this.className + "(");
                int i3 = 0;
                while (i3 < names.size()) {
                    if (i3 != 0) {
                        this.pw.print(", ");
                    }
                    variable = (String)names.get(i3 + 1);
                    this.pw.print(String.valueOf((String)names.get(i3)) + " " + variable);
                    i3 += 2;
                }
                this.pw.println(") {");
                i3 = 1;
                while (i3 < names.size()) {
                    variable = (String)names.get(i3);
                    this.pw.println("        this." + variable + " = " + variable + ";");
                    i3 += 2;
                }
                this.pw.println("    }");
            }
        }
        this.pw.println();
        int i4 = 0;
        while (i4 < names.size()) {
            String typeName = (String)names.get(i4);
            String name = (String)names.get(i4 + 1);
            String capName = Utils.capitalizeFirstChar(name);
            String get = "get";
            this.pw.println("    public " + typeName + " " + get + capName + "() {");
            this.pw.println("        return " + name + ";");
            this.pw.println("    }");
            this.pw.println();
            this.pw.println("    public void set" + capName + "(" + typeName + " " + name + ") {");
            this.pw.println("        this." + name + " = " + name + ";");
            this.pw.println("    }");
            this.pw.println();
            if (i4 < this.elements.size() && ((TypeEntry)this.elements.elementAt(i4)).getQName().getLocalPart().indexOf("[") > 0) {
                String compName = typeName.substring(0, typeName.lastIndexOf("["));
                int bracketIndex = typeName.indexOf("[");
                String newingName = typeName.substring(0, bracketIndex + 1);
                String newingSuffix = typeName.substring(bracketIndex + 1);
                this.pw.println("    public " + compName + " " + get + capName + "(int i) {");
                this.pw.println("        return " + name + "[i];");
                this.pw.println("    }");
                this.pw.println();
                this.pw.println("    public void set" + capName + "(int i, " + compName + " value) {");
                this.pw.println("        if (this." + name + " == null ||");
                this.pw.println("            this." + name + ".length <= i) {");
                this.pw.println("            " + typeName + " a = new " + newingName + "i + 1" + newingSuffix + ";");
                this.pw.println("            if (this." + name + " != null) {");
                this.pw.println("                for(int j = 0; j < this." + name + ".length; j++)");
                this.pw.println("                    a[j] = this." + name + "[j];");
                this.pw.println("            }");
                this.pw.println("            this." + name + " = a;");
                this.pw.println("        }");
                this.pw.println("        this." + name + "[i] = value;");
                this.pw.println("    }");
                this.pw.println();
            }
            i4 += 2;
        }
        if (this.attributes != null || this.elementMappings != null) {
            boolean wroteFieldType = false;
            this.pw.println("    // " + JavaUtils.getMessage("typeMeta"));
            this.pw.println("    private static org.apache.axis.description.TypeDesc typeDesc =");
            this.pw.println("        new org.apache.axis.description.TypeDesc();");
            this.pw.println();
            this.pw.println("    static {");
            if (this.attributes != null) {
                int i5 = 0;
                while (i5 < this.attributes.size()) {
                    String attrName = (String)this.attributes.get(i5 + 1);
                    String fieldName = Utils.capitalizeFirstChar(Utils.xmlNameToJava(attrName));
                    this.pw.print("        ");
                    if (!wroteFieldType) {
                        this.pw.print("org.apache.axis.description.FieldDesc ");
                        wroteFieldType = true;
                    }
                    this.pw.println("field = new org.apache.axis.description.AttributeDesc();");
                    this.pw.println("        field.setFieldName(\"" + fieldName + "\");");
                    if (!fieldName.equals(attrName)) {
                        this.pw.print("        field.setXmlName(");
                        this.pw.print("new javax.xml.rpc.namespace.QName(null, \"");
                        this.pw.println(String.valueOf(attrName) + "\"));");
                    }
                    this.pw.println("        typeDesc.addFieldDesc(field);");
                    i5 += 2;
                }
            }
            if (this.elementMappings != null) {
                Iterator i6 = this.elementMappings.keySet().iterator();
                while (i6.hasNext()) {
                    String fieldName = (String)i6.next();
                    QName xmlName = (QName)this.elementMappings.get(fieldName);
                    this.pw.print("        ");
                    if (!wroteFieldType) {
                        this.pw.print("org.apache.axis.description.FieldDesc ");
                        wroteFieldType = true;
                    }
                    this.pw.println("field = new org.apache.axis.description.ElementDesc();");
                    this.pw.println("        field.setFieldName(\"" + fieldName + "\");");
                    this.pw.print("        field.setXmlName(new javax.xml.rpc.namespace.QName(\"");
                    this.pw.println(String.valueOf(xmlName.getNamespaceURI()) + "\", \"" + xmlName.getLocalPart() + "\"));");
                    this.pw.println("        typeDesc.addFieldDesc(field);");
                }
            }
            this.pw.println("    };");
            this.pw.println();
            this.pw.println("    /**");
            this.pw.println("     * " + JavaUtils.getMessage("returnTypeMeta"));
            this.pw.println("     */");
            this.pw.println("    public static org.apache.axis.description.TypeDesc getTypeDesc() {");
            this.pw.println("        return typeDesc;");
            this.pw.println("    }");
            this.pw.println();
        }
        if (this.type.isSimpleType() && valueType != null) {
            this.pw.println("    // " + JavaUtils.getMessage("needStringCtor"));
            this.pw.println("    public " + this.className + "(java.lang.String value) {");
            this.pw.println("        this.value = new " + valueType + "(value);");
            this.pw.println("    }");
            this.pw.println();
            this.pw.println("    // " + JavaUtils.getMessage("needToString"));
            this.pw.println("    public String toString() {");
            this.pw.println("        return value.toString();");
            this.pw.println("    }");
            this.pw.println();
        }
        this.pw.println("    public boolean equals(Object obj) {");
        this.pw.println("        // compare elements");
        this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
        this.pw.println("        if (this == obj) return true;");
        this.pw.println("        if (! (obj instanceof " + this.className + ")) return false;");
        if (names.size() == 0) {
            this.pw.println("        return true;");
        } else {
            this.pw.println("        return");
            i4 = 0;
            while (i4 < names.size()) {
                String variableType = (String)names.get(i4);
                String variable = (String)names.get(i4 + 1);
                if (variableType.equals("int") || variableType.equals("long") || variableType.equals("short") || variableType.equals("float") || variableType.equals("double") || variableType.equals("boolean") || variableType.equals("byte")) {
                    this.pw.print("            " + variable + " == other.get" + Utils.capitalizeFirstChar(variable) + "()");
                } else {
                    this.pw.println("            ((" + variable + "==null && other.get" + Utils.capitalizeFirstChar(variable) + "()==null) || ");
                    this.pw.println("             (" + variable + "!=null &&");
                    this.pw.print("              " + variable + ".equals(other.get" + Utils.capitalizeFirstChar(variable) + "())))");
                }
                if (i4 == names.size() - 2) {
                    this.pw.println(";");
                } else {
                    this.pw.println(" &&");
                }
                i4 += 2;
            }
        }
        this.pw.println("    }");
        this.pw.println("}");
        this.pw.close();
    }
}

