/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaDeployWriter;
import org.apache.axis.wsdl.toJava.JavaFaultWriter;
import org.apache.axis.wsdl.toJava.JavaUndeployWriter;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.axis.wsdl.toJava.Writer;

public class JavaDefinitionWriter
implements Writer {
    Writer deployWriter = null;
    Writer undeployWriter = null;
    Emitter emitter;
    Definition definition;
    SymbolTable symbolTable;
    private HashSet importedFiles = new HashSet();

    public JavaDefinitionWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.deployWriter = new JavaDeployWriter(emitter, definition, symbolTable);
        this.undeployWriter = new JavaUndeployWriter(emitter, definition, symbolTable);
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void write() throws IOException {
        if (this.emitter.getGenerateServerSide()) {
            this.deployWriter.write();
            this.undeployWriter.write();
        }
        this.writeFaults();
    }

    private void writeFaults() throws IOException {
        HashMap faults = new HashMap();
        this.collectFaults(this.definition, faults);
        Iterator fi = faults.keySet().iterator();
        while (fi.hasNext()) {
            Fault fault = (Fault)fi.next();
            QName faultQName = (QName)faults.get(fault);
            new JavaFaultWriter(this.emitter, faultQName, fault, this.symbolTable).write();
        }
    }

    private void collectFaults(Definition def, Map faults) throws IOException {
        Vector<String> faultList = new Vector<String>();
        Map imports = def.getImports();
        Object[] importKeys = imports.keySet().toArray();
        int i = 0;
        while (i < importKeys.length) {
            Vector v = (Vector)imports.get(importKeys[i]);
            int j = 0;
            while (j < v.size()) {
                Import imp = (Import)v.get(j);
                if (!this.importedFiles.contains(imp.getLocationURI())) {
                    this.importedFiles.add(imp.getLocationURI());
                    Definition importDef = imp.getDefinition();
                    if (importDef != null) {
                        this.collectFaults(importDef, faults);
                    }
                }
                ++j;
            }
            ++i;
        }
        Map portTypes = def.getPortTypes();
        Iterator pti = portTypes.values().iterator();
        while (pti.hasNext()) {
            PortType portType = (PortType)pti.next();
            if (!this.symbolTable.getPortTypeEntry(portType.getQName()).isReferenced()) continue;
            List operations = portType.getOperations();
            int i2 = 0;
            while (i2 < operations.size()) {
                Operation operation = (Operation)operations.get(i2);
                Map opFaults = operation.getFaults();
                Iterator fi = opFaults.values().iterator();
                while (fi.hasNext()) {
                    Fault f = (Fault)fi.next();
                    String name = Utils.getFullExceptionName(f, this.symbolTable, portType.getQName().getNamespaceURI());
                    if (faultList.contains(name)) continue;
                    faultList.add(name);
                    QName faultQName = new QName(portType.getQName().getNamespaceURI(), Utils.getExceptionName(f));
                    faults.put(f, faultQName);
                }
                ++i2;
            }
        }
    }
}

