/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.QName;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.CollectionType;
import org.apache.axis.wsdl.toJava.DefinedElement;
import org.apache.axis.wsdl.toJava.Element;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;

public class JavaDeployWriter
extends JavaWriter {
    protected Definition definition;
    protected SymbolTable symbolTable;

    protected JavaDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, new QName(definition.getTargetNamespace(), "deploy"), "", "wsdd", JavaUtils.getMessage("genDeploy00"), "deploy");
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    protected void writeFileHeader() throws IOException {
        this.initializeDeploymentDoc("deploy");
    }

    protected void writeFileBody() throws IOException {
        this.writeDeployServices();
        this.pw.println("</deployment>");
        this.pw.close();
    }

    protected void writeDeployServices() throws IOException {
        Map serviceMap = this.definition.getServices();
        Iterator mapIterator = serviceMap.values().iterator();
        while (mapIterator.hasNext()) {
            Service myService = (Service)mapIterator.next();
            this.pw.println();
            this.pw.println("  <!-- " + JavaUtils.getMessage("wsdlService00", myService.getQName().getLocalPart()) + " -->");
            this.pw.println();
            Iterator portIterator = myService.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port myPort = (Port)portIterator.next();
                BindingEntry bEntry = this.symbolTable.getBindingEntry(myPort.getBinding().getQName());
                if (bEntry.getBindingType() != 0) continue;
                this.writeDeployPort(myPort);
            }
        }
    }

    protected void writeDeployTypes(boolean hasLiteral) throws IOException {
        Vector types = this.symbolTable.getTypes();
        this.pw.println();
        int i = 0;
        while (i < types.size()) {
            TypeEntry type = (TypeEntry)types.elementAt(i);
            boolean process = true;
            if (type.getBaseType() != null && type.getRefType() == null || type instanceof CollectionType || type instanceof Element || !type.isReferenced() || type.isOnlyLiteralReferenced()) {
                process = false;
            }
            if (process) {
                this.pw.println("      <typeMapping");
                this.pw.println("        xmlns:ns=\"" + type.getQName().getNamespaceURI() + "\"");
                this.pw.println("        qname=\"ns:" + type.getQName().getLocalPart() + '\"');
                this.pw.println("        type=\"java:" + type.getName() + '\"');
                if (type.getName().endsWith("[]")) {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.ArraySerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.ArrayDeserializerFactory\"");
                } else if (type.getNode() != null && SchemaUtils.getEnumerationBaseAndValues(type.getNode(), this.emitter.getSymbolTable()) != null) {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.EnumSerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.EnumDeserializerFactory\"");
                } else if (type.isSimpleType()) {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.SimpleNonPrimitiveSerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.SimpleDeserializerFactory\"");
                } else if (type.getBaseType() != null) {
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.SimpleDeserializerFactory\"");
                } else {
                    this.pw.println("        serializer=\"org.apache.axis.encoding.ser.BeanSerializerFactory\"");
                    this.pw.println("        deserializer=\"org.apache.axis.encoding.ser.BeanDeserializerFactory\"");
                }
                if (hasLiteral) {
                    this.pw.println("        encodingStyle=\"\"");
                } else {
                    this.pw.println("        encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"");
                }
                this.pw.println("      />");
            }
            ++i;
        }
    }

    protected void writeDeployPort(Port port) throws IOException {
        Binding binding = port.getBinding();
        BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
        String serviceName = port.getName();
        boolean hasLiteral = bEntry.hasLiteral();
        String prefix = "java";
        String styleStr = "";
        if (hasLiteral) {
            styleStr = " style=\"document\"";
        }
        if (this.symbolTable.isWrapped()) {
            styleStr = " style=\"wrapped\"";
        }
        this.pw.println("  <service name=\"" + serviceName + "\" provider=\"" + prefix + ":RPC" + "\"" + styleStr + ">");
        this.writeDeployBinding(binding);
        this.writeDeployTypes(hasLiteral);
        this.pw.println("  </service>");
    }

    protected void writeDeployBinding(Binding binding) throws IOException {
        BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
        String className = bEntry.getName();
        className = this.emitter.getDeploySkeleton() ? String.valueOf(className) + "Skeleton" : String.valueOf(className) + "Impl";
        this.pw.println("      <parameter name=\"className\" value=\"" + className + "\"/>");
        String methodList = "";
        Iterator operationsIterator = binding.getBindingOperations().iterator();
        while (operationsIterator.hasNext()) {
            BindingOperation bindingOper = (BindingOperation)operationsIterator.next();
            Operation operation = bindingOper.getOperation();
            OperationType type = operation.getStyle();
            if (type != OperationType.NOTIFICATION && type != OperationType.SOLICIT_RESPONSE) {
                methodList = String.valueOf(methodList) + " " + bindingOper.getName();
            }
            Parameters params = this.symbolTable.getOperationParameters(operation, "", bEntry);
            if (!(params.returnType instanceof DefinedElement)) continue;
            QName returnQName = params.returnType.getQName();
            this.pw.println("      <operation name=\"" + operation.getName() + "\" returnQName=\"retNS:" + returnQName.getLocalPart() + "\" xmlns:retNS=\"" + returnQName.getNamespaceURI() + "\">");
            Map parts = operation.getInput().getMessage().getParts();
            if (!parts.isEmpty()) {
                Iterator i = parts.values().iterator();
                Part p = (Part)i.next();
                QName elementQName = p.getElementName();
                String ns = elementQName.getNamespaceURI();
                this.pw.println("        <elementMapping xmlns:ns=\"" + ns + "\" element=\"ns:" + elementQName.getLocalPart() + "\"/>");
            }
            this.pw.println("      </operation>");
        }
        this.pw.println("      <parameter name=\"allowedMethods\" value=\"" + methodList.substring(1) + "\"/>");
        if (this.emitter.getScope() == 1) {
            this.pw.println("      <parameter name=\"scope\" value=\"Application\"/>");
        } else if (this.emitter.getScope() == 16) {
            this.pw.println("      <parameter name=\"scope\" value=\"Request\"/>");
        } else if (this.emitter.getScope() == 17) {
            this.pw.println("      <parameter name=\"scope\" value=\"Session\"/>");
        }
    }
}

