/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Vector;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaEnumTypeWriter
extends JavaWriter {
    private TypeEntry type;
    private Vector elements;

    protected JavaEnumTypeWriter(Emitter emitter, TypeEntry type, Vector elements) {
        super(emitter, type, "", "java", JavaUtils.getMessage("genType00"), "enumType");
        this.type = type;
        this.elements = elements;
    }

    protected void writeFileBody() throws IOException {
        Node node = this.type.getNode();
        String javaName = Utils.getJavaLocalName(this.type.getName());
        String baseType = ((TypeEntry)this.elements.get(0)).getName();
        String baseClass = "Object";
        if (baseType.indexOf("String") >= 0) {
            baseClass = "String";
        } else if (baseType.indexOf("int") == 0) {
            baseClass = "Integer";
        } else if (baseType.indexOf("char") == 0) {
            baseClass = "Character";
        } else if (baseType.indexOf("short") == 0) {
            baseClass = "Short";
        } else if (baseType.indexOf("long") == 0) {
            baseClass = "Long";
        } else if (baseType.indexOf("double") == 0) {
            baseClass = "Double";
        } else if (baseType.indexOf("float") == 0) {
            baseClass = "Float";
        } else if (baseType.indexOf("byte") == 0) {
            baseClass = "Byte";
        }
        Vector<String> values = new Vector<String>();
        boolean validJava = true;
        int i = 1;
        while (i < this.elements.size()) {
            String value = (String)this.elements.get(i);
            if (!JavaUtils.isJavaId(value)) {
                validJava = false;
            }
            if (baseClass.equals("String")) {
                value = "\"" + value + "\"";
            } else if (baseClass.equals("Character")) {
                value = "'" + value + "'";
            } else if (baseClass.equals("Float") && !value.endsWith("F") && !value.endsWith("f")) {
                value = String.valueOf(value) + "F";
            }
            values.add(value);
            ++i;
        }
        Vector<String> ids = new Vector<String>();
        int i2 = 1;
        while (i2 < this.elements.size()) {
            if (!validJava) {
                ids.add("value" + i2);
            } else {
                ids.add((String)this.elements.get(i2));
            }
            ++i2;
        }
        this.pw.println("public class " + javaName + " implements java.io.Serializable {");
        this.pw.println("    private " + baseType + " _value_;");
        this.pw.println("    private static java.util.HashMap _table_ = new java.util.HashMap();");
        this.pw.println("");
        this.pw.println("    // " + JavaUtils.getMessage("ctor00"));
        this.pw.println("    protected " + javaName + "(" + baseType + " value) {");
        this.pw.println("        _value_ = value;");
        if (baseClass.equals("String")) {
            this.pw.println("        _table_.put(_value_,this);");
        } else {
            this.pw.println("        _table_.put(new " + baseClass + "(_value_),this);");
        }
        this.pw.println("    };");
        this.pw.println("");
        i2 = 0;
        while (i2 < ids.size()) {
            this.pw.println("    public static final " + baseType + " _" + ids.get(i2) + " = " + values.get(i2) + ";");
            ++i2;
        }
        i2 = 0;
        while (i2 < ids.size()) {
            this.pw.println("    public static final " + javaName + " " + ids.get(i2) + " = new " + javaName + "(_" + ids.get(i2) + ");");
            ++i2;
        }
        this.pw.println("    public " + baseType + " getValue() { return _value_;}");
        this.pw.println("    public static " + javaName + " fromValue(" + baseType + " value)");
        this.pw.println("          throws java.lang.IllegalStateException {");
        this.pw.println("        " + javaName + " enum = (" + javaName + ")");
        if (baseClass.equals("String")) {
            this.pw.println("            _table_.get(value);");
        } else {
            this.pw.println("            _table_.get(new " + baseClass + "(value));");
        }
        this.pw.println("        if (enum==null) throw new java.lang.IllegalStateException();");
        this.pw.println("        return enum;");
        this.pw.println("    }");
        this.pw.println("    public static " + javaName + " fromString(String value)");
        this.pw.println("          throws java.lang.IllegalStateException {");
        if (baseClass.equals("String")) {
            this.pw.println("        return fromValue(value);");
        } else if (baseClass.equals("Character")) {
            this.pw.println("        if (value != null && value.length() == 1);");
            this.pw.println("            return fromValue(value.charAt(0));");
            this.pw.println("        throw new java.lang.IllegalStateException();");
        } else if (baseClass.equals("Integer")) {
            this.pw.println("        try {");
            this.pw.println("            return fromValue(Integer.parseInt(value));");
            this.pw.println("        } catch (Exception e) {");
            this.pw.println("            throw new java.lang.IllegalStateException();");
            this.pw.println("        }");
        } else {
            this.pw.println("        try {");
            this.pw.println("            return fromValue(" + baseClass + ".parse" + baseClass + "(value));");
            this.pw.println("        } catch (Exception e) {");
            this.pw.println("            throw new java.lang.IllegalStateException();");
            this.pw.println("        }");
        }
        this.pw.println("    }");
        this.pw.println("    public boolean equals(Object obj) {return (obj == this);}");
        this.pw.println("    public int hashCode() { return toString().hashCode();}");
        if (baseClass.equals("String")) {
            this.pw.println("    public String toString() { return _value_;}");
        } else {
            this.pw.println("    public String toString() { return String.valueOf(_value_);}");
        }
        this.pw.println("}");
        this.pw.close();
    }
}

