/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.wsdl.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaFaultWriter
extends JavaWriter {
    private Fault fault;
    private SymbolTable symbolTable;

    protected JavaFaultWriter(Emitter emitter, QName qname, Fault fault, SymbolTable symbolTable) {
        super(emitter, qname, "", "java", JavaUtils.getMessage("genFault00"), "fault");
        this.fault = fault;
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        this.pw.println("public class " + this.className + " extends org.apache.axis.AxisFault {");
        Vector params = new Vector();
        this.symbolTable.partStrings(params, this.fault.getMessage().getOrderedParts(null), false, this.fault.getName(), "unknown");
        int i = 0;
        while (i < params.size()) {
            String type = ((TypeEntry)params.get(i)).getName();
            String variable = (String)params.get(i + 1);
            this.pw.println("    public " + type + " " + variable + ";");
            this.pw.println("    public " + type + " get" + Utils.capitalizeFirstChar(variable) + "() {");
            this.pw.println("        return this." + variable + ";");
            this.pw.println("    }");
            i += 2;
        }
        this.pw.println();
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("    }");
        this.pw.println();
        if (params.size() > 0) {
            this.pw.print("      public " + this.className + "(");
            i = 0;
            while (i < params.size()) {
                if (i != 0) {
                    this.pw.print(", ");
                }
                this.pw.print(String.valueOf(((TypeEntry)params.get(i)).getName()) + " " + params.get(i + 1));
                i += 2;
            }
            this.pw.println(") {");
            i = 1;
            while (i < params.size()) {
                String variable = (String)params.get(i);
                this.pw.println("        this." + variable + " = " + variable + ";");
                i += 2;
            }
            this.pw.println("    }");
        }
        this.pw.println("}");
        this.pw.close();
    }
}

