/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaImplWriter
extends JavaWriter {
    private Binding binding;
    private SymbolTable symbolTable;
    private BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry, "Impl", "java", JavaUtils.getMessage("genImpl00"), "skeletonImpl");
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bEntry;
    }

    protected void writeFileBody() throws IOException {
        PortType portType = this.binding.getPortType();
        PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
        String portTypeName = this.bEntry.hasLiteral() ? this.bEntry.getName() : ptEntry.getName();
        this.pw.print("public class " + this.className + " implements " + portTypeName);
        this.pw.println(" {");
        List operations = this.binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                this.pw.println(parameters.signature);
                this.pw.println();
            } else {
                this.writeOperation(parameters);
            }
            ++i;
        }
        this.pw.println("}");
        this.pw.close();
    }

    private void writeOperation(Parameters parms) throws IOException {
        this.pw.println(String.valueOf(parms.signature) + " {");
        Iterator iparam = ((AbstractList)parms.list).iterator();
        while (iparam.hasNext()) {
            Parameter param = (Parameter)iparam.next();
            String paramType = param.type.getName();
            if (param.mode != 2) continue;
            this.pw.print("        " + Utils.xmlNameToJava(param.getName()) + ".value = ");
            if (this.isPrimitiveType(param.type)) {
                if ("boolean".equals(paramType)) {
                    this.pw.print("false");
                } else if ("byte".equals(paramType)) {
                    this.pw.print("(byte)-3");
                } else if ("short".equals(paramType)) {
                    this.pw.print("(short)-3");
                } else {
                    this.pw.print("-3");
                }
            } else if (paramType.equals("java.lang.Boolean")) {
                this.pw.print("new java.lang.Boolean(false)");
            } else if (paramType.equals("java.lang.Byte")) {
                this.pw.print("new java.lang.Byte((byte)-3)");
            } else if (paramType.equals("java.lang.Double")) {
                this.pw.print("new java.lang.Double(-3)");
            } else if (paramType.equals("java.lang.Float")) {
                this.pw.print("new java.lang.Float(-3)");
            } else if (paramType.equals("java.lang.Integer")) {
                this.pw.print("new java.lang.Integer(-3)");
            } else if (paramType.equals("java.lang.Long")) {
                this.pw.print("new java.lang.Long(-3)");
            } else if (paramType.equals("java.lang.Short")) {
                this.pw.print("new java.lang.Short((short)-3)");
            } else if (paramType.equals("java.math.BigDecimal")) {
                this.pw.print("new java.math.BigDecimal(-3)");
            } else if (paramType.equals("java.math.BigInteger")) {
                this.pw.print("new java.math.BigInteger(\"-3\")");
            } else if (paramType.equals("byte[]")) {
                this.pw.print("new byte[0]");
            } else if (paramType.equals("java.lang.Byte[]")) {
                this.pw.print("new java.lang.Byte[0]");
            } else {
                this.pw.print("new " + paramType + "()");
            }
            this.pw.println(";");
        }
        if (parms.returnType != null) {
            this.pw.print("        return ");
            if (this.isPrimitiveType(parms.returnType)) {
                String returnType = parms.returnType.getName();
                if ("boolean".equals(returnType)) {
                    this.pw.println("false;");
                } else if ("byte".equals(returnType)) {
                    this.pw.println("(byte)-3;");
                } else if ("short".equals(returnType)) {
                    this.pw.println("(short)-3;");
                } else {
                    this.pw.println("-3;");
                }
            } else {
                this.pw.println("null;");
            }
        }
        this.pw.println("    }");
        this.pw.println();
    }
}

