/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaInterfaceWriter
extends JavaWriter {
    private PortType portType;
    private PortTypeEntry ptEntry;
    private SymbolTable symbolTable;
    private BindingEntry bEntry;

    protected JavaInterfaceWriter(Emitter emitter, PortTypeEntry ptEntry, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, ptEntry, "", "java", JavaUtils.getMessage("genIface00"), "interface");
        this.ptEntry = ptEntry;
        this.portType = ptEntry.getPortType();
        this.symbolTable = symbolTable;
        this.bEntry = bEntry;
        if (bEntry.hasLiteral()) {
            this.className = Utils.getJavaLocalName(bEntry.getName());
            this.fileName = String.valueOf(this.className) + ".java";
        }
    }

    public void write() throws IOException {
        String fqClass = String.valueOf(this.packageName) + "." + this.className;
        if (!this.emitter.fileInfo.getClassNames().contains(fqClass)) {
            super.write();
        }
    }

    protected void writeFileBody() throws IOException {
        this.pw.println("public interface " + this.className + " extends java.rmi.Remote {");
        Iterator operations = this.portType.getOperations().iterator();
        while (operations.hasNext()) {
            Operation operation = (Operation)operations.next();
            this.writeOperation(operation);
        }
        this.pw.println("}");
        this.pw.close();
    }

    private void writeOperation(Operation operation) throws IOException {
        this.writeComment(this.pw, operation.getDocumentationElement());
        Parameters parms = this.bEntry.getParameters(operation);
        this.pw.println(String.valueOf(parms.signature) + ";");
    }
}

