/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaServiceImplWriter
extends JavaWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry, "Locator", "java", JavaUtils.getMessage("genService00"), "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        Service service = this.sEntry.getService();
        this.pw.println("public class " + this.className + " extends org.apache.axis.client.Service implements " + this.sEntry.getName() + " {");
        this.writeComment(this.pw, service.getDocumentationElement());
        Map portMap = service.getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(JavaUtils.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = Utils.xmlNameToJavaClass(p.getName());
            String stubClass = String.valueOf(bEntry.getName()) + "Stub";
            String bindingType = bEntry.hasLiteral() ? bEntry.getName() : ptEntry.getName();
            String address = this.getAddressFromPort(p);
            if (address == null) {
                throw new IOException(JavaUtils.getMessage("emitFail02", portName, this.className));
            }
            try {
                URL ep = new URL(address);
            }
            catch (MalformedURLException e) {
                throw new IOException(JavaUtils.getMessage("emitFail03", new String[]{portName, this.className, address}));
            }
            this.pw.println();
            this.pw.println("    // " + JavaUtils.getMessage("getProxy00", portName));
            this.writeComment(this.pw, p.getDocumentationElement());
            this.pw.println("    private final java.lang.String " + portName + "_address = \"" + address + "\";");
            this.pw.println("");
            this.pw.println("    public String get" + portName + "Address() {");
            this.pw.println("        return " + portName + "_address;");
            this.pw.println("    }");
            this.pw.println("");
            this.pw.println("    public " + bindingType + " get" + portName + "() throws javax.xml.rpc.ServiceException {");
            this.pw.println("       java.net.URL endpoint;");
            this.pw.println("        try {");
            this.pw.println("            endpoint = new java.net.URL(" + portName + "_address);");
            this.pw.println("        }");
            this.pw.println("        catch (java.net.MalformedURLException e) {");
            this.pw.println("            return null; // " + JavaUtils.getMessage("unlikely00"));
            this.pw.println("        }");
            this.pw.println("        return get" + portName + "(endpoint);");
            this.pw.println("    }");
            this.pw.println();
            this.pw.println("    public " + bindingType + " get" + portName + "(java.net.URL portAddress) throws javax.xml.rpc.ServiceException {");
            this.pw.println("        try {");
            this.pw.println("            return new " + stubClass + "(portAddress, this);");
            this.pw.println("        }");
            this.pw.println("        catch (org.apache.axis.AxisFault e) {");
            this.pw.println("            return null; // ???");
            this.pw.println("        }");
            this.pw.println("    }");
        }
        this.pw.println("}");
        this.pw.close();
    }

    private String getAddressFromPort(Port p) {
        List extensibilityList = p.getExtensibilityElements();
        ListIterator li = extensibilityList.listIterator();
        while (li.hasNext()) {
            Object obj = li.next();
            if (!(obj instanceof SOAPAddress)) continue;
            return XMLUtils.xmlEncodeString(((SOAPAddress)obj).getLocationURI());
        }
        return null;
    }
}

