/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaSkelWriter
extends JavaWriter {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;

    protected JavaSkelWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry, "Skeleton", "java", JavaUtils.getMessage("genSkel00"), "skeleton");
        this.bEntry = bEntry;
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        Parameters parameters;
        BindingOperation operation;
        PortType portType = this.binding.getPortType();
        PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
        String portTypeName = this.bEntry.hasLiteral() ? this.bEntry.getName() : ptEntry.getName();
        boolean isRPC = true;
        if (this.bEntry.getBindingStyle() == 1) {
            isRPC = false;
        }
        String implType = String.valueOf(portTypeName) + " impl";
        this.pw.println("public class " + this.className + " implements " + portTypeName + ",");
        this.pw.println("    org.apache.axis.wsdl.Skeleton {");
        this.pw.println("    private " + implType + ";");
        this.pw.println("    private static org.apache.axis.wsdl.SkeletonImpl skel = null;");
        this.pw.println();
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("        this.impl = new " + this.bEntry.getName() + "Impl();");
        this.pw.println("        init();");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public " + this.className + "(" + implType + ") {");
        this.pw.println("        this.impl = impl;");
        this.pw.println("        init();");
        this.pw.println("    }");
        this.pw.println("    public javax.xml.rpc.namespace.QName getParameterName(String opName, int i) {");
        this.pw.println("        return skel.getParameterName(opName, i);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public static javax.xml.rpc.namespace.QName getParameterNameStatic(String opName, int i) {");
        this.pw.println("        init();");
        this.pw.println("        return skel.getParameterName(opName, i);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public javax.xml.rpc.ParameterMode getParameterMode(String opName, int i) {");
        this.pw.println("        return skel.getParameterMode(opName, i);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public static javax.xml.rpc.ParameterMode getParameterModeStatic(String opName, int i) {");
        this.pw.println("        init();");
        this.pw.println("        return skel.getParameterMode(opName, i);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public static String getInputNamespaceStatic(String opName) {");
        this.pw.println("        init();");
        this.pw.println("        return skel.getInputNamespace(opName);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public static String getOutputNamespaceStatic(String opName) {");
        this.pw.println("        init();");
        this.pw.println("        return skel.getOutputNamespace(opName);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public static String getSOAPAction(String opName) {");
        this.pw.println("        init();");
        this.pw.println("        return skel.getSOAPAction(opName);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    protected static void init() {");
        this.pw.println("        if (skel != null) ");
        this.pw.println("            return;");
        this.pw.println("        skel = new org.apache.axis.wsdl.SkeletonImpl();");
        List operations = this.binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            operation = (BindingOperation)operations.get(i);
            parameters = this.bEntry.getParameters(operation.getOperation());
            if (parameters != null) {
                ExtensibilityElement elem;
                Iterator it;
                Parameter p;
                String opName = Utils.xmlNameToJava(operation.getOperation().getName());
                this.pw.println("        skel.add(\"" + opName + "\",");
                this.pw.println("                 new javax.xml.rpc.namespace.QName[] {");
                if (parameters.returnType != null) {
                    this.pw.println("                   " + Utils.getNewQName(parameters.returnName) + ",");
                } else {
                    this.pw.println("                   null,");
                }
                int j = 0;
                while (j < parameters.list.size()) {
                    p = (Parameter)parameters.list.get(j);
                    this.pw.println("                   " + Utils.getNewQName(Utils.getAxisQName(p.getQName())) + ",");
                    ++j;
                }
                this.pw.println("                 },");
                this.pw.println("                 new javax.xml.rpc.ParameterMode[] {");
                if (parameters.returnType != null) {
                    this.pw.println("                   javax.xml.rpc.ParameterMode.PARAM_MODE_OUT,");
                } else {
                    this.pw.println("                   null,");
                }
                j = 0;
                while (j < parameters.list.size()) {
                    p = (Parameter)parameters.list.get(j);
                    if (p.mode == 1) {
                        this.pw.println("                   javax.xml.rpc.ParameterMode.PARAM_MODE_IN,");
                    } else if (p.mode == 2) {
                        this.pw.println("                   javax.xml.rpc.ParameterMode.PARAM_MODE_INOUT,");
                    } else {
                        this.pw.println("                   javax.xml.rpc.ParameterMode.PARAM_MODE_OUT,");
                    }
                    ++j;
                }
                this.pw.println("                 },");
                BindingInput input = operation.getBindingInput();
                if (input == null) {
                    this.pw.println("                 null,");
                } else {
                    List elems = input.getExtensibilityElements();
                    boolean found = false;
                    it = elems.iterator();
                    while (!found && it.hasNext()) {
                        SOAPBody body;
                        String ns;
                        ExtensibilityElement elem2 = (ExtensibilityElement)it.next();
                        if (!(elem2 instanceof SOAPBody) || (ns = (body = (SOAPBody)elem2).getNamespaceURI()) == null) continue;
                        this.pw.println("                 \"" + ns + "\",");
                        found = true;
                    }
                    if (!found) {
                        this.pw.println("                 null,");
                    }
                }
                BindingOutput output = operation.getBindingOutput();
                if (output == null) {
                    this.pw.println("                 null,");
                } else {
                    List elems = output.getExtensibilityElements();
                    it = elems.iterator();
                    boolean found = false;
                    while (!found && it.hasNext()) {
                        SOAPBody body;
                        String ns;
                        elem = (ExtensibilityElement)it.next();
                        if (!(elem instanceof SOAPBody) || (ns = (body = (SOAPBody)elem).getNamespaceURI()) == null) continue;
                        this.pw.println("                 \"" + ns + "\",");
                        found = true;
                    }
                    if (!found) {
                        this.pw.println("                 null,");
                    }
                }
                List elems = operation.getExtensibilityElements();
                it = elems.iterator();
                boolean found = false;
                while (!found && it.hasNext()) {
                    SOAPOperation soapOp;
                    String action;
                    elem = (ExtensibilityElement)it.next();
                    if (!(elem instanceof SOAPOperation) || (action = (soapOp = (SOAPOperation)elem).getSoapActionURI()) == null) continue;
                    this.pw.println("                 \"" + action + "\");");
                    found = true;
                }
                if (!found) {
                    this.pw.println("                 null);");
                }
            }
            ++i;
        }
        this.pw.println("    }");
        this.pw.println();
        i = 0;
        while (i < operations.size()) {
            Operation ptOperation;
            OperationType type;
            operation = (BindingOperation)operations.get(i);
            parameters = this.bEntry.getParameters(operation.getOperation());
            String soapAction = "";
            Iterator operationExtensibilityIterator = operation.getExtensibilityElements().iterator();
            while (operationExtensibilityIterator.hasNext()) {
                Object obj = operationExtensibilityIterator.next();
                if (!(obj instanceof SOAPOperation)) continue;
                soapAction = ((SOAPOperation)obj).getSoapActionURI();
                break;
            }
            String namespace = "";
            Iterator bindingMsgIterator = null;
            BindingInput input = operation.getBindingInput();
            if (input != null) {
                bindingMsgIterator = input.getExtensibilityElements().iterator();
            } else {
                BindingOutput output = operation.getBindingOutput();
                if (output != null) {
                    bindingMsgIterator = output.getExtensibilityElements().iterator();
                }
            }
            if (bindingMsgIterator != null) {
                while (bindingMsgIterator.hasNext()) {
                    Object obj = bindingMsgIterator.next();
                    if (!(obj instanceof SOAPBody)) continue;
                    namespace = ((SOAPBody)obj).getNamespaceURI();
                    if (namespace == null) {
                        namespace = this.emitter.def.getTargetNamespace();
                    }
                    if (namespace != null) break;
                    namespace = "";
                    break;
                }
            }
            if ((type = (ptOperation = operation.getOperation()).getStyle()) == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                this.pw.println(parameters.signature);
                this.pw.println();
            } else {
                this.writeOperation(operation, parameters, soapAction, namespace, isRPC);
            }
            ++i;
        }
        this.pw.println("}");
        this.pw.close();
    }

    private void writeOperation(BindingOperation operation, Parameters parms, String soapAction, String namespace, boolean isRPC) throws IOException {
        this.writeComment(this.pw, operation.getDocumentationElement());
        this.pw.println(parms.signature);
        this.pw.println("    {");
        if (parms.returnType == null) {
            this.pw.print("        ");
        } else {
            this.pw.print("        " + parms.returnType.getName() + " ret = ");
        }
        String call = "impl." + Utils.xmlNameToJava(operation.getName()) + "(";
        boolean needComma = false;
        int i = 0;
        while (i < parms.list.size()) {
            if (needComma) {
                call = String.valueOf(call) + ", ";
            } else {
                needComma = true;
            }
            Parameter p = (Parameter)parms.list.get(i);
            call = String.valueOf(call) + Utils.xmlNameToJava(p.getName());
            ++i;
        }
        call = String.valueOf(call) + ")";
        this.pw.println(String.valueOf(call) + ";");
        if (parms.returnType != null) {
            this.pw.println("        return ret;");
        }
        this.pw.println("    }");
        this.pw.println();
    }
}

