/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.CollectionType;
import org.apache.axis.wsdl.toJava.DefinedElement;
import org.apache.axis.wsdl.toJava.Element;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaStubWriter
extends JavaWriter {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    private boolean firstSer = true;

    protected JavaStubWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry, "Stub", "java", JavaUtils.getMessage("genStub00"), "stub");
        this.bEntry = bEntry;
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody() throws IOException {
        PortType portType = this.binding.getPortType();
        PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
        String name = Utils.xmlNameToJavaClass(this.qname.getLocalPart());
        String portTypeName = this.bEntry.hasLiteral() ? this.bEntry.getName() : ptEntry.getName();
        boolean isRPC = true;
        if (this.bEntry.getBindingStyle() == 1) {
            isRPC = false;
        }
        this.pw.println("public class " + this.className + " extends org.apache.axis.client.Stub implements " + portTypeName + " {");
        HashSet types = this.getTypesInPortType(portType);
        if (types.size() > 0) {
            this.pw.println("    private java.util.Vector cachedSerClasses = new java.util.Vector();");
            this.pw.println("    private java.util.Vector cachedSerQNames = new java.util.Vector();");
            this.pw.println("    private java.util.Vector cachedSerFactories = new java.util.Vector();");
            this.pw.println("    private java.util.Vector cachedDeserFactories = new java.util.Vector();");
        }
        this.pw.println();
        this.pw.println("    public " + this.className + "() throws org.apache.axis.AxisFault {");
        this.pw.println("         this(null);");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        this.pw.println("         this(service);");
        this.pw.println("         super.cachedEndpoint = endpointURL;");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    public " + this.className + "(javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        this.pw.println("        try {");
        this.pw.println("            if (service == null) {");
        this.pw.println("                super.service = new org.apache.axis.client.Service();");
        this.pw.println("            } else {");
        this.pw.println("                super.service = service;");
        this.pw.println("            }");
        Iterator it = types.iterator();
        while (it.hasNext()) {
            this.writeSerializationInit((TypeEntry)it.next());
        }
        this.pw.println("        }");
        this.pw.println("        catch(Exception t) {");
        this.pw.println("            throw org.apache.axis.AxisFault.makeFault(t);");
        this.pw.println("        }");
        this.pw.println("    }");
        this.pw.println();
        this.pw.println("    private org.apache.axis.client.Call getCall() throws java.rmi.RemoteException {");
        this.pw.println("        try {");
        this.pw.println("            org.apache.axis.client.Call call =");
        this.pw.println("                    (org.apache.axis.client.Call) super.service.createCall();");
        this.pw.println("            if (super.maintainSessionSet) {");
        this.pw.println("                call.setMaintainSession(super.maintainSession);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedUsername != null) {");
        this.pw.println("                call.setUsername(super.cachedUsername);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedPassword != null) {");
        this.pw.println("                call.setPassword(super.cachedPassword);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedEndpoint != null) {");
        this.pw.println("                call.setTargetEndpointAddress(super.cachedEndpoint);");
        this.pw.println("            }");
        this.pw.println("            if (super.cachedTimeout != null) {");
        this.pw.println("                call.setTimeout(super.cachedTimeout);");
        this.pw.println("            }");
        this.pw.println("            java.util.Enumeration keys = super.cachedProperties.keys();");
        this.pw.println("            while (keys.hasMoreElements()) {");
        this.pw.println("                String key = (String) keys.nextElement();");
        this.pw.println("                call.setProperty(key, super.cachedProperties.get(key));");
        this.pw.println("            }");
        if (types.size() > 0) {
            this.pw.println("            // " + JavaUtils.getMessage("typeMap00"));
            this.pw.println("            // " + JavaUtils.getMessage("typeMap01"));
            this.pw.println("            // " + JavaUtils.getMessage("typeMap02"));
            this.pw.println("            // " + JavaUtils.getMessage("typeMap03"));
            this.pw.println("            // " + JavaUtils.getMessage("typeMap04"));
            this.pw.println("            if (firstCall()) {");
            this.pw.println("                // " + JavaUtils.getMessage("mustSetStyle"));
            if (this.bEntry.hasLiteral()) {
                this.pw.println("                call.setEncodingStyle(null);");
            } else {
                this.pw.println("                call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP_ENC);");
            }
            this.pw.println("                for (int i = 0; i < cachedSerFactories.size(); ++i) {");
            this.pw.println("                    Class cls = (Class) cachedSerClasses.get(i);");
            this.pw.println("                    javax.xml.rpc.namespace.QName qName =");
            this.pw.println("                            (javax.xml.rpc.namespace.QName) cachedSerQNames.get(i);");
            this.pw.println("                    Class sf = (Class)");
            this.pw.println("                             cachedSerFactories.get(i);");
            this.pw.println("                    Class df = (Class)");
            this.pw.println("                             cachedDeserFactories.get(i);");
            this.pw.println("                    call.registerTypeMapping(cls, qName, sf, df, false);");
            this.pw.println("                }");
            this.pw.println("            }");
        }
        this.pw.println("            return call;");
        this.pw.println("        }");
        this.pw.println("        catch (Throwable t) {");
        this.pw.println("            throw new org.apache.axis.AxisFault(\"" + JavaUtils.getMessage("badCall01") + "\", t);");
        this.pw.println("        }");
        this.pw.println("    }");
        this.pw.println();
        List operations = this.binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            Operation ptOperation;
            OperationType type;
            BindingOperation operation = (BindingOperation)operations.get(i);
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            String soapAction = "";
            Iterator operationExtensibilityIterator = operation.getExtensibilityElements().iterator();
            while (operationExtensibilityIterator.hasNext()) {
                Object obj = operationExtensibilityIterator.next();
                if (!(obj instanceof SOAPOperation)) continue;
                soapAction = ((SOAPOperation)obj).getSoapActionURI();
                break;
            }
            String namespace = "";
            Iterator bindingMsgIterator = null;
            BindingInput input = operation.getBindingInput();
            if (input != null) {
                bindingMsgIterator = input.getExtensibilityElements().iterator();
            } else {
                BindingOutput output = operation.getBindingOutput();
                if (output != null) {
                    bindingMsgIterator = output.getExtensibilityElements().iterator();
                }
            }
            if (bindingMsgIterator != null) {
                while (bindingMsgIterator.hasNext()) {
                    Object obj = bindingMsgIterator.next();
                    if (!(obj instanceof SOAPBody)) continue;
                    namespace = ((SOAPBody)obj).getNamespaceURI();
                    if (namespace == null) {
                        namespace = this.emitter.def.getTargetNamespace();
                    }
                    if (namespace != null) break;
                    namespace = "";
                    break;
                }
            }
            if ((type = (ptOperation = operation.getOperation()).getStyle()) == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                this.pw.println(parameters.signature);
                this.pw.println();
            } else {
                this.writeOperation(operation, parameters, soapAction, namespace, isRPC);
            }
            ++i;
        }
        this.pw.println("}");
        this.pw.close();
    }

    private HashSet getTypesInPortType(PortType portType) {
        HashSet<TypeEntry> types = new HashSet<TypeEntry>();
        HashSet firstPassTypes = new HashSet();
        List operations = portType.getOperations();
        int i = 0;
        while (i < operations.size()) {
            Operation op = (Operation)operations.get(i);
            firstPassTypes.addAll(this.getTypesInOperation(op));
            ++i;
        }
        Iterator i2 = firstPassTypes.iterator();
        while (i2.hasNext()) {
            TypeEntry type = (TypeEntry)i2.next();
            if (types.contains(type)) continue;
            types.add(type);
            if (type.getNode() == null || type.getBaseType() != null) continue;
            types.addAll(Utils.getNestedTypes(type.getNode(), this.symbolTable));
        }
        return types;
    }

    private HashSet getTypesInOperation(Operation operation) {
        Map faults;
        HashSet types = new HashSet();
        Vector<TypeEntry> v = new Vector<TypeEntry>();
        Parameters params = this.bEntry.getParameters(operation);
        int i = 0;
        while (i < params.list.size()) {
            Parameter p = (Parameter)params.list.get(i);
            v.add(p.type);
            ++i;
        }
        if (params.returnType != null) {
            v.add(params.returnType);
        }
        if ((faults = operation.getFaults()) != null) {
            Iterator i2 = faults.values().iterator();
            while (i2.hasNext()) {
                Fault f = (Fault)i2.next();
                this.partTypes(v, f.getMessage().getOrderedParts(null), this.bEntry.getFaultBodyType(operation, f.getName()) == 1);
            }
        }
        int i3 = 0;
        while (i3 < v.size()) {
            types.add(v.get(i3));
            ++i3;
        }
        return types;
    }

    private void partTypes(Vector v, Collection parts, boolean literal) {
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            QName qType = part.getTypeName();
            if (qType != null) {
                v.add(this.symbolTable.getType(qType));
                continue;
            }
            qType = part.getElementName();
            if (qType == null) continue;
            v.add(this.symbolTable.getElement(qType));
        }
    }

    private void writeSerializationInit(TypeEntry type) throws IOException {
        boolean process = true;
        if (type.getBaseType() != null && type.getRefType() == null || type instanceof CollectionType || type instanceof Element || !type.isReferenced() || type.isOnlyLiteralReferenced()) {
            process = false;
        }
        if (!process) {
            return;
        }
        if (this.firstSer) {
            this.pw.println("            Class cls;");
            this.pw.println("            javax.xml.rpc.namespace.QName qName;");
            this.pw.println("            Class beansf = org.apache.axis.encoding.ser.BeanSerializerFactory.class;");
            this.pw.println("            Class beandf = org.apache.axis.encoding.ser.BeanDeserializerFactory.class;");
            this.pw.println("            Class enumsf = org.apache.axis.encoding.ser.EnumSerializerFactory.class;");
            this.pw.println("            Class enumdf = org.apache.axis.encoding.ser.EnumDeserializerFactory.class;");
            this.pw.println("            Class arraysf = org.apache.axis.encoding.ser.ArraySerializerFactory.class;");
            this.pw.println("            Class arraydf = org.apache.axis.encoding.ser.ArrayDeserializerFactory.class;");
            this.pw.println("            Class simplesf = org.apache.axis.encoding.ser.SimpleNonPrimitiveSerializerFactory.class;");
            this.pw.println("            Class simpledf = org.apache.axis.encoding.ser.SimpleDeserializerFactory.class;");
        }
        this.firstSer = false;
        QName qname = type.getQName();
        this.pw.println("            qName = new javax.xml.rpc.namespace.QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
        this.pw.println("            cachedSerQNames.add(qName);");
        this.pw.println("            cls = " + type.getName() + ".class;");
        this.pw.println("            cachedSerClasses.add(cls);");
        if (type.getName().endsWith("[]")) {
            this.pw.println("            cachedSerFactories.add(arraysf);");
            this.pw.println("            cachedDeserFactories.add(arraydf);");
        } else if (type.getNode() != null && SchemaUtils.getEnumerationBaseAndValues(type.getNode(), this.emitter.getSymbolTable()) != null) {
            this.pw.println("            cachedSerFactories.add(enumsf);");
            this.pw.println("            cachedDeserFactories.add(enumdf);");
        } else if (type.isSimpleType()) {
            this.pw.println("            cachedSerFactories.add(simplesf);");
            this.pw.println("            cachedDeserFactories.add(simpledf);");
        } else if (type.getBaseType() != null) {
            this.pw.println("            cachedSerFactories.add(null);");
            this.pw.println("            cachedDeserFactories.add(simpledf);");
        } else {
            this.pw.println("            cachedSerFactories.add(beansf);");
            this.pw.println("            cachedDeserFactories.add(beandf);");
        }
        this.pw.println();
    }

    private void writeOperation(BindingOperation operation, Parameters parms, String soapAction, String namespace, boolean isRPC) throws IOException {
        int use;
        this.writeComment(this.pw, operation.getDocumentationElement());
        this.pw.println(String.valueOf(parms.signature) + "{");
        this.pw.println("        if (super.cachedEndpoint == null) {");
        this.pw.println("            throw new org.apache.axis.NoEndPointException();");
        this.pw.println("        }");
        this.pw.println("        org.apache.axis.client.Call call = getCall();");
        int i = 0;
        while (i < parms.list.size()) {
            Node node;
            QName qn2;
            Parameter p = (Parameter)parms.list.get(i);
            QName qn = p.type.getQName();
            if (p.type instanceof DefinedElement && (qn2 = Utils.getNodeTypeRefQName(node = this.symbolTable.getTypeEntry(p.type.getQName(), true).getNode(), "type")) != null) {
                qn = qn2;
            }
            String typeString = "new javax.xml.rpc.namespace.QName(\"" + qn.getNamespaceURI() + "\", \"" + qn.getLocalPart() + "\")";
            QName paramQName = p.getQName();
            String qnName = "p" + i + "QName";
            this.pw.println("        javax.xml.rpc.namespace.QName " + qnName + " = new javax.xml.rpc.namespace.QName(\"" + paramQName.getNamespaceURI() + "\", \"" + paramQName.getLocalPart() + "\");");
            if (p.mode == 1) {
                this.pw.println("        call.addParameter(" + qnName + ", " + typeString + ", javax.xml.rpc.ParameterMode.PARAM_MODE_IN);");
            } else if (p.mode == 3) {
                this.pw.println("        call.addParameter(" + qnName + ", " + typeString + ", javax.xml.rpc.ParameterMode.PARAM_MODE_INOUT);");
            } else {
                this.pw.println("        call.addParameter(" + qnName + ", " + typeString + ", javax.xml.rpc.ParameterMode.PARAM_MODE_OUT);");
            }
            ++i;
        }
        if (parms.returnType != null) {
            Node node;
            QName qn2;
            QName qn = parms.returnType.getQName();
            if (parms.returnType instanceof DefinedElement && (qn2 = Utils.getNodeTypeRefQName(node = this.symbolTable.getTypeEntry(parms.returnType.getQName(), true).getNode(), "type")) != null) {
                qn = qn2;
            }
            String outputType = "new javax.xml.rpc.namespace.QName(\"" + qn.getNamespaceURI() + "\", \"" + qn.getLocalPart() + "\")";
            this.pw.println("        call.setReturnType(" + outputType + ");");
        } else {
            this.pw.println("        call.setReturnType(org.apache.axis.encoding.XMLType.AXIS_VOID);");
        }
        if (soapAction != null) {
            this.pw.println("        call.setUseSOAPAction(true);");
            this.pw.println("        call.setSOAPActionURI(\"" + soapAction + "\");");
        }
        if ((use = this.bEntry.getInputBodyType(operation.getOperation())) == 1) {
            this.pw.println("        call.setEncodingStyle(null);");
            this.pw.println("        call.setProperty(org.apache.axis.AxisEngine.PROP_DOMULTIREFS, Boolean.FALSE);");
            this.pw.println("        call.setProperty(org.apache.axis.client.Call.SEND_TYPE_ATTR, Boolean.FALSE);");
        }
        int style = this.bEntry.getBindingStyle();
        String styleStr = "rpc";
        if (style == 1) {
            styleStr = this.symbolTable.isWrapped() ? "wrapped" : "document";
        }
        this.pw.println("        call.setOperationStyle(\"" + styleStr + "\");");
        this.pw.println("        call.setOperationName(new javax.xml.rpc.namespace.QName(\"" + namespace + "\", \"" + operation.getName() + "\"));");
        this.pw.println();
        this.pw.print("        Object resp = call.invoke(");
        this.pw.print("new Object[] {");
        boolean needComma = false;
        int i2 = 0;
        while (i2 < parms.list.size()) {
            Parameter p = (Parameter)parms.list.get(i2);
            String javifiedName = Utils.xmlNameToJava(p.getName());
            if (p.mode != 2) {
                if (needComma) {
                    this.pw.print(", ");
                } else {
                    needComma = true;
                }
                if (p.mode == 1) {
                    this.pw.print(this.wrapPrimitiveType(p.type, javifiedName));
                } else {
                    this.pw.print(this.wrapPrimitiveType(p.type, String.valueOf(javifiedName) + ".value"));
                }
            }
            ++i2;
        }
        this.pw.println("});");
        this.pw.println();
        this.pw.println("        if (resp instanceof java.rmi.RemoteException) {");
        this.pw.println("            throw (java.rmi.RemoteException)resp;");
        this.pw.println("        }");
        int allOuts = parms.outputs + parms.inouts;
        if (allOuts > 0) {
            this.pw.println("        else {");
            if (allOuts == 1) {
                if (parms.inouts == 1) {
                    int i3 = 0;
                    Parameter p = (Parameter)parms.list.get(i3);
                    while (p.mode != 3) {
                        p = (Parameter)parms.list.get(++i3);
                    }
                    String javifiedName = Utils.xmlNameToJava(p.getName());
                    String qnameName = Utils.getNewQName(Utils.getAxisQName(p.getQName()));
                    this.pw.println("            java.util.Map output;");
                    this.pw.println("            output = call.getOutputParams();");
                    if (p.type.getName().endsWith("[]")) {
                        this.pw.println("            // REVISIT THIS!");
                        this.pw.println("            " + javifiedName + ".value = (" + p.type.getName() + ") org.apache.axis.utils.JavaUtils.convert(output.get(" + qnameName + "), " + p.type.getName() + ".class);");
                    } else {
                        this.pw.println("            " + javifiedName + ".value = " + this.getResponseString(p.type, "output.get(" + qnameName + ")"));
                    }
                } else if (parms.returnType != null && parms.returnType.getName() != null && parms.returnType.getName().indexOf("[]") > 0) {
                    this.pw.println("             // REVISIT THIS!");
                    this.pw.println("             return (" + parms.returnType.getName() + ")" + "org.apache.axis.utils.JavaUtils.convert(resp," + parms.returnType.getName() + ".class);");
                } else {
                    this.pw.println("             return " + this.getResponseString(parms.returnType, "resp"));
                }
            } else {
                this.pw.println("            java.util.Map output;");
                this.pw.println("            output = call.getOutputParams();");
                boolean firstInoutIsResp = parms.outputs == 0;
                int i4 = 0;
                while (i4 < parms.list.size()) {
                    Parameter p = (Parameter)parms.list.get(i4);
                    String javifiedName = Utils.xmlNameToJava(p.getName());
                    String qnameName = Utils.getNewQName(Utils.getAxisQName(p.getQName()));
                    if (p.mode != 1) {
                        if (firstInoutIsResp) {
                            firstInoutIsResp = false;
                            if (p.type.getName().endsWith("[]")) {
                                this.pw.println("             // REVISIT THIS!");
                                this.pw.println("            " + javifiedName + ".value = (" + p.type.getName() + ") org.apache.axis.utils.JavaUtils.convert(output.get(" + qnameName + "), " + p.type.getName() + ".class);");
                            } else {
                                this.pw.println("            " + javifiedName + ".value = " + this.getResponseString(p.type, "output.get(" + qnameName + ")"));
                            }
                        } else if (p.type.getName().endsWith("[]")) {
                            this.pw.println("             // REVISIT THIS!");
                            this.pw.println("            " + javifiedName + ".value = (" + p.type.getName() + ") org.apache.axis.utils.JavaUtils.convert(" + "output.get(" + qnameName + "), " + p.type.getName() + ".class);");
                        } else {
                            this.pw.println("            " + javifiedName + ".value = " + this.getResponseString(p.type, "output.get(" + qnameName + ")"));
                        }
                    }
                    ++i4;
                }
                if (parms.outputs > 0) {
                    if (parms.returnType != null && parms.returnType.getName() != null && parms.returnType.getName().indexOf("[]") > 0) {
                        this.pw.println("             // REVISIT THIS!");
                        this.pw.println("             return (" + parms.returnType.getName() + ")" + "org.apache.axis.utils.JavaUtils.convert(output.get(" + Utils.getNewQName(parms.returnName) + ")," + parms.returnType.getName() + ".class);");
                    } else if (parms.returnType != null) {
                        this.pw.println("             return " + this.getResponseString(parms.returnType, "resp"));
                    }
                }
            }
            this.pw.println("        }");
        }
        this.pw.println("    }");
        this.pw.println();
    }
}

