/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaTestCaseWriter
extends JavaWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    private int counter = 1;

    protected JavaTestCaseWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry, "TestCase", "java", JavaUtils.getMessage("genTest00"), "testCase");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected void writeFileHeader() throws IOException {
        super.writeFileHeader();
        this.pw.print("public class ");
        this.pw.print(this.className);
        this.pw.println(" extends junit.framework.TestCase {");
        this.pw.print("    public ");
        this.pw.print(this.className);
        this.pw.println("(String name) {");
        this.pw.println("        super(name);");
        this.pw.println("    }");
    }

    protected void writeFileBody() throws IOException {
        Map portMap = this.sEntry.getService().getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry.getBindingType() != 0) continue;
            String portName = Utils.xmlNameToJavaClass(p.getName());
            PortType portType = binding.getPortType();
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
            this.writeComment(this.pw, p.getDocumentationElement());
            this.writeServiceTestCode(portName, portType, ptEntry, binding, bEntry);
        }
        this.finish();
    }

    public final void finish() {
        this.pw.println("}");
        this.pw.println();
        this.pw.flush();
        this.pw.close();
    }

    private final void writeServiceTestCode(String portName, PortType portType, PortTypeEntry ptEntry, Binding binding, BindingEntry bEntry) throws IOException {
        Iterator ops = portType.getOperations().iterator();
        while (ops.hasNext()) {
            Operation op = (Operation)ops.next();
            OperationType type = op.getStyle();
            Parameters params = bEntry.getParameters(op);
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                this.pw.println("    " + params.signature);
                continue;
            }
            String javaOpName = Utils.xmlNameToJavaClass(op.getName());
            String testMethodName = "test" + this.counter++ + portName + javaOpName;
            this.pw.println("    public void " + testMethodName + "() {");
            String bindingType = bEntry.hasLiteral() ? bEntry.getName() : ptEntry.getName();
            this.writeBindingAssignment(bindingType, portName);
            this.pw.println("        try {");
            if (params.returnType != null) {
                this.pw.print("            ");
                this.pw.print(params.returnType.getName());
                this.pw.print(" value = ");
                if (this.isPrimitiveType(params.returnType)) {
                    if ("boolean".equals(params.returnType.getName())) {
                        this.pw.println("false;");
                    } else {
                        this.pw.println("-3;");
                    }
                } else {
                    this.pw.println("null;");
                }
            }
            this.pw.print("            ");
            if (params.returnType != null) {
                this.pw.print("value = ");
            }
            this.pw.print("binding.");
            this.pw.print(Utils.xmlNameToJava(op.getName()));
            this.pw.print("(");
            Iterator iparam = ((AbstractList)params.list).iterator();
            boolean isFirst = true;
            while (iparam.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.pw.print(", ");
                }
                Parameter param = (Parameter)iparam.next();
                String paramType = param.type.getName();
                String suffix = "";
                if (param.mode != 1) {
                    this.pw.print("new " + Utils.holder(param.type, this.symbolTable) + "(");
                    suffix = ")";
                }
                if (param.mode != 2) {
                    if (this.isPrimitiveType(param.type)) {
                        if ("boolean".equals(paramType)) {
                            this.pw.print("true");
                        } else if ("byte".equals(paramType)) {
                            this.pw.print("(byte)0");
                        } else if ("short".equals(paramType)) {
                            this.pw.print("(short)0");
                        } else {
                            this.pw.print("0");
                        }
                    } else if (paramType.equals("java.lang.Boolean")) {
                        this.pw.print("new java.lang.Boolean(false)");
                    } else if (paramType.equals("java.lang.Byte")) {
                        this.pw.print("new java.lang.Byte((byte)0)");
                    } else if (paramType.equals("java.lang.Double")) {
                        this.pw.print("new java.lang.Double(0)");
                    } else if (paramType.equals("java.lang.Float")) {
                        this.pw.print("new java.lang.Float(0)");
                    } else if (paramType.equals("java.lang.Integer")) {
                        this.pw.print("new java.lang.Integer(0)");
                    } else if (paramType.equals("java.lang.Long")) {
                        this.pw.print("new java.lang.Long(0)");
                    } else if (paramType.equals("java.lang.Short")) {
                        this.pw.print("new java.lang.Short((short)0)");
                    } else if (paramType.equals("java.math.BigDecimal")) {
                        this.pw.print("new java.math.BigDecimal(0)");
                    } else if (paramType.equals("java.math.BigInteger")) {
                        this.pw.print("new java.math.BigInteger(\"0\")");
                    } else if (paramType.equals("java.lang.Object")) {
                        this.pw.print("new java.lang.String()");
                    } else if (paramType.equals("byte[]")) {
                        this.pw.print("new byte[0]");
                    } else if (paramType.endsWith("[]")) {
                        this.pw.print("new " + JavaUtils.replace(paramType, "[]", "[0]"));
                    } else {
                        Vector v = SchemaUtils.getEnumerationBaseAndValues(param.type.getNode(), this.symbolTable);
                        if (v != null) {
                            String enumeration = (String)v.get(1);
                            this.pw.print(String.valueOf(paramType) + "." + enumeration);
                        } else {
                            this.pw.print("new " + paramType + "()");
                        }
                    }
                }
                this.pw.print(suffix);
            }
            this.pw.println(");");
            this.pw.println("        }");
            Map faultMap = op.getFaults();
            if (faultMap != null) {
                Iterator i = faultMap.values().iterator();
                int count = 0;
                while (i.hasNext()) {
                    Fault f = (Fault)i.next();
                    String namespace = portType.getQName().getNamespaceURI();
                    this.pw.print("        catch (");
                    this.pw.print(Utils.getFullExceptionName(f, this.symbolTable, namespace));
                    this.pw.println(" e" + ++count + ") {");
                    this.pw.print("            ");
                    this.pw.println("throw new junit.framework.AssertionFailedError(\"" + f.getName() + " Exception caught: \" + e" + count + ");");
                    this.pw.println("        }");
                }
            }
            this.pw.println("        catch (java.rmi.RemoteException re) {");
            this.pw.print("            ");
            this.pw.println("throw new junit.framework.AssertionFailedError(\"Remote Exception caught: \" + re);");
            this.pw.println("        }");
            this.pw.println("    }");
            this.pw.println();
        }
    }

    public final void writeBindingAssignment(String bindingType, String portName) throws IOException {
        this.pw.println("        " + bindingType + " binding;");
        this.pw.println("        try {");
        this.pw.print("            binding = new " + this.sEntry.getName());
        this.pw.println("Locator().get" + portName + "();");
        this.pw.println("        }");
        this.pw.println("        catch (javax.xml.rpc.ServiceException jre) {");
        this.pw.println("            throw new junit.framework.AssertionFailedError(\"JAX-RPC ServiceException caught: \" + jre);");
        this.pw.println("        }");
        this.pw.println("        assertTrue(\"" + JavaUtils.getMessage("null00", "binding") + "\", binding != null);");
        this.pw.println();
    }
}

