/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Vector;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaComplexTypeWriter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.JavaHolderWriter;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Writer;
import org.w3c.dom.Node;

public class JavaTypeWriter
implements Writer {
    public static final String HOLDER_IS_NEEDED = "Holder is needed";
    private Writer typeWriter = null;
    private Writer holderWriter = null;

    public JavaTypeWriter(Emitter emitter, TypeEntry type, SymbolTable symbolTable) {
        if (type.isReferenced() && !type.isOnlyLiteralReferenced()) {
            Node node = type.getNode();
            if (!type.getName().endsWith("[]")) {
                Vector v = SchemaUtils.getComplexElementTypesAndNames(node, symbolTable);
                if (v != null) {
                    this.typeWriter = new JavaComplexTypeWriter(emitter, type, v, SchemaUtils.getComplexElementExtensionBase(node, symbolTable), SchemaUtils.getComplexElementAttributes(node, symbolTable));
                } else {
                    v = SchemaUtils.getEnumerationBaseAndValues(node, symbolTable);
                    if (v != null) {
                        this.typeWriter = new JavaEnumTypeWriter(emitter, type, v);
                    }
                }
            }
            if (this.holderIsNeeded(type)) {
                this.holderWriter = new JavaHolderWriter(emitter, type);
            }
        }
    }

    public void write() throws IOException {
        if (this.typeWriter != null) {
            this.typeWriter.write();
        }
        if (this.holderWriter != null) {
            this.holderWriter.write();
        }
    }

    private boolean holderIsNeeded(SymTabEntry entry) {
        Boolean holderIsNeeded = (Boolean)entry.getDynamicVar(HOLDER_IS_NEEDED);
        return holderIsNeeded != null && holderIsNeeded != false;
    }
}

