/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.QName;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.SymbolTable;

public class JavaUndeployWriter
extends JavaWriter {
    private Definition definition;
    private SymbolTable symbolTable;

    protected JavaUndeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, new QName(definition.getTargetNamespace(), "undeploy"), "", "wsdd", JavaUtils.getMessage("genUndeploy00"), "undeploy");
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    protected void writeFileHeader() throws IOException {
        this.initializeDeploymentDoc("undeploy");
    }

    protected void writeFileBody() throws IOException {
        this.writeDeployServices();
        this.pw.println("</undeployment>");
        this.pw.close();
    }

    private void writeDeployServices() throws IOException {
        Map serviceMap = this.definition.getServices();
        Iterator mapIterator = serviceMap.values().iterator();
        while (mapIterator.hasNext()) {
            Service myService = (Service)mapIterator.next();
            this.pw.println();
            this.pw.println("  <!-- " + JavaUtils.getMessage("wsdlService00", myService.getQName().getLocalPart()) + " -->");
            this.pw.println();
            Iterator portIterator = myService.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port myPort = (Port)portIterator.next();
                this.writeDeployPort(myPort);
            }
        }
    }

    private void writeDeployPort(Port port) throws IOException {
        Binding binding = port.getBinding();
        BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
        String serviceName = port.getName();
        this.pw.println("  <service name=\"" + serviceName + "\"/>");
    }
}

