/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.wsdl.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.axis.wsdl.toJava.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class JavaWriter
implements Writer {
    protected Emitter emitter;
    protected QName qname;
    protected Namespaces namespaces;
    protected String className;
    protected String fileName;
    protected String packageName;
    protected PrintWriter pw;
    protected String message;
    protected String type;
    private static HashMap TYPES = new HashMap(7);

    static {
        TYPES.put("int", "Integer");
        TYPES.put("float", "Float");
        TYPES.put("boolean", "Boolean");
        TYPES.put("double", "Double");
        TYPES.put("byte", "Byte");
        TYPES.put("short", "Short");
        TYPES.put("long", "Long");
    }

    protected JavaWriter(Emitter emitter, SymTabEntry entry, String suffix, String extension, String message, String type) {
        this.emitter = emitter;
        this.qname = entry.getQName();
        this.namespaces = emitter.getNamespaces();
        this.className = String.valueOf(Utils.getJavaLocalName(entry.getName())) + (suffix == null ? "" : suffix);
        this.fileName = String.valueOf(this.className) + '.' + extension;
        this.packageName = Utils.getJavaPackageName(entry.getName());
        this.message = message;
        this.type = type;
    }

    protected JavaWriter(Emitter emitter, QName qname, String suffix, String extension, String message, String type) {
        this.emitter = emitter;
        this.qname = qname;
        this.namespaces = emitter.getNamespaces();
        this.className = String.valueOf(qname.getLocalPart()) + (suffix == null ? "" : suffix);
        this.fileName = String.valueOf(this.className) + '.' + extension;
        this.packageName = this.namespaces.getCreate(qname.getNamespaceURI());
        this.message = message;
        this.type = type;
    }

    public void write() throws IOException {
        String packageDirName = this.namespaces.toDir(this.packageName);
        String path = String.valueOf(packageDirName) + this.fileName;
        String fqClass = String.valueOf(this.packageName) + "." + this.className;
        if (this.emitter.fileInfo.getClassNames().contains(fqClass)) {
            throw new IOException(JavaUtils.getMessage("duplicateClass00", fqClass));
        }
        if (this.emitter.fileInfo.getFileNames().contains(path)) {
            throw new IOException(JavaUtils.getMessage("duplicateFile00", path));
        }
        this.emitter.fileInfo.add(path, fqClass, this.type);
        this.namespaces.mkdir(this.packageName);
        File file = new File(packageDirName, this.fileName);
        if (this.emitter.bVerbose) {
            System.out.println(String.valueOf(this.message) + ":  " + file.getPath());
        }
        this.pw = new PrintWriter(new FileWriter(file));
        this.writeFileHeader();
        this.writeFileBody();
    }

    protected void writeFileHeader() throws IOException {
        this.pw.println("/**");
        this.pw.println(" * " + this.fileName);
        this.pw.println(" *");
        this.pw.println(" * " + JavaUtils.getMessage("wsdlGenLine00"));
        this.pw.println(" * " + JavaUtils.getMessage("wsdlGenLine01"));
        this.pw.println(" */");
        this.pw.println();
        this.pw.println("package " + this.packageName + ";");
        this.pw.println();
    }

    protected void writeComment(PrintWriter pw, Element element) {
        int LINE_LENGTH = 65;
        if (element == null) {
            return;
        }
        Node child = element.getFirstChild();
        if (child == null) {
            return;
        }
        String comment = child.getNodeValue();
        comment = comment.replace('\r', ' ');
        if ((comment = comment.replace('\n', ' ')) != null) {
            int start = 0;
            pw.println();
            pw.println("    /**");
            while (start < comment.length()) {
                int end = start + 65;
                if (end > comment.length()) {
                    end = comment.length();
                }
                while (end < comment.length() && !Character.isWhitespace(comment.charAt(end))) {
                    ++end;
                }
                pw.println("     * " + comment.substring(start, end).trim());
                start = end + 1;
            }
            pw.println("     */");
        }
    }

    protected String wrapPrimitiveType(TypeEntry type, String var) {
        String objType;
        String string = objType = type == null ? null : (String)TYPES.get(type.getName());
        if (objType != null) {
            return "new " + objType + "(" + var + ")";
        }
        if (type != null && type.getName().equals("byte[]") && type.getQName().getLocalPart().equals("hexBinary")) {
            return "new org.apache.axis.encoding.Hex(" + var + ")";
        }
        return var;
    }

    protected String getResponseString(TypeEntry type, String var) {
        if (type == null) {
            return ";";
        }
        String objType = (String)TYPES.get(type.getName());
        if (objType != null) {
            return "((" + objType + ") " + var + ")." + type.getName() + "Value();";
        }
        return "(" + type.getName() + ") " + var + ";";
    }

    protected boolean isPrimitiveType(TypeEntry type) {
        return TYPES.get(type.getName()) != null;
    }

    protected void initializeDeploymentDoc(String deploymentOpName) throws IOException {
        if ("deploy".equals(deploymentOpName)) {
            this.pw.println(JavaUtils.getMessage("deploy00"));
        } else {
            this.pw.println(JavaUtils.getMessage("deploy01"));
        }
        this.pw.println(JavaUtils.getMessage("deploy02"));
        if ("deploy".equals(deploymentOpName)) {
            this.pw.println(JavaUtils.getMessage("deploy03"));
        } else {
            this.pw.println(JavaUtils.getMessage("deploy04"));
        }
        this.pw.println(JavaUtils.getMessage("deploy05"));
        this.pw.println(JavaUtils.getMessage("deploy06"));
        if ("deploy".equals(deploymentOpName)) {
            this.pw.println(JavaUtils.getMessage("deploy07"));
        } else {
            this.pw.println(JavaUtils.getMessage("deploy08"));
        }
        this.pw.println(JavaUtils.getMessage("deploy09"));
        this.pw.println();
        if ("deploy".equals(deploymentOpName)) {
            this.pw.println("<deployment");
            this.pw.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\"");
            this.pw.println("    xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">");
        } else {
            this.pw.println("<undeployment");
            this.pw.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\">");
        }
    }

    protected boolean fileExists(String name, String namespace) throws IOException {
        String packageName = this.emitter.getNamespaces().getAsDir(namespace);
        String fullName = String.valueOf(packageName) + name;
        return new File(fullName).exists();
    }

    protected abstract void writeFileBody() throws IOException;
}

