/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.DefaultSOAP12TypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.BaseTypeMapping;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.Element;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaDefinitionWriter;
import org.apache.axis.wsdl.toJava.JavaServiceWriter;
import org.apache.axis.wsdl.toJava.JavaTypeWriter;
import org.apache.axis.wsdl.toJava.MessageEntry;
import org.apache.axis.wsdl.toJava.NoopWriter;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.axis.wsdl.toJava.Writer;
import org.apache.axis.wsdl.toJava.WriterFactory;

public class JavaWriterFactory
implements WriterFactory {
    private Emitter emitter;
    private SymbolTable symbolTable;
    BaseTypeMapping btm = null;

    public void writerPass(Definition def, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.javifyNames(symbolTable);
        this.resolveNameClashes(symbolTable);
        if (this.emitter.bGenerateAll) {
            this.setAllReferencesToTrue();
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        this.constructSignatures(symbolTable);
        this.determineIfHoldersNeeded(symbolTable);
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public Writer getWriter(Message message, SymbolTable symbolTable) {
        return new NoopWriter();
    }

    public Writer getWriter(PortType portType, SymbolTable symbolTable) {
        return new NoopWriter();
    }

    public Writer getWriter(Binding binding, SymbolTable symbolTable) {
        return new JavaBindingWriter(this.emitter, binding, symbolTable);
    }

    public Writer getWriter(Service service, SymbolTable symbolTable) {
        return new JavaServiceWriter(this.emitter, service, symbolTable);
    }

    public Writer getWriter(TypeEntry type, SymbolTable symbolTable) {
        return new JavaTypeWriter(this.emitter, type, symbolTable);
    }

    public Writer getWriter(Definition definition, SymbolTable symbolTable) {
        return new JavaDefinitionWriter(this.emitter, definition, symbolTable);
    }

    private void javifyNames(SymbolTable symbolTable) {
        int uniqueNum = 0;
        HashMap<javax.wsdl.QName, javax.wsdl.QName> anonQNames = new HashMap<javax.wsdl.QName, javax.wsdl.QName>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof TypeEntry) {
                    TypeEntry tEntry = (TypeEntry)entry;
                    String dims = tEntry.getDimensions();
                    TypeEntry refType = tEntry.getRefType();
                    while (refType != null) {
                        tEntry = refType;
                        dims = String.valueOf(dims) + tEntry.getDimensions();
                        refType = tEntry.getRefType();
                    }
                    javax.wsdl.QName typeQName = tEntry.getQName();
                    if (typeQName.getLocalPart().lastIndexOf(46) >= 0) {
                        String localName = typeQName.getLocalPart();
                        localName = localName.substring(localName.lastIndexOf(46) + 1);
                        if (symbolTable.getType(typeQName = new javax.wsdl.QName(typeQName.getNamespaceURI(), localName)) != null || anonQNames.get(typeQName) != null) {
                            localName = String.valueOf(localName) + "Type" + uniqueNum++;
                            typeQName = new javax.wsdl.QName(typeQName.getNamespaceURI(), localName);
                        }
                        anonQNames.put(typeQName, typeQName);
                    }
                    entry.setName(String.valueOf(symbolTable.getJavaName(typeQName)) + dims);
                } else {
                    entry.setName(symbolTable.getJavaName(entry.getQName()));
                }
                ++i;
            }
        }
    }

    private void resolveNameClashes(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            SymTabEntry entry;
            Vector<TypeEntry> v = new Vector<TypeEntry>((Vector)it.next());
            if (v.size() <= 1) continue;
            boolean resolve = true;
            if (v.size() == 2 && (v.elementAt(0) instanceof Element && v.elementAt(1) instanceof Type || v.elementAt(1) instanceof Element && v.elementAt(0) instanceof Type)) {
                Element e = null;
                e = v.elementAt(0) instanceof Element ? (Element)v.elementAt(0) : (Element)v.elementAt(1);
                javax.wsdl.QName eType = Utils.getNodeTypeRefQName(e.getNode(), "type");
                if (eType != null && eType.equals((Object)e.getQName())) {
                    resolve = false;
                }
            }
            if (resolve) {
                resolve = false;
                String name = null;
                int i = 0;
                while (i < v.size() && !resolve) {
                    entry = (SymTabEntry)v.elementAt(i);
                    if (!(entry instanceof MessageEntry) && !(entry instanceof BindingEntry)) {
                        if (name == null) {
                            name = entry.getName();
                        } else if (name.equals(entry.getName())) {
                            resolve = true;
                        }
                    }
                    ++i;
                }
            }
            if (!resolve) continue;
            boolean firstType = true;
            int i = 0;
            while (i < v.size()) {
                BindingEntry bEntry;
                entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof Element) {
                    entry.setName(this.mangleName(entry.getName(), "_ElemType"));
                    javax.wsdl.QName anonQName = new javax.wsdl.QName(entry.getQName().getNamespaceURI(), "." + entry.getQName().getLocalPart());
                    Type anonType = symbolTable.getType(anonQName);
                    if (anonType != null) {
                        anonType.setName(entry.getName());
                    }
                } else if (entry instanceof TypeEntry) {
                    if (firstType) {
                        firstType = false;
                        Vector types = symbolTable.getTypes();
                        int j = 0;
                        while (j < types.size()) {
                            TypeEntry type = (TypeEntry)types.elementAt(j);
                            if (type != entry && !(type instanceof Element) && type.getBaseType() == null && this.sameJavaClass(((Type)entry).getName(), type.getName())) {
                                v.add(type);
                            }
                            ++j;
                        }
                    }
                    entry.setName(this.mangleName(entry.getName(), "_Type"));
                } else if (entry instanceof PortTypeEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Port"));
                } else if (entry instanceof ServiceEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Service"));
                } else if (entry instanceof BindingEntry && (bEntry = (BindingEntry)entry).hasLiteral()) {
                    entry.setName(this.mangleName(entry.getName(), "_Binding"));
                }
                ++i;
            }
        }
    }

    private String mangleName(String name, String mangle) {
        int index = name.indexOf("[");
        if (index >= 0) {
            String pre = name.substring(0, index);
            String post = name.substring(index);
            return String.valueOf(pre) + mangle + post;
        }
        return String.valueOf(name) + mangle;
    }

    private boolean sameJavaClass(String one, String two) {
        int index1 = one.indexOf("[");
        int index2 = two.indexOf("[");
        if (index1 > 0) {
            one = one.substring(0, index1);
        }
        if (index2 > 0) {
            two = two.substring(0, index2);
        }
        return one.equals(two);
    }

    private void setAllReferencesToTrue() {
        Iterator it = this.symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry && ((BindingEntry)entry).getBindingType() != 0) {
                    entry.setIsReferenced(false);
                } else {
                    entry.setIsReferenced(true);
                }
                ++i;
            }
        }
    }

    private void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> unusedPortTypes = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> usedPortTypes = new Vector<PortTypeEntry>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    Binding binding = bEntry.getBinding();
                    PortType portType = binding.getPortType();
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
                    if (bEntry.getBindingType() == 0) {
                        usedPortTypes.add(ptEntry);
                        if (unusedPortTypes.contains(ptEntry)) {
                            unusedPortTypes.remove(ptEntry);
                        }
                    } else {
                        bEntry.setIsReferenced(false);
                        if (!usedPortTypes.contains(ptEntry)) {
                            unusedPortTypes.add(ptEntry);
                        }
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < unusedPortTypes.size()) {
            PortTypeEntry ptEntry = (PortTypeEntry)unusedPortTypes.get(i);
            ptEntry.setIsReferenced(false);
            ++i;
        }
    }

    private void constructSignatures(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    Binding binding = bEntry.getBinding();
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                    PortType portType = ptEntry.getPortType();
                    Iterator operations = portType.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        OperationType type = operation.getStyle();
                        String name = operation.getName();
                        Parameters parameters = bEntry.getParameters(operation);
                        if (type == OperationType.SOLICIT_RESPONSE) {
                            parameters.signature = "    // " + JavaUtils.getMessage("invalidSolResp00", name);
                            System.err.println(JavaUtils.getMessage("invalidSolResp00", name));
                            continue;
                        }
                        if (type == OperationType.NOTIFICATION) {
                            parameters.signature = "    // " + JavaUtils.getMessage("invalidNotif00", name);
                            System.err.println(JavaUtils.getMessage("invalidNotif00", name));
                            continue;
                        }
                        parameters.signature = this.constructSignature(parameters, name);
                    }
                }
                ++i;
            }
        }
    }

    private String constructSignature(Parameters parms, String opName) {
        String name = Utils.xmlNameToJava(opName);
        String ret = parms.returnType == null ? "void" : parms.returnType.getName();
        String signature = "    public " + ret + " " + name + "(";
        boolean needComma = false;
        int i = 0;
        while (i < parms.list.size()) {
            Parameter p = (Parameter)parms.list.get(i);
            if (needComma) {
                signature = String.valueOf(signature) + ", ";
            } else {
                needComma = true;
            }
            String javifiedName = Utils.xmlNameToJava(p.getName());
            signature = p.mode == 1 ? String.valueOf(signature) + p.type.getName() + " " + javifiedName : String.valueOf(signature) + Utils.holder(p.type, this.symbolTable) + " " + javifiedName;
            ++i;
        }
        signature = String.valueOf(signature) + ") throws java.rmi.RemoteException";
        if (parms.faultString != null) {
            signature = String.valueOf(signature) + ", " + parms.faultString;
        }
        return signature;
    }

    private void determineIfHoldersNeeded(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                if (v.get(i) instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)v.get(i);
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(bEntry.getBinding().getPortType().getQName());
                    Iterator operations = bEntry.getParameters().values().iterator();
                    while (operations.hasNext()) {
                        Parameters parms = (Parameters)operations.next();
                        int j = 0;
                        while (j < parms.list.size()) {
                            Parameter p = (Parameter)parms.list.get(j);
                            if (p.mode != 1) {
                                Type anonType;
                                p.type.setDynamicVar("Holder is needed", new Boolean(true));
                                javax.wsdl.QName anonQName = SchemaUtils.getElementAnonQName(p.type.getNode());
                                if (anonQName != null && (anonType = symbolTable.getType(anonQName)) != null) {
                                    anonType.setDynamicVar("Holder is needed", new Boolean(true));
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void setBaseTypeMapping(BaseTypeMapping btm) {
        this.btm = btm;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){
                TypeMapping defaultTM = DefaultSOAP12TypeMappingImpl.create();

                public String getBaseName(javax.wsdl.QName qNameIn) {
                    QName qName = new QName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                    Class cls = this.defaultTM.getClassForQName(qName);
                    if (cls == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(cls.getName());
                }
            };
        }
        return this.btm;
    }
}

