/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.util.Vector;
import javax.wsdl.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtils {
    public static Vector getComplexElementTypesAndNames(Node node, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            QName extensionKind;
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Node extension = null;
            int j = 0;
            while (j < children.getLength() && complexContent == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                    if (complexContentKind.getLocalPart().equals("complexContent")) {
                        complexContent = children.item(j);
                    } else if (complexContentKind.getLocalPart().equals("simpleContent")) {
                        simpleContent = children.item(j);
                    }
                }
                ++j;
            }
            if (complexContent != null) {
                children = complexContent.getChildNodes();
                j = 0;
                while (j < children.getLength() && extension == null) {
                    extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j);
                    }
                    ++j;
                }
            }
            if (simpleContent != null) {
                children = simpleContent.getChildNodes();
                j = 0;
                while (j < children.getLength() && extension == null) {
                    extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        QName extendsType = Utils.getNodeTypeRefQName(children.item(j), "base");
                        Vector<Object> v = new Vector<Object>();
                        v.add(symbolTable.getTypeEntry(extendsType, false));
                        v.add("value");
                        return v;
                    }
                    ++j;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            Node groupNode = null;
            int j2 = 0;
            while (j2 < children.getLength() && groupNode == null) {
                QName groupKind = Utils.getNodeQName(children.item(j2));
                if (groupKind != null && (groupKind.getLocalPart().equals("sequence") || groupKind.getLocalPart().equals("all")) && Constants.isSchemaXSD(groupKind.getNamespaceURI())) {
                    groupNode = children.item(j2);
                }
                ++j2;
            }
            if (groupNode == null) {
                return new Vector();
            }
            if (groupNode != null) {
                Vector v = new Vector();
                NodeList elements = groupNode.getChildNodes();
                int i = 0;
                while (i < elements.getLength()) {
                    QName elementKind = Utils.getNodeQName(elements.item(i));
                    if (elementKind != null && Constants.isSchemaXSD(elementKind.getNamespaceURI())) {
                        if (elementKind.getLocalPart().equals("element")) {
                            v.addAll(SchemaUtils.processChildElementNode(elements.item(i), symbolTable));
                        } else if (elementKind.getLocalPart().equals("choice")) {
                            Vector choiceElems = SchemaUtils.processChoiceNode(elements.item(i), symbolTable);
                            v.addAll(choiceElems);
                        }
                    }
                    ++i;
                }
                return v;
            }
        }
        return null;
    }

    private static Vector processChoiceNode(Node choiceNode, SymbolTable symbolTable) {
        Vector v = new Vector();
        NodeList children = choiceNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) {
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("group")) {
                    v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("element")) {
                    v.addAll(SchemaUtils.processChildElementNode(children.item(j), symbolTable));
                }
            }
            ++j;
        }
        return v;
    }

    private static Vector processSequenceNode(Node sequenceNode, SymbolTable symbolTable) {
        Vector v = new Vector();
        NodeList children = sequenceNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) {
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("group")) {
                    v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("element")) {
                    v.addAll(SchemaUtils.processChildElementNode(children.item(j), symbolTable));
                }
            }
            ++j;
        }
        return v;
    }

    private static Vector processGroupNode(Node groupNode, SymbolTable symbolTable) {
        Vector v = new Vector();
        NodeList children = groupNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) {
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                } else if (subNodeKind.getLocalPart().equals("all")) {
                    v.addAll(SchemaUtils.processAllNode(children.item(j), symbolTable));
                }
            }
            ++j;
        }
        return v;
    }

    private static Vector processAllNode(Node allNode, SymbolTable symbolTable) {
        Vector v = new Vector();
        NodeList children = allNode.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind != null && Constants.isSchemaXSD(subNodeKind.getNamespaceURI()) && subNodeKind.getLocalPart().equals("element")) {
                v.addAll(SchemaUtils.processChildElementNode(children.item(j), symbolTable));
            }
            ++j;
        }
        return v;
    }

    private static Vector processChildElementNode(Node elementNode, SymbolTable symbolTable) {
        TypeEntry type;
        Vector<Object> v = new Vector<Object>();
        QName nodeName = Utils.getNodeNameQName(elementNode);
        BooleanHolder forElement = new BooleanHolder();
        QName nodeType = Utils.getNodeTypeRefQName(elementNode, forElement);
        if (nodeType == null) {
            nodeType = SchemaUtils.getElementAnonQName(elementNode);
            forElement.value = false;
        }
        if ((type = symbolTable.getTypeEntry(nodeType, forElement.value)) != null) {
            v.add(type);
            v.add(nodeName.getLocalPart());
        }
        return v;
    }

    public static QName getElementAnonQName(Node node) {
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            NodeList children = node.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind != null && (kind.getLocalPart().equals("complexType") || kind.getLocalPart().equals("simpleType")) && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    return Utils.getNodeNameQName(children.item(j));
                }
                ++j;
            }
        }
        return null;
    }

    public static boolean isSimpleTypeOrSimpleContent(Node node) {
        NodeList children;
        if (node == null) {
            return false;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind != null && kind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                if (kind != null && kind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    return true;
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            return true;
        }
        if (nodeKind != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Object extension = null;
            int j = 0;
            while (j < children.getLength() && complexContent == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                    if (complexContentKind.getLocalPart().equals("complexContent")) {
                        complexContent = children.item(j);
                    } else if (complexContentKind.getLocalPart().equals("simpleContent")) {
                        simpleContent = children.item(j);
                    }
                }
                ++j;
            }
            if (complexContent != null) {
                return false;
            }
            if (simpleContent != null) {
                return true;
            }
        }
        return false;
    }

    public static TypeEntry getComplexElementExtensionBase(Node node, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            int j = 0;
            while (j < children.getLength() && content == null) {
                QName contentKind = Utils.getNodeQName(children.item(j));
                if (contentKind != null && contentKind.getLocalPart().equals("complexContent") && Constants.isSchemaXSD(contentKind.getNamespaceURI())) {
                    content = children.item(j);
                }
                if (contentKind != null && contentKind.getLocalPart().equals("simpleContent") && Constants.isSchemaXSD(contentKind.getNamespaceURI())) {
                    content = children.item(j);
                }
                ++j;
            }
            if (content != null) {
                children = content.getChildNodes();
                j = 0;
                while (j < children.getLength() && extension == null) {
                    QName extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j);
                    }
                    ++j;
                }
            }
            if (extension == null) {
                return null;
            }
            QName extendsType = Utils.getNodeTypeRefQName(extension, "base");
            if (extendsType == null) {
                return null;
            }
            return symbolTable.getType(extendsType);
        }
        return null;
    }

    public static Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable) {
        int j;
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            j = 0;
            while (j < children.getLength() && simpleNode == null) {
                QName simpleKind = Utils.getNodeQName(children.item(j));
                if (simpleKind != null && simpleKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(simpleKind.getNamespaceURI())) {
                    node = simpleNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            String javaName;
            QName baseType;
            children = node.getChildNodes();
            Node restrictionNode = null;
            j = 0;
            while (j < children.getLength() && restrictionNode == null) {
                QName restrictionKind = Utils.getNodeQName(children.item(j));
                if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                    restrictionNode = children.item(j);
                }
                ++j;
            }
            Type baseEType = null;
            if (!(restrictionNode == null || (baseEType = symbolTable.getType(baseType = Utils.getNodeTypeRefQName(restrictionNode, "base"))) == null || (javaName = baseEType.getName()).equals("java.lang.String") || javaName.equals("int") || javaName.equals("long") || javaName.equals("short") || javaName.equals("float") || javaName.equals("double") || javaName.equals("byte"))) {
                baseEType = null;
            }
            if (baseEType != null && restrictionNode != null) {
                Vector<Object> v = new Vector<Object>();
                NodeList enums = restrictionNode.getChildNodes();
                int i = 0;
                while (i < enums.getLength()) {
                    Node enumNode;
                    String value;
                    QName enumKind = Utils.getNodeQName(enums.item(i));
                    if (enumKind != null && enumKind.getLocalPart().equals("enumeration") && Constants.isSchemaXSD(enumKind.getNamespaceURI()) && (value = Utils.getAttribute(enumNode = enums.item(i), "value")) != null) {
                        v.add(value);
                    }
                    ++i;
                }
                if (v.isEmpty()) {
                    return null;
                }
                v.add(0, baseEType);
                return v;
            }
        }
        return null;
    }

    public static QName getSimpleTypeBase(Node node, SymbolTable symbolTable) {
        int j;
        NodeList children;
        QName baseQName = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            j = 0;
            while (j < children.getLength() && simpleNode == null) {
                QName simpleKind = Utils.getNodeQName(children.item(j));
                if (simpleKind != null && simpleKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(simpleKind.getNamespaceURI())) {
                    node = simpleNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node restrictionNode = null;
            j = 0;
            while (j < children.getLength() && restrictionNode == null) {
                QName restrictionKind = Utils.getNodeQName(children.item(j));
                if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                    restrictionNode = children.item(j);
                }
                ++j;
            }
            if (restrictionNode != null) {
                baseQName = Utils.getNodeTypeRefQName(restrictionNode, "base");
            }
            if (baseQName != null && restrictionNode != null) {
                NodeList enums = restrictionNode.getChildNodes();
                int i = 0;
                while (i < enums.getLength()) {
                    QName enumKind = Utils.getNodeQName(enums.item(i));
                    if (enumKind != null && enumKind.getLocalPart().equals("enumeration") && Constants.isSchemaXSD(enumKind.getNamespaceURI())) {
                        return null;
                    }
                    ++i;
                }
            }
        }
        return baseQName;
    }

    public static Node getRestrictionOrExtensionNode(Node node) {
        NodeList children;
        Node re = null;
        if (node == null) {
            return re;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node node2 = null;
            int j = 0;
            while (j < children.getLength() && node2 == null) {
                QName kind2 = Utils.getNodeQName(children.item(j));
                if (kind2 != null && (kind2.getLocalPart().equals("simpleType") || kind2.getLocalPart().equals("complexType") || kind2.getLocalPart().equals("simpleContent")) && Constants.isSchemaXSD(kind2.getNamespaceURI())) {
                    node = node2 = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && (nodeKind.getLocalPart().equals("simpleType") || nodeKind.getLocalPart().equals("complexType")) && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContent = null;
            Object extension = null;
            if (nodeKind.getLocalPart().equals("complexType")) {
                int j = 0;
                while (j < children.getLength() && complexContent == null) {
                    QName complexContentKind = Utils.getNodeQName(children.item(j));
                    if (complexContentKind != null && (complexContentKind.getLocalPart().equals("complexContent") || complexContentKind.getLocalPart().equals("simpleContent")) && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                        complexContent = children.item(j);
                    }
                    ++j;
                }
                node = complexContent;
            }
            if (node != null) {
                children = node.getChildNodes();
                int j = 0;
                while (j < children.getLength() && re == null) {
                    QName reKind = Utils.getNodeQName(children.item(j));
                    if (reKind != null && (reKind.getLocalPart().equals("extension") || reKind.getLocalPart().equals("restriction")) && Constants.isSchemaXSD(reKind.getNamespaceURI())) {
                        re = children.item(j);
                    }
                    ++j;
                }
            }
        }
        return re;
    }

    public static QName getArrayElementQName(Node node, IntHolder dims) {
        dims.value = 1;
        QName qName = SchemaUtils.getCollectionElementQName(node);
        if (qName == null) {
            qName = SchemaUtils.getArrayElementQName_JAXRPC(node, dims);
        }
        return qName;
    }

    private static QName getCollectionElementQName(Node node) {
        QName fullTypeQName;
        QName justTypeQName;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) && (justTypeQName = Utils.getNodeTypeRefQName(node, "type")) != null && justTypeQName != (fullTypeQName = Utils.getNodeTypeRefQName(node, new BooleanHolder()))) {
            return justTypeQName;
        }
        return null;
    }

    private static QName getArrayElementQName_JAXRPC(Node node, IntHolder dims) {
        int j;
        NodeList children;
        dims.value = 0;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContentNode = null;
            j = 0;
            while (j < children.getLength() && complexContentNode == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && (complexContentKind.getLocalPart().equals("complexContent") || complexContentKind.getLocalPart().equals("simpleContent")) && Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) {
                    complexContentNode = children.item(j);
                }
                ++j;
            }
            Node restrictionNode = null;
            if (complexContentNode != null) {
                children = complexContentNode.getChildNodes();
                int j2 = 0;
                while (j2 < children.getLength() && restrictionNode == null) {
                    QName restrictionKind = Utils.getNodeQName(children.item(j2));
                    if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                        restrictionNode = children.item(j2);
                    }
                    ++j2;
                }
            }
            QName baseType = null;
            if (!(restrictionNode == null || (baseType = Utils.getNodeTypeRefQName(restrictionNode, "base")) != null && baseType.getLocalPart().equals("Array") && Constants.isSOAP_ENC(baseType.getNamespaceURI()))) {
                baseType = null;
            }
            Node groupNode = null;
            Node attributeNode = null;
            if (baseType != null) {
                children = restrictionNode.getChildNodes();
                int j3 = 0;
                while (j3 < children.getLength() && groupNode == null && attributeNode == null) {
                    QName refQName;
                    QName kind = Utils.getNodeQName(children.item(j3));
                    if (kind != null && (kind.getLocalPart().equals("sequence") || kind.getLocalPart().equals("all")) && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                        groupNode = children.item(j3);
                    }
                    if (kind != null && kind.getLocalPart().equals("attribute") && Constants.isSchemaXSD(kind.getNamespaceURI()) && (refQName = Utils.getNodeTypeRefQName(children.item(j3), "ref")) != null && refQName.getLocalPart().equals("arrayType") && Constants.isSOAP_ENC(refQName.getNamespaceURI())) {
                        attributeNode = children.item(j3);
                    }
                    ++j3;
                }
            }
            if (attributeNode != null) {
                String wsdlArrayTypeValue = null;
                Vector attrs = Utils.getAttributesWithLocalName(attributeNode, "arrayType");
                int i = 0;
                while (i < attrs.size() && wsdlArrayTypeValue == null) {
                    Node attrNode = (Node)attrs.elementAt(i);
                    String attrName = attrNode.getNodeName();
                    QName attrQName = Utils.getQNameFromPrefixedName(attributeNode, attrName);
                    if (Constants.isWSDL(attrQName.getNamespaceURI())) {
                        wsdlArrayTypeValue = attrNode.getNodeValue();
                    }
                    ++i;
                }
                if (wsdlArrayTypeValue != null && (i = wsdlArrayTypeValue.indexOf(91)) > 0) {
                    String prefixedName = wsdlArrayTypeValue.substring(0, i);
                    String mangledString = wsdlArrayTypeValue.replace(',', '[');
                    dims.value = 0;
                    int index = mangledString.indexOf(91);
                    while (index > 0) {
                        ++dims.value;
                        index = mangledString.indexOf(91, index + 1);
                    }
                    return Utils.getQNameFromPrefixedName(restrictionNode, prefixedName);
                }
            } else if (groupNode != null) {
                String maxOccursValue;
                NodeList elements = groupNode.getChildNodes();
                Node elementNode = null;
                int i = 0;
                while (i < elements.getLength() && elementNode == null) {
                    QName elementKind = Utils.getNodeQName(elements.item(i));
                    if (elementKind != null && elementKind.getLocalPart().equals("element") && Constants.isSchemaXSD(elementKind.getNamespaceURI())) {
                        elementNode = elements.item(i);
                    }
                    ++i;
                }
                if (elementNode != null && (maxOccursValue = Utils.getAttribute(elementNode, "maxOccurs")) != null && maxOccursValue.equalsIgnoreCase("unbounded")) {
                    dims.value = 1;
                    return Utils.getNodeTypeRefQName(elementNode, "type");
                }
            }
        }
        return null;
    }

    public static Vector getComplexElementAttributes(Node node, SymbolTable symbolTable) {
        NodeList children;
        Vector<Object> v = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            int j = 0;
            while (j < children.getLength() && complexNode == null) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind != null && complexKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(complexKind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            int j = 0;
            while (j < children.getLength() && content == null) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind != null && Constants.isSchemaXSD(complexContentKind.getNamespaceURI()) && (complexContentKind.getLocalPart().equals("complexContent") || complexContentKind.getLocalPart().equals("simpleContent"))) {
                    content = children.item(j);
                }
                ++j;
            }
            if (content != null) {
                children = content.getChildNodes();
                j = 0;
                while (j < children.getLength()) {
                    QName extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j);
                        break;
                    }
                    ++j;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                nodeKind = Utils.getNodeQName(child);
                if (nodeKind != null && nodeKind.getLocalPart().equals("attribute")) {
                    if (v == null) {
                        v = new Vector<Object>();
                    }
                    QName typeAttr = Utils.getNodeTypeRefQName(child, "type");
                    TypeEntry type = symbolTable.getTypeEntry(typeAttr, false);
                    QName name = Utils.getNodeNameQName(child);
                    if (type != null && name != null) {
                        v.add(type);
                        v.add(name.getLocalPart());
                    }
                }
                ++i;
            }
        }
        return v;
    }
}

