/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.BaseType;
import org.apache.axis.wsdl.toJava.BaseTypeMapping;
import org.apache.axis.wsdl.toJava.BindingEntry;
import org.apache.axis.wsdl.toJava.CollectionType;
import org.apache.axis.wsdl.toJava.DefinedElement;
import org.apache.axis.wsdl.toJava.DefinedType;
import org.apache.axis.wsdl.toJava.Element;
import org.apache.axis.wsdl.toJava.MessageEntry;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.Parameter;
import org.apache.axis.wsdl.toJava.Parameters;
import org.apache.axis.wsdl.toJava.PortTypeEntry;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.ServiceEntry;
import org.apache.axis.wsdl.toJava.SymTabEntry;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.apache.axis.wsdl.toJava.Undefined;
import org.apache.axis.wsdl.toJava.UndefinedElement;
import org.apache.axis.wsdl.toJava.UndefinedType;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SymbolTable {
    private Namespaces namespaces;
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private Vector types = new Vector();
    private boolean debug = false;
    private BaseTypeMapping btm = null;
    private boolean wrapped = false;
    private HashSet importedFiles = new HashSet();
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public SymbolTable(Namespaces namespaces, BaseTypeMapping btm, boolean addImports, boolean debug) {
        this.namespaces = namespaces;
        this.btm = btm;
        this.addImports = addImports;
        this.debug = debug;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qname) {
        return (Vector)this.symbolTable.get(qname);
    }

    private SymTabEntry get(QName qname, Class cls) {
        Vector v = (Vector)this.symbolTable.get(qname);
        if (v == null) {
            return null;
        }
        int i = 0;
        while (i < v.size()) {
            SymTabEntry entry = (SymTabEntry)v.elementAt(i);
            if (cls.isInstance(entry)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public TypeEntry getTypeEntry(QName qname, boolean wantElementType) {
        if (wantElementType) {
            return this.getElement(qname);
        }
        return this.getType(qname);
    }

    public Type getType(QName qname) {
        int i = 0;
        while (i < this.types.size()) {
            TypeEntry type = (TypeEntry)this.types.get(i);
            if (type.getQName().equals((Object)qname) && type instanceof Type) {
                return (Type)type;
            }
            ++i;
        }
        return null;
    }

    public Element getElement(QName qname) {
        int i = 0;
        while (i < this.types.size()) {
            TypeEntry type = (TypeEntry)this.types.get(i);
            if (type.getQName().equals((Object)qname) && type instanceof Element) {
                return (Element)type;
            }
            ++i;
        }
        return null;
    }

    public MessageEntry getMessageEntry(QName qname) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.wsdl.toJava.MessageEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MessageEntry)this.get(qname, clazz);
    }

    public PortTypeEntry getPortTypeEntry(QName qname) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.axis.wsdl.toJava.PortTypeEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PortTypeEntry)this.get(qname, clazz);
    }

    public BindingEntry getBindingEntry(QName qname) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.apache.axis.wsdl.toJava.BindingEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BindingEntry)this.get(qname, clazz);
    }

    public ServiceEntry getServiceEntry(QName qname) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.apache.axis.wsdl.toJava.ServiceEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ServiceEntry)this.get(qname, clazz);
    }

    public Vector getTypes() {
        return this.types;
    }

    public void setNamespaceMap(HashMap map) {
        this.namespaces.putAll((Map)map);
    }

    public String getPackage(String namespace) {
        return this.namespaces.getCreate(namespace);
    }

    public String getPackage(QName qName) {
        return this.getPackage(qName.getNamespaceURI());
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public void dump(PrintStream out) {
        out.println();
        out.println(JavaUtils.getMessage("symbolTable00"));
        out.println("-----------------------");
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                out.println(v.elementAt(i).getClass().getName());
                out.println(v.elementAt(i));
                ++i;
            }
        }
        out.println("-----------------------");
    }

    protected void add(String context, Definition def, Document doc) throws IOException {
        this.checkForUndefined(def);
        URL contextURL = context == null ? null : SymbolTable.getURL(null, context);
        this.populate(contextURL, def, doc);
        this.checkForUndefined();
        this.populateParameters();
        this.setReferences(def, doc);
    }

    private void checkForUndefined(Definition def) throws IOException {
        if (def != null) {
            Iterator ib = def.getBindings().values().iterator();
            while (ib.hasNext()) {
                Binding binding = (Binding)ib.next();
                if (!binding.isUndefined()) continue;
                throw new IOException(JavaUtils.getMessage("emitFailtUndefinedBinding01", binding.getQName().getLocalPart()));
            }
            Iterator ip = def.getPortTypes().values().iterator();
            while (ip.hasNext()) {
                PortType portType = (PortType)ip.next();
                if (!portType.isUndefined()) continue;
                throw new IOException(JavaUtils.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                if (v.get(i) instanceof Undefined) {
                    throw new IOException(JavaUtils.getMessage("undefined00", "" + ((TypeEntry)v.get(i)).getQName()));
                }
                ++i;
            }
        }
    }

    private void populate(URL context, Definition def, Document doc) throws IOException {
        if (doc != null) {
            this.populateTypes(doc);
            if (def == null && this.addImports) {
                this.lookForImports(context, doc);
            }
        }
        if (def != null) {
            if (this.addImports) {
                Map imports = def.getImports();
                Object[] importKeys = imports.keySet().toArray();
                int i = 0;
                while (i < importKeys.length) {
                    Vector v = (Vector)imports.get(importKeys[i]);
                    int j = 0;
                    while (j < v.size()) {
                        Import imp = (Import)v.get(j);
                        if (!this.importedFiles.contains(imp.getLocationURI())) {
                            this.importedFiles.add(imp.getLocationURI());
                            URL url = SymbolTable.getURL(context, imp.getLocationURI());
                            this.populate(url, imp.getDefinition(), XMLUtils.newDocument(url.toString()));
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.populateMessages(def);
            this.populatePortTypes(def);
            this.populateBindings(def);
            this.populateServices(def);
        }
    }

    private static URL getURL(URL contextURL, String spec) throws IOException {
        URL url = null;
        try {
            url = new URL(contextURL, spec);
            try {
                url.openStream();
            }
            catch (IOException ioe) {
                throw new MalformedURLException();
            }
        }
        catch (MalformedURLException me) {
            url = new URL("file", "", spec);
            try {
                url.openStream();
            }
            catch (IOException ioe) {
                if (contextURL != null) {
                    String contextFileName = contextURL.getFile();
                    String string = new File(contextFileName).getParent();
                }
                throw new FileNotFoundException(url.toString());
            }
        }
        return url;
    }

    private void lookForImports(URL context, Node node) throws IOException {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            NamedNodeMap attributes;
            Node importFile;
            Node child = children.item(i);
            if ("import".equals(child.getLocalName()) && (importFile = (attributes = child.getAttributes()).getNamedItem("schemaLocation")) != null) {
                this.populate(context, null, XMLUtils.newDocument(SymbolTable.getURL(context, importFile.getNodeValue()).toString()));
            }
            this.lookForImports(context, child);
            ++i;
        }
    }

    private void populateTypes(Document doc) throws IOException {
        this.addTypes(doc, -1);
    }

    private void addTypes(Node node, int level) throws IOException {
        if (node == null) {
            return;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null) {
            Node re;
            String localPart = nodeKind.getLocalPart();
            boolean isXSD = Constants.isSchemaXSD(nodeKind.getNamespaceURI());
            if (isXSD && localPart.equals("complexType") || localPart.equals("simpleType")) {
                re = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (re != null && Utils.getAttribute(re, "base") != null) {
                    this.createTypeFromRef(re);
                }
                this.createTypeFromDef(node, false, false);
            } else if (isXSD && localPart.equals("element")) {
                if (Utils.getAttribute(node, "type") != null || Utils.getAttribute(node, "ref") != null) {
                    this.createTypeFromRef(node);
                }
                if ((re = SchemaUtils.getRestrictionOrExtensionNode(node)) != null && Utils.getAttribute(re, "base") != null) {
                    this.createTypeFromRef(re);
                }
                this.createTypeFromDef(node, true, level > 0);
            } else if (isXSD && localPart.equals("attribute")) {
                QName refQName;
                if (Utils.getAttribute(node, "type") != null) {
                    this.createTypeFromRef(node);
                }
                if ((refQName = Utils.getNodeTypeRefQName(node, "type")) != null) {
                    TypeEntry refType = this.getTypeEntry(refQName, false);
                    if (refType != null && refType instanceof Undefined) {
                        refType.setSimpleType(true);
                    } else if (refType == null || !(refType instanceof BaseType) && !refType.isSimpleType()) {
                        throw new IOException(JavaUtils.getMessage("AttrNotSimpleType01", refQName.toString()));
                    }
                }
            } else if (localPart.equals("part") && Constants.isWSDL(nodeKind.getNamespaceURI())) {
                this.createTypeFromRef(node);
            }
        }
        if (level == -1) {
            if (nodeKind != null && nodeKind.getLocalPart().equals("schema")) {
                level = 0;
            }
        } else {
            ++level;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.addTypes(children.item(i), level);
            ++i;
        }
    }

    private void createTypeFromDef(Node node, boolean isElement, boolean belowSchemaLevel) throws IOException {
        QName qName = Utils.getNodeNameQName(node);
        if (qName != null) {
            if (!isElement && this.btm.getBaseName(qName) != null) {
                return;
            }
            BooleanHolder forElement = new BooleanHolder();
            QName refQName = Utils.getNodeTypeRefQName(node, forElement);
            if (refQName != null) {
                TypeEntry refType = this.getTypeEntry(refQName, forElement.value);
                if (!belowSchemaLevel) {
                    this.symbolTablePut(new DefinedElement(qName, refType, node, ""));
                }
            } else {
                IntHolder numDims = new IntHolder();
                numDims.value = 0;
                QName arrayEQName = SchemaUtils.getArrayElementQName(node, numDims);
                QName simpleQName = SchemaUtils.getSimpleTypeBase(node, this);
                if (arrayEQName != null || simpleQName != null) {
                    refQName = arrayEQName != null ? arrayEQName : simpleQName;
                    TypeEntry refType = this.getTypeEntry(refQName, false);
                    if (refType == null) {
                        String baseName = this.btm.getBaseName(refQName);
                        refType = baseName != null ? new BaseType(refQName) : new UndefinedType(refQName);
                        this.symbolTablePut(refType);
                    }
                    String dims = "";
                    while (numDims.value > 0) {
                        dims = String.valueOf(dims) + "[]";
                        --numDims.value;
                    }
                    TypeEntry defType = null;
                    if (isElement) {
                        if (!belowSchemaLevel) {
                            defType = new DefinedElement(qName, refType, node, dims);
                        }
                    } else {
                        defType = new DefinedType(qName, refType, node, dims);
                    }
                    if (defType != null) {
                        if (simpleQName != null) {
                            defType.setSimpleType(true);
                        }
                        this.symbolTablePut(defType);
                    }
                } else {
                    String baseName = this.btm.getBaseName(qName);
                    if (baseName != null) {
                        this.symbolTablePut(new BaseType(qName));
                    } else {
                        TypeEntry te = null;
                        if (!isElement) {
                            te = new DefinedType(qName, node);
                        } else if (!belowSchemaLevel) {
                            te = new DefinedElement(qName, node);
                        }
                        if (te != null) {
                            if (SchemaUtils.isSimpleTypeOrSimpleContent(node)) {
                                te.setSimpleType(true);
                            }
                            this.symbolTablePut(te);
                        }
                    }
                }
            }
        }
    }

    private void createTypeFromRef(Node node) throws IOException {
        TypeEntry type;
        BooleanHolder forElement = new BooleanHolder();
        QName qName = Utils.getNodeTypeRefQName(node, forElement);
        if (qName != null && (type = this.getTypeEntry(qName, forElement.value)) == null) {
            if (qName.getLocalPart().indexOf("[") > 0) {
                QName typeAttr = Utils.getNodeTypeRefQName(node, "type");
                TypeEntry collEl = this.getTypeEntry(typeAttr, false);
                if (collEl == null) {
                    String baseName = this.btm.getBaseName(typeAttr);
                    collEl = baseName != null ? new BaseType(typeAttr) : new UndefinedType(typeAttr);
                    this.symbolTablePut(collEl);
                }
                this.symbolTablePut(new CollectionType(qName, collEl, node, "[]"));
            } else {
                String baseName = this.btm.getBaseName(qName);
                if (baseName != null) {
                    this.symbolTablePut(new BaseType(qName));
                } else if (!forElement.value) {
                    this.symbolTablePut(new UndefinedType(qName));
                } else {
                    this.symbolTablePut(new UndefinedElement(qName));
                }
            }
        }
    }

    public String getJavaName(QName qName) {
        if (qName.getLocalPart().indexOf("[") > 0) {
            String localPart = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["));
            QName eQName = new QName(qName.getNamespaceURI(), localPart);
            return String.valueOf(this.getJavaName(eQName)) + "[]";
        }
        if (qName.getNamespaceURI().equalsIgnoreCase("java")) {
            return qName.getLocalPart();
        }
        String fullJavaName = this.btm.getBaseName(qName);
        if (fullJavaName != null) {
            return fullJavaName;
        }
        String pkg = this.getPackage(qName.getNamespaceURI());
        fullJavaName = pkg != null ? String.valueOf(pkg) + "." + Utils.xmlNameToJavaClass(qName.getLocalPart()) : Utils.xmlNameToJavaClass(qName.getLocalPart());
        return fullJavaName;
    }

    private void populateMessages(Definition def) throws IOException {
        Iterator i = def.getMessages().values().iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            MessageEntry mEntry = new MessageEntry(message);
            this.symbolTablePut(mEntry);
        }
    }

    private void populatePortTypes(Definition def) throws IOException {
        Iterator i = def.getPortTypes().values().iterator();
        while (i.hasNext()) {
            PortType portType = (PortType)i.next();
            if (portType.isUndefined()) continue;
            PortTypeEntry ptEntry = new PortTypeEntry(portType);
            this.symbolTablePut(ptEntry);
        }
    }

    private void populateParameters() throws IOException {
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            int i = 0;
            while (i < v.size()) {
                if (v.get(i) instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)v.get(i);
                    Binding binding = bEntry.getBinding();
                    PortType portType = binding.getPortType();
                    HashMap<Operation, Parameters> parameters = new HashMap<Operation, Parameters>();
                    Iterator operations = portType.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        String namespace = portType.getQName().getNamespaceURI();
                        Parameters parms = this.getOperationParameters(operation, namespace, bEntry);
                        parameters.put(operation, parms);
                    }
                    bEntry.setParameters(parameters);
                }
                ++i;
            }
        }
    }

    public Parameters getOperationParameters(Operation operation, String namespace, BindingEntry bindingEntry) throws IOException {
        int i;
        Output output;
        Input input;
        Input input2;
        Parameters parameters = new Parameters();
        Vector inputs = new Vector();
        Vector outputs = new Vector();
        List parameterOrder = operation.getParameterOrdering();
        if (parameterOrder != null && parameterOrder.isEmpty()) {
            parameterOrder = null;
        }
        if (parameterOrder != null && (input2 = operation.getInput()) != null) {
            Message inputMsg = input2.getMessage();
            Map allInputs = inputMsg.getParts();
            List orderedInputs = inputMsg.getOrderedParts(parameterOrder);
            if (allInputs.size() != orderedInputs.size()) {
                throw new IOException(JavaUtils.getMessage("emitFail00", operation.getName()));
            }
        }
        boolean literalInput = false;
        boolean literalOutput = false;
        String bindingName = "unknown";
        if (bindingEntry != null) {
            literalInput = bindingEntry.getInputBodyType(operation) == 1;
            literalOutput = bindingEntry.getOutputBodyType(operation) == 1;
            bindingName = bindingEntry.getBinding().getQName().toString();
        }
        if ((input = operation.getInput()) != null) {
            this.partStrings(inputs, input.getMessage().getOrderedParts(null), literalInput, operation.getName(), bindingName);
        }
        if ((output = operation.getOutput()) != null) {
            this.partStrings(outputs, output.getMessage().getOrderedParts(null), literalOutput, operation.getName(), bindingName);
        }
        if (parameterOrder != null) {
            i = 0;
            while (i < parameterOrder.size()) {
                String name = (String)parameterOrder.get(i);
                int index = this.getPartIndex(name, inputs);
                int outdex = this.getPartIndex(name, outputs);
                if (index > 0) {
                    this.addInishParm(inputs, outputs, index, outdex, parameters, true);
                } else if (outdex > 0) {
                    this.addOutParm(outputs, outdex, parameters, true);
                } else {
                    System.err.println(JavaUtils.getMessage("noPart00", name));
                }
                ++i;
            }
        }
        i = 1;
        while (i < inputs.size()) {
            int outdex = this.getPartIndex((String)inputs.get(i), outputs);
            this.addInishParm(inputs, outputs, i, outdex, parameters, false);
            i += 2;
        }
        if (outputs.size() == 2) {
            parameters.returnType = (TypeEntry)outputs.get(0);
            parameters.returnName = parameters.returnType instanceof DefinedElement ? Utils.getAxisQName(((DefinedElement)parameters.returnType).getQName()) : new javax.xml.rpc.namespace.QName(null, (String)outputs.get(1));
            ++parameters.outputs;
        } else {
            i = 1;
            while (i < outputs.size()) {
                this.addOutParm(outputs, i, parameters, false);
                i += 2;
            }
        }
        Map faults = operation.getFaults();
        Iterator i2 = faults.values().iterator();
        while (i2.hasNext()) {
            Fault fault = (Fault)i2.next();
            String exceptionName = Utils.getFullExceptionName(fault, this, namespace);
            parameters.faultString = parameters.faultString == null ? exceptionName : String.valueOf(parameters.faultString) + ", " + exceptionName;
        }
        return parameters;
    }

    private int getPartIndex(String name, Vector v) {
        int i = 1;
        while (i < v.size()) {
            if (name.equals(v.get(i))) {
                return i;
            }
            i += 2;
        }
        return -1;
    }

    private void addInishParm(Vector inputs, Vector outputs, int index, int outdex, Parameters parameters, boolean trimInput) {
        Parameter p = new Parameter();
        p.type = (TypeEntry)inputs.get(index - 1);
        if (p.type instanceof DefinedElement) {
            DefinedElement de = (DefinedElement)p.type;
            p.setQName(de.getQName());
        } else {
            p.setName((String)inputs.get(index));
        }
        if (trimInput) {
            inputs.remove(index);
            inputs.remove(index - 1);
        }
        if (outdex > 0 && p.type.equals(outputs.get(outdex - 1))) {
            outputs.remove(outdex);
            outputs.remove(outdex - 1);
            p.mode = (byte)3;
            ++parameters.inouts;
        } else {
            ++parameters.inputs;
        }
        parameters.list.add(p);
    }

    private void addOutParm(Vector outputs, int outdex, Parameters parameters, boolean trim) {
        Parameter p = new Parameter();
        p.type = (TypeEntry)outputs.get(outdex - 1);
        if (p.type instanceof DefinedElement) {
            DefinedElement de = (DefinedElement)p.type;
            p.setQName(de.getQName());
        } else {
            p.setName((String)outputs.get(outdex));
        }
        if (trim) {
            outputs.remove(outdex);
            outputs.remove(outdex - 1);
        }
        p.mode = (byte)2;
        ++parameters.outputs;
        parameters.list.add(p);
    }

    protected void partStrings(Vector v, Collection parts, boolean literal, String opName, String bindingName) throws IOException {
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            QName type;
            Part part = (Part)i.next();
            QName elementName = part.getElementName();
            QName typeName = part.getTypeName();
            String partName = part.getName();
            if (literal && !i.hasNext() && partName.equals("parameters")) {
                this.wrapped = true;
            }
            if (!literal || !this.wrapped) {
                if (typeName != null) {
                    v.add(this.getType(typeName));
                    v.add(partName);
                    continue;
                }
                if (elementName == null) continue;
                v.add(this.getElement(elementName));
                v.add(partName);
                continue;
            }
            Node node = null;
            if (typeName != null && elementName == null) {
                throw new IOException(JavaUtils.getMessage("literalTypePart00", new String[]{partName, opName, bindingName}));
            }
            if (elementName != null && (type = Utils.getNodeTypeRefQName(node = this.getTypeEntry(elementName, true).getNode(), "type")) != null) {
                node = this.getTypeEntry(type, false).getNode();
            }
            if (node == null) continue;
            Vector vTypes = SchemaUtils.getComplexElementTypesAndNames(node, this);
            if (vTypes != null) {
                v.addAll(vTypes);
                continue;
            }
            if (typeName != null) {
                v.add(this.getType(typeName));
                v.add(partName);
                continue;
            }
            if (elementName == null) continue;
            v.add(this.getElement(elementName));
            v.add(partName);
        }
    }

    private void populateBindings(Definition def) throws IOException {
        Iterator i = def.getBindings().values().iterator();
        while (i.hasNext()) {
            int bindingStyle = 1;
            int bindingType = 3;
            Binding binding = (Binding)i.next();
            Iterator extensibilityElementsIterator = binding.getExtensibilityElements().iterator();
            while (extensibilityElementsIterator.hasNext()) {
                Object obj = extensibilityElementsIterator.next();
                if (obj instanceof SOAPBinding) {
                    bindingType = 0;
                    SOAPBinding sb = (SOAPBinding)obj;
                    String style = sb.getStyle();
                    if (!"rpc".equalsIgnoreCase(style)) continue;
                    bindingStyle = 0;
                    continue;
                }
                if (!(obj instanceof HTTPBinding)) continue;
                HTTPBinding hb = (HTTPBinding)obj;
                bindingType = hb.getVerb().equalsIgnoreCase("post") ? 2 : 1;
            }
            boolean hasLiteral = false;
            HashMap<Operation, BindingEntry.OperationAttr> attributes = new HashMap<Operation, BindingEntry.OperationAttr>();
            List bindList = binding.getBindingOperations();
            Iterator opIterator = bindList.iterator();
            while (opIterator.hasNext()) {
                String use;
                Object obj;
                int inputBodyType = 0;
                int outputBodyType = 0;
                BindingOperation bindOp = (BindingOperation)opIterator.next();
                if (bindOp.getBindingInput() != null && bindOp.getBindingInput().getExtensibilityElements() != null) {
                    Iterator inIter = bindOp.getBindingInput().getExtensibilityElements().iterator();
                    while (inIter.hasNext()) {
                        obj = inIter.next();
                        if (!(obj instanceof SOAPBody)) continue;
                        use = ((SOAPBody)obj).getUse();
                        if (!use.equalsIgnoreCase("literal")) break;
                        inputBodyType = 1;
                        break;
                    }
                }
                if (bindOp.getBindingOutput() != null && bindOp.getBindingOutput().getExtensibilityElements() != null) {
                    Iterator outIter = bindOp.getBindingOutput().getExtensibilityElements().iterator();
                    while (outIter.hasNext()) {
                        obj = outIter.next();
                        if (!(obj instanceof SOAPBody)) continue;
                        use = ((SOAPBody)obj).getUse();
                        if (!use.equalsIgnoreCase("literal")) break;
                        outputBodyType = 1;
                        break;
                    }
                }
                HashMap<String, Integer> faultMap = new HashMap<String, Integer>();
                Iterator faultMapIter = bindOp.getBindingFaults().values().iterator();
                while (faultMapIter.hasNext()) {
                    BindingFault bFault = (BindingFault)faultMapIter.next();
                    String faultName = bFault.getName();
                    int faultBodyType = 0;
                    Iterator faultIter = bFault.getExtensibilityElements().iterator();
                    while (faultIter.hasNext()) {
                        Object obj2 = faultIter.next();
                        if (!(obj2 instanceof SOAPBody)) continue;
                        String use2 = ((SOAPBody)obj2).getUse();
                        if (!use2.equalsIgnoreCase("literal")) break;
                        faultBodyType = 1;
                        break;
                    }
                    faultMap.put(faultName, new Integer(faultBodyType));
                }
                attributes.put(bindOp.getOperation(), new BindingEntry.OperationAttr(inputBodyType, outputBodyType, faultMap));
                if (inputBodyType != 1 && outputBodyType != 1) continue;
                hasLiteral = true;
            }
            BindingEntry bEntry = new BindingEntry(binding, bindingType, bindingStyle, hasLiteral, attributes);
            this.symbolTablePut(bEntry);
        }
    }

    private void populateServices(Definition def) throws IOException {
        Iterator i = def.getServices().values().iterator();
        while (i.hasNext()) {
            Service service = (Service)i.next();
            if (service.getQName() == null || service.getQName().getLocalPart() == null || service.getQName().getLocalPart().equals("")) {
                throw new IOException(JavaUtils.getMessage("BadServiceName00"));
            }
            ServiceEntry sEntry = new ServiceEntry(service);
            this.symbolTablePut(sEntry);
        }
    }

    private void setReferences(Definition def, Document doc) {
        Map stuff = def.getServices();
        if (stuff.isEmpty()) {
            stuff = def.getBindings();
            if (stuff.isEmpty()) {
                stuff = def.getPortTypes();
                if (stuff.isEmpty()) {
                    stuff = def.getMessages();
                    if (stuff.isEmpty()) {
                        int i = 0;
                        while (i < this.types.size()) {
                            TypeEntry type = (TypeEntry)this.types.get(i);
                            this.setTypeReferences(type, doc, false);
                            ++i;
                        }
                    } else {
                        Iterator i = stuff.values().iterator();
                        while (i.hasNext()) {
                            Message message = (Message)i.next();
                            MessageEntry mEntry = this.getMessageEntry(message.getQName());
                            this.setMessageReferences(mEntry, def, doc, false);
                        }
                    }
                } else {
                    Iterator i = stuff.values().iterator();
                    while (i.hasNext()) {
                        PortType portType = (PortType)i.next();
                        PortTypeEntry ptEntry = this.getPortTypeEntry(portType.getQName());
                        this.setPortTypeReferences(ptEntry, null, def, doc);
                    }
                }
            } else {
                Iterator i = stuff.values().iterator();
                while (i.hasNext()) {
                    Binding binding = (Binding)i.next();
                    BindingEntry bEntry = this.getBindingEntry(binding.getQName());
                    this.setBindingReferences(bEntry, def, doc);
                }
            }
        } else {
            Iterator i = stuff.values().iterator();
            while (i.hasNext()) {
                Service service = (Service)i.next();
                ServiceEntry sEntry = this.getServiceEntry(service.getQName());
                this.setServiceReferences(sEntry, def, doc);
            }
        }
    }

    private void setTypeReferences(TypeEntry entry, Document doc, boolean literal) {
        if (this.wrapped) {
            if (!entry.isReferenced() && literal) {
                entry.setOnlyLiteralReference(true);
            } else if (entry.isOnlyLiteralReferenced() && !literal) {
                entry.setOnlyLiteralReference(false);
            }
        }
        Node node = entry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == doc) {
            TypeEntry referent;
            BooleanHolder forElement;
            QName referentName;
            entry.setIsReferenced(true);
            if (entry instanceof DefinedElement && (referentName = Utils.getNodeTypeRefQName(node, forElement = new BooleanHolder())) != null && (referent = this.getTypeEntry(referentName, forElement.value)) != null) {
                this.setTypeReferences(referent, doc, literal);
            }
        }
        HashSet nestedTypes = Utils.getNestedTypes(node, this);
        Iterator it = nestedTypes.iterator();
        while (it.hasNext()) {
            TypeEntry nestedType = (TypeEntry)it.next();
            if (nestedType.isReferenced()) continue;
            this.setTypeReferences(nestedType, doc, false);
        }
    }

    private void setMessageReferences(MessageEntry entry, Definition def, Document doc, boolean literal) {
        Message message = entry.getMessage();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map messages = def.getMessages();
            if (messages.containsValue(message)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator parts = message.getParts().values().iterator();
        while (parts.hasNext()) {
            Part part = (Part)parts.next();
            TypeEntry type = this.getType(part.getTypeName());
            if (type != null) {
                this.setTypeReferences(type, doc, literal);
            }
            if ((type = this.getElement(part.getElementName())) == null) continue;
            this.setTypeReferences(type, doc, literal);
            TypeEntry refType = type.getRefType();
            if (refType == null) continue;
            this.setTypeReferences(refType, doc, literal);
        }
    }

    private void setPortTypeReferences(PortTypeEntry entry, BindingEntry bEntry, Definition def, Document doc) {
        PortType portType = entry.getPortType();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map portTypes = def.getPortTypes();
            if (portTypes.containsValue(portType)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator operations = portType.getOperations().iterator();
        while (operations.hasNext()) {
            MessageEntry mEntry;
            Message message;
            Operation operation = (Operation)operations.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean literalInput = false;
            boolean literalOutput = false;
            if (bEntry != null) {
                literalInput = bEntry.getInputBodyType(operation) == 1;
                boolean bl = literalOutput = bEntry.getOutputBodyType(operation) == 1;
            }
            if (input != null && (message = input.getMessage()) != null && (mEntry = this.getMessageEntry(message.getQName())) != null) {
                this.setMessageReferences(mEntry, def, doc, literalInput);
            }
            if (output != null && (message = output.getMessage()) != null && (mEntry = this.getMessageEntry(message.getQName())) != null) {
                this.setMessageReferences(mEntry, def, doc, literalOutput);
            }
            Iterator faults = operation.getFaults().values().iterator();
            while (faults.hasNext()) {
                MessageEntry mEntry2;
                Message message2 = ((Fault)faults.next()).getMessage();
                if (message2 == null || (mEntry2 = this.getMessageEntry(message2.getQName())) == null) continue;
                this.setMessageReferences(mEntry2, def, doc, false);
            }
        }
    }

    private void setBindingReferences(BindingEntry entry, Definition def, Document doc) {
        if (entry.getBindingType() == 0) {
            Binding binding = entry.getBinding();
            if (this.addImports) {
                entry.setIsReferenced(true);
            } else {
                Map bindings = def.getBindings();
                if (bindings.containsValue(binding)) {
                    entry.setIsReferenced(true);
                }
            }
            PortType portType = binding.getPortType();
            PortTypeEntry ptEntry = this.getPortTypeEntry(portType.getQName());
            if (ptEntry != null) {
                this.setPortTypeReferences(ptEntry, entry, def, doc);
            }
        }
    }

    private void setServiceReferences(ServiceEntry entry, Definition def, Document doc) {
        Service service = entry.getService();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map services = def.getServices();
            if (services.containsValue(service)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator ports = service.getPorts().values().iterator();
        while (ports.hasNext()) {
            Port port = (Port)ports.next();
            Binding binding = port.getBinding();
            BindingEntry bEntry = this.getBindingEntry(binding.getQName());
            if (bEntry == null) continue;
            this.setBindingReferences(bEntry, def, doc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void symbolTablePut(SymTabEntry entry) throws IOException {
        Vector<SymTabEntry> v;
        QName name = entry.getQName();
        if (this.get(name, entry.getClass()) != null) throw new IOException(JavaUtils.getMessage("alreadyExists00", "" + name));
        if (this.debug) {
            System.out.println("Symbol Table add " + name + " as " + entry.getClass().getName().substring(entry.getClass().getName().lastIndexOf(".") + 1));
        }
        if (entry instanceof Type) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.apache.axis.wsdl.toJava.UndefinedType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$4 = clazz2;
            }
            if (this.get(name, clazz) != null) {
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.apache.axis.wsdl.toJava.UndefinedType");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz3 = class$4 = clazz4;
                }
                if (((TypeEntry)this.get(name, clazz3)).isSimpleType() && !((TypeEntry)entry).isSimpleType()) {
                    throw new IOException(JavaUtils.getMessage("AttrNotSimpleType01", name.toString()));
                }
                Vector v2 = (Vector)this.symbolTable.get(name);
                int i = 0;
                while (true) {
                    if (i >= v2.size()) {
                        return;
                    }
                    Object oldEntry = v2.elementAt(i);
                    if (oldEntry instanceof UndefinedType) {
                        v2.setElementAt(entry, i);
                        int j = 0;
                        while (true) {
                            if (j >= this.types.size()) {
                                ((UndefinedType)oldEntry).update((Type)entry);
                                break;
                            }
                            if (this.types.elementAt(j) == oldEntry) {
                                this.types.setElementAt(entry, j);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        if (entry instanceof Element) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.apache.axis.wsdl.toJava.UndefinedElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$5 = clazz5;
            }
            if (this.get(name, clazz) != null) {
                Vector v3 = (Vector)this.symbolTable.get(name);
                int i = 0;
                while (true) {
                    if (i >= v3.size()) {
                        return;
                    }
                    Object oldEntry = v3.elementAt(i);
                    if (oldEntry instanceof UndefinedElement) {
                        v3.setElementAt(entry, i);
                        int j = 0;
                        while (true) {
                            if (j >= this.types.size()) {
                                ((Undefined)oldEntry).update((Element)entry);
                                break;
                            }
                            if (this.types.elementAt(j) == oldEntry) {
                                this.types.setElementAt(entry, j);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        if ((v = (Vector<SymTabEntry>)this.symbolTable.get(name)) == null) {
            v = new Vector<SymTabEntry>();
            this.symbolTable.put(name, v);
        }
        v.add(entry);
        if (!(entry instanceof TypeEntry)) return;
        this.types.add(entry);
    }
}

