/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.SchemaUtils;
import org.apache.axis.wsdl.toJava.SymbolTable;
import org.apache.axis.wsdl.toJava.Type;
import org.apache.axis.wsdl.toJava.TypeEntry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    public static String capitalizeFirstChar(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char start = name.charAt(0);
        if (Character.isLowerCase(start)) {
            start = Character.toUpperCase(start);
            return String.valueOf(start) + name.substring(1);
        }
        return name;
    }

    public static QName getNillableQName(QName qName) {
        QName rc = new QName(qName.getNamespaceURI(), qName.getLocalPart());
        if (Constants.isSchemaXSD(rc.getNamespaceURI())) {
            String localName = rc.getLocalPart();
            if (localName.equals("int") || localName.equals("long") || localName.equals("short") || localName.equals("float") || localName.equals("double") || localName.equals("boolean") || localName.equals("byte")) {
                rc.setNamespaceURI("http://schemas.xmlsoap.org/soap/encoding/");
            } else if (localName.equals("base64Binary") || localName.equals("hexBinary")) {
                rc.setNamespaceURI("http://schemas.xmlsoap.org/soap/encoding/");
                rc.setLocalPart("base64");
            }
        }
        return rc;
    }

    public static String getScopedAttribute(Node node, String attr) {
        if (node == null) {
            return null;
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), attr);
        }
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), attr);
    }

    public static String getAttribute(Node node, String attr) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String localName) {
        Vector<Node> v = new Vector<Node>();
        if (node == null) {
            return v;
        }
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int i = 0;
            while (i < map.getLength()) {
                Node attrNode = map.item(i);
                if (attrNode != null && attrNode.getLocalName().equals(localName)) {
                    v.add(attrNode);
                }
                ++i;
            }
        }
        return v;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String localName = node.getLocalName();
        if (localName == null) {
            return null;
        }
        String namespace = node.getNamespaceURI();
        return new QName(namespace, localName);
    }

    public static QName getNodeNameQName(Node node) {
        QName ref;
        if (node == null) {
            return null;
        }
        String localName = null;
        String namespace = null;
        localName = Utils.getAttribute(node, "name");
        if (localName == null && (ref = Utils.getNodeTypeRefQName(node, "ref")) != null) {
            localName = ref.getLocalPart();
            namespace = ref.getNamespaceURI();
        }
        if (localName == null) {
            localName = "";
            Node search = node.getParentNode();
            while (search != null) {
                QName kind = Utils.getNodeQName(search);
                if (kind.getLocalPart().equals("schema")) {
                    search = null;
                    continue;
                }
                if (kind.getLocalPart().equals("element")) {
                    localName = "." + Utils.getNodeNameQName(search).getLocalPart();
                    search = search.getParentNode();
                    continue;
                }
                if (kind.getLocalPart().equals("complexType") || kind.getLocalPart().equals("simpleType")) {
                    localName = String.valueOf(Utils.getNodeNameQName(search).getLocalPart()) + localName;
                    search = null;
                    continue;
                }
                search = search.getParentNode();
            }
        }
        if (localName == null) {
            return null;
        }
        if (namespace == null) {
            namespace = Utils.getScopedAttribute(node, "targetNamespace");
        }
        return new QName(namespace, localName);
    }

    public static QName getNodeTypeRefQName(Node node, BooleanHolder forElement) {
        if (node == null) {
            return null;
        }
        forElement.value = false;
        QName qName = Utils.getNodeTypeRefQName(node, "type");
        if (qName != null) {
            String maxOccursValue = Utils.getAttribute(node, "maxOccurs");
            String minOccursValue = Utils.getAttribute(node, "minOccurs");
            if (maxOccursValue == null) {
                maxOccursValue = "1";
            }
            if (minOccursValue == null) {
                minOccursValue = "1";
            }
            if (minOccursValue.equals("0") && maxOccursValue.equals("1")) {
                qName = Utils.getNillableQName(qName);
            } else if (!maxOccursValue.equals("1") || !minOccursValue.equals("1")) {
                String localPart = qName.getLocalPart();
                localPart = String.valueOf(localPart) + "[" + maxOccursValue + "]";
                qName.setLocalPart(localPart);
            }
        }
        if (qName == null) {
            forElement.value = true;
            qName = Utils.getNodeTypeRefQName(node, "ref");
        }
        if (qName == null) {
            forElement.value = true;
            qName = Utils.getNodeTypeRefQName(node, "element");
        }
        if (qName == null) {
            forElement.value = false;
            qName = Utils.getNodeTypeRefQName(node, "base");
        }
        return qName;
    }

    public static QName getNodeTypeRefQName(Node node, String typeAttrName) {
        String nillable;
        if (node == null) {
            return null;
        }
        String prefixedName = Utils.getAttribute(node, typeAttrName);
        if (prefixedName == null) {
            return null;
        }
        QName qName = Utils.getQNameFromPrefixedName(node, prefixedName);
        if (typeAttrName.equals("type") && (nillable = Utils.getAttribute(node, "nillable")) != null && nillable.equalsIgnoreCase("true")) {
            qName = Utils.getNillableQName(qName);
        }
        return qName;
    }

    public static QName getQNameFromPrefixedName(Node node, String prefixedName) {
        String localName = prefixedName.substring(prefixedName.lastIndexOf(":") + 1);
        String namespace = null;
        namespace = prefixedName.length() == localName.length() ? Utils.getScopedAttribute(node, "xmlns") : Utils.getScopedAttribute(node, "xmlns:" + prefixedName.substring(0, prefixedName.lastIndexOf(":")));
        return new QName(namespace, localName);
    }

    public static String xmlNameToJava(String name) {
        return JavaUtils.xmlNameToJava(name);
    }

    public static String xmlNameToJavaClass(String name) {
        return Utils.capitalizeFirstChar(Utils.xmlNameToJava(name));
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        try {
            hostname = new URL(namespace).getHost();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        StringTokenizer st = new StringTokenizer(hostname, ".");
        String[] words = new String[st.countTokens()];
        int i = 0;
        while (i < words.length) {
            words[i] = st.nextToken();
            ++i;
        }
        StringBuffer sb = new StringBuffer(80);
        int i2 = words.length - 1;
        while (i2 >= 0) {
            String word = words[i2];
            if (JavaUtils.isJavaKeyword(word)) {
                word = JavaUtils.makeNonJavaKeyword(word);
            }
            if (i2 != words.length - 1) {
                sb.append('.');
            }
            if (Character.isDigit(word.charAt(0))) {
                sb.append('_');
            }
            sb.append(word);
            --i2;
        }
        return sb.toString();
    }

    public static String holder(TypeEntry type, SymbolTable symbolTable) {
        String typeValue = type.getName();
        if (typeValue.equals("byte[]")) {
            return "javax.xml.rpc.holders.ByteArrayHolder";
        }
        if (typeValue.equals("java.lang.Byte[]")) {
            return "javax.xml.rpc.holders.ByteWrapperArrayHolder";
        }
        if (typeValue.endsWith("[]")) {
            String name = symbolTable.getJavaName(type.getQName());
            name = JavaUtils.replace(name, "[]", "Array");
            return String.valueOf(name) + "Holder";
        }
        if (typeValue.equals("String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (typeValue.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (typeValue.equals("Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (typeValue.equals("java.lang.Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (typeValue.equals("int") || typeValue.equals("long") || typeValue.equals("short") || typeValue.equals("float") || typeValue.equals("double") || typeValue.equals("boolean") || typeValue.equals("byte")) {
            return "javax.xml.rpc.holders." + Utils.capitalizeFirstChar(typeValue) + "Holder";
        }
        if (typeValue.startsWith("java.lang.")) {
            return "javax.xml.rpc.holders" + typeValue.substring(typeValue.lastIndexOf(".")) + "WrapperHolder";
        }
        if (typeValue.indexOf(".") < 0) {
            return "javax.xml.rpc.holders" + typeValue + "WrapperHolder";
        }
        if (typeValue.equals("java.math.BigDecimal")) {
            return "javax.xml.rpc.holders.BigDecimalHolder";
        }
        if (typeValue.equals("java.math.BigInteger")) {
            return "javax.xml.rpc.holders.BigIntegerHolder";
        }
        if (typeValue.equals("java.util.Date")) {
            return "javax.xml.rpc.holders.DateHolder";
        }
        if (typeValue.equals("java.util.Calendar")) {
            return "javax.xml.rpc.holders.CalendarHolder";
        }
        if (typeValue.equals("javax.xml.rpc.namespace.QName")) {
            return "javax.xml.rpc.holders.QNameHolder";
        }
        return String.valueOf(typeValue) + "Holder";
    }

    public static String getExceptionName(Fault fault) {
        String exceptionName;
        Message faultMessage = fault.getMessage();
        if (faultMessage != null) {
            String faultMessageName = faultMessage.getQName().getLocalPart();
            exceptionName = Utils.xmlNameToJavaClass(faultMessageName);
        } else {
            exceptionName = Utils.xmlNameToJavaClass(fault.getName());
        }
        return exceptionName;
    }

    public static String getFullExceptionName(Fault fault, SymbolTable symbolTable, String namespace) {
        String exceptionName;
        Message faultMessage = fault.getMessage();
        if (faultMessage != null) {
            String faultName = faultMessage.getQName().getLocalPart();
            QName qname = new QName(namespace, faultName);
            exceptionName = symbolTable.getJavaName(qname);
        } else {
            exceptionName = Utils.xmlNameToJavaClass(fault.getName());
        }
        return exceptionName;
    }

    public static HashSet getNestedTypes(Node type, SymbolTable symbolTable) {
        HashSet types = new HashSet();
        Utils.getNestedTypes(type, types, symbolTable);
        return types;
    }

    private static void getNestedTypes(Node type, HashSet types, SymbolTable symbolTable) {
        QName elementQName;
        Type elementType;
        TypeEntry extendType;
        Type anonType;
        QName anonQName;
        int i;
        Vector v = SchemaUtils.getComplexElementTypesAndNames(type, symbolTable);
        if (v != null) {
            i = 0;
            while (i < v.size()) {
                if (!types.contains(v.get(i))) {
                    types.add(v.get(i));
                    Utils.getNestedTypes(((TypeEntry)v.get(i)).getNode(), types, symbolTable);
                }
                i += 2;
            }
        }
        if ((v = SchemaUtils.getComplexElementAttributes(type, symbolTable)) != null) {
            i = 0;
            while (i < v.size()) {
                if (!types.contains(v.get(i))) {
                    types.add(v.get(i));
                    Utils.getNestedTypes(((TypeEntry)v.get(i)).getNode(), types, symbolTable);
                }
                i += 2;
            }
        }
        if ((anonQName = SchemaUtils.getElementAnonQName(type)) != null && (anonType = symbolTable.getType(anonQName)) != null && !types.contains(anonType)) {
            types.add(anonType);
        }
        if ((extendType = SchemaUtils.getComplexElementExtensionBase(type, symbolTable)) != null && !types.contains(extendType)) {
            types.add(extendType);
            Utils.getNestedTypes(extendType.getNode(), types, symbolTable);
        }
        if ((elementType = symbolTable.getType(elementQName = SchemaUtils.getArrayElementQName(type, new IntHolder(0)))) != null && !types.contains(elementType)) {
            types.add(elementType);
            Utils.getNestedTypes(elementType.getNode(), types, symbolTable);
        }
    }

    public static String getJavaLocalName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public static String getJavaPackageName(String fullName) {
        if (fullName.lastIndexOf(46) > 0) {
            return fullName.substring(0, fullName.lastIndexOf(46));
        }
        return "";
    }

    public static String getNewQName(javax.xml.rpc.namespace.QName qname) {
        return "new javax.xml.rpc.namespace.QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\")";
    }

    public static javax.xml.rpc.namespace.QName getAxisQName(QName qname) {
        return new javax.xml.rpc.namespace.QName(qname.getNamespaceURI(), qname.getLocalPart());
    }
}

