/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.SubjectDomainCombiner;

public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    Set principals;
    transient Set pubCredentials;
    transient Set privCredentials;
    private boolean readOnly = false;
    private static final int PRINCIPAL_SET = 1;
    private static final int PUB_CREDENTIAL_SET = 2;
    private static final int PRIV_CREDENTIAL_SET = 3;

    public Subject() {
        this.principals = new SecureSet(1);
        this.pubCredentials = new SecureSet(2);
        this.privCredentials = new SecureSet(3);
    }

    public Subject(boolean readOnly, Set principals, Set pubCredentials, Set privCredentials) {
        if (principals == null || pubCredentials == null || privCredentials == null) {
            throw new NullPointerException("invalid null input(s)");
        }
        this.principals = new SecureSet(1, principals);
        this.pubCredentials = new SecureSet(2, pubCredentials);
        this.privCredentials = new SecureSet(3, privCredentials);
        this.readOnly = readOnly;
    }

    public void setReadOnly() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Subject getSubject(final AccessControlContext acc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getSubject"));
        }
        if (acc == null) {
            throw new NullPointerException("invalid null AccessControlContext provided");
        }
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DomainCombiner dc = acc.getDomainCombiner();
                if (!(dc instanceof SubjectDomainCombiner)) {
                    return null;
                }
                SubjectDomainCombiner sdc = (SubjectDomainCombiner)dc;
                return sdc.getSubject();
            }
        });
    }

    public static Object doAs(Subject subject, PrivilegedAction action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAs"));
        }
        if (action == null) {
            throw new NullPointerException("invalid null action provided");
        }
        AccessControlContext currentAcc = AccessController.getContext();
        return AccessController.doPrivileged(action, Subject.createContext(subject, currentAcc));
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAs"));
        }
        if (action == null) {
            throw new NullPointerException("invalid null action provided");
        }
        AccessControlContext currentAcc = AccessController.getContext();
        return AccessController.doPrivileged(action, Subject.createContext(subject, currentAcc));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (action == null) {
            throw new NullPointerException("invalid null action provided");
        }
        AccessControlContext callerAcc = acc == null ? new AccessControlContext(new ProtectionDomain[0]) : acc;
        return AccessController.doPrivileged(action, Subject.createContext(subject, callerAcc));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (action == null) {
            throw new NullPointerException("invalid null action provided");
        }
        AccessControlContext callerAcc = acc == null ? new AccessControlContext(new ProtectionDomain[0]) : acc;
        return AccessController.doPrivileged(action, Subject.createContext(subject, callerAcc));
    }

    private static AccessControlContext createContext(final Subject subject, final AccessControlContext acc) {
        return (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (subject == null) {
                    return new AccessControlContext(acc, null);
                }
                return new AccessControlContext(acc, new SubjectDomainCombiner(subject));
            }
        });
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public Set getPrincipals(Class c) {
        if (c == null) {
            throw new NullPointerException("invalid null Class provided");
        }
        return new ClassSet(1, c);
    }

    public Set getPublicCredentials() {
        return this.pubCredentials;
    }

    public Set getPrivateCredentials() {
        return this.privCredentials;
    }

    public Set getPublicCredentials(Class c) {
        if (c == null) {
            throw new NullPointerException("invalid null Class provided");
        }
        return new ClassSet(2, c);
    }

    public Set getPrivateCredentials(Class c) {
        if (c == null) {
            throw new NullPointerException("invalid null Class provided");
        }
        return new ClassSet(3, c);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof Subject) {
            Subject that = (Subject)o;
            return this.getPrincipals().equals(that.getPrincipals()) && this.getPublicCredentials().equals(that.getPublicCredentials()) && this.getPrivateCredentials().equals(that.getPrivateCredentials());
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    /*
     * Unable to fully structure code
     */
    String toString(boolean includePrivateCredentials) {
        block8: {
            s = new String("Subject:\n");
            suffix = new String();
            principals = this.getPrincipals().iterator();
            pubCreds = this.getPublicCredentials().iterator();
            privCreds = null;
            if (includePrivateCredentials) {
                try {
                    privCreds = this.getPrivateCredentials().iterator();
                }
                catch (SecurityException se) {}
            }
            while (principals.hasNext()) {
                p = (Principal)principals.next();
                suffix = suffix + "\tPrincipal: " + p.toString() + "\n";
            }
            while (pubCreds.hasNext()) {
                o = pubCreds.next();
                suffix = suffix + "\tPublic Credential: " + o.toString() + "\n";
            }
            if (privCreds != null) ** GOTO lbl29
            suffix = suffix + "\tPrivate Credentials inaccessible\n";
            break block8;
lbl-1000:
            // 1 sources

            {
                try {
                    o = privCreds.next();
                    suffix = suffix + "\tPrivate Credential: " + o.toString() + "\n";
                    continue;
                }
                catch (SecurityException se) {
                    suffix = suffix + "\tPrivate Credential inaccessible\n";
                    break;
                }
lbl29:
                // 2 sources

                ** while (privCreds.hasNext())
            }
        }
        return s + suffix;
    }

    public int hashCode() {
        int hashCode = 0;
        Iterator pIterator = this.getPrincipals().iterator();
        Iterator pubCIterator = this.getPublicCredentials().iterator();
        Iterator privCIterator = this.getPrivateCredentials().iterator();
        while (pIterator.hasNext()) {
            Principal p = (Principal)pIterator.next();
            hashCode ^= p.hashCode();
        }
        while (pubCIterator.hasNext()) {
            hashCode ^= this.getCredHashCode(pubCIterator.next());
        }
        return hashCode;
    }

    private int getCredHashCode(Object o) {
        try {
            return o.hashCode();
        }
        catch (IllegalStateException ise) {
            return o.getClass().toString().hashCode();
        }
    }

    private void sort(int[] sortMe) {
        int i = 0;
        boolean flipped = true;
        int size = sortMe.length - 1;
        while (flipped) {
            i = 0;
            flipped = false;
            while (i < size) {
                if (sortMe[i] < sortMe[i + 1]) {
                    flipped = true;
                    int tmp = sortMe[i];
                    sortMe[i] = sortMe[i + 1];
                    sortMe[i + 1] = tmp;
                }
                ++i;
            }
            --size;
        }
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.pubCredentials = new SecureSet(2);
        this.privCredentials = new SecureSet(3);
    }

    private class ClassSet
    extends AbstractSet {
        private int which;
        private Set set;
        private Class c;

        ClassSet(int which, Class c) {
            ClassSet classSet = this;
            synchronized (classSet) {
                this.which = which;
                this.c = c;
                Iterator iterator = null;
                switch (which) {
                    case 1: {
                        iterator = Subject.this.principals.iterator();
                        break;
                    }
                    case 2: {
                        iterator = Subject.this.pubCredentials.iterator();
                        break;
                    }
                    default: {
                        iterator = Subject.this.privCredentials.iterator();
                    }
                }
                Iterator iterator_copy = iterator;
                SecurityManager sm = System.getSecurityManager();
                this.set = new HashSet();
                while (iterator_copy.hasNext()) {
                    Object next = AccessController.doPrivileged(new PrivilegedAction(this, iterator_copy){
                        private final /* synthetic */ Iterator val$iterator_copy;
                        private final /* synthetic */ ClassSet this$1;
                        {
                            this.this$1 = this$1;
                            this.val$iterator_copy = val$iterator_copy;
                        }

                        public Object run() {
                            return this.val$iterator_copy.next();
                        }
                    });
                    if (!c.isAssignableFrom(next.getClass())) continue;
                    if (which != 3) {
                        this.set.add(next);
                        continue;
                    }
                    if (sm != null) {
                        if (Subject.this.getPrincipals() == null || Subject.this.getPrincipals().size() == 0) {
                            sm.checkPermission(new PrivateCredentialPermission(next.getClass().getName(), new HashSet()));
                        } else {
                            sm.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(next.getClass().getName(), Subject.this.getPrincipals()), "read"));
                        }
                    }
                    this.set.add(next);
                }
            }
        }

        public synchronized int size() {
            return this.set.size();
        }

        public Iterator iterator() {
            return this.set.iterator();
        }

        public synchronized boolean add(Object o) {
            if (!o.getClass().isAssignableFrom(this.c)) {
                MessageFormat form = new MessageFormat("attempting to add an object which is not an instance of class");
                Object[] source = new Object[]{this.c.toString()};
                throw new SecurityException(form.format(source));
            }
            return this.set.add(o);
        }
    }

    private class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        LinkedList elements;
        private int which;

        SecureSet(int which) {
            this.which = which;
            this.elements = new LinkedList();
        }

        SecureSet(int which, Set set) {
            this.which = which;
            this.elements = new LinkedList(set);
        }

        public synchronized int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            LinkedList list = this.elements;
            return new Iterator(this, list){
                ListIterator i;
                private final /* synthetic */ LinkedList val$list;
                private final /* synthetic */ SecureSet this$1;
                {
                    this.this$1 = this$1;
                    this.val$list = val$list;
                    this.i = this.val$list.listIterator(0);
                }

                public synchronized boolean hasNext() {
                    return this.i.hasNext();
                }

                public synchronized Object next() {
                    if (SecureSet.access$000(this.this$1) != 3) {
                        return this.i.next();
                    }
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        try {
                            if (SecureSet.access$100(this.this$1).getPrincipals() == null || SecureSet.access$100(this.this$1).getPrincipals().size() == 0) {
                                sm.checkPermission(new PrivateCredentialPermission(this.val$list.get(this.i.nextIndex()).getClass().getName(), new HashSet<E>()));
                            } else {
                                sm.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(this.val$list.get(this.i.nextIndex()).getClass().getName(), SecureSet.access$100(this.this$1).getPrincipals()), "read"));
                            }
                        }
                        catch (SecurityException se) {
                            this.i.next();
                            throw se;
                        }
                    }
                    return this.i.next();
                }

                public synchronized void remove() {
                    if (SecureSet.access$100(this.this$1).isReadOnly()) {
                        throw new IllegalStateException("Subject is read-only");
                    }
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        switch (SecureSet.access$000(this.this$1)) {
                            case 1: {
                                sm.checkPermission(new AuthPermission("modifyPrincipals"));
                                break;
                            }
                            case 2: {
                                sm.checkPermission(new AuthPermission("modifyPublicCredentials"));
                                break;
                            }
                            default: {
                                sm.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                            }
                        }
                    }
                    this.i.remove();
                }
            };
        }

        public synchronized boolean add(Object o) {
            if (Subject.this.isReadOnly()) {
                throw new IllegalStateException("Subject is read-only");
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                switch (this.which) {
                    case 1: {
                        sm.checkPermission(new AuthPermission("modifyPrincipals"));
                        break;
                    }
                    case 2: {
                        sm.checkPermission(new AuthPermission("modifyPublicCredentials"));
                        break;
                    }
                    default: {
                        sm.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (o instanceof Principal) break;
                    throw new SecurityException("attempting to add an object which is not an instance of java.security.Principal to a Subject's Principal Set");
                }
            }
            if (!this.elements.contains(o)) {
                return this.elements.add(o);
            }
            return false;
        }

        public synchronized boolean remove(Object o) {
            Iterator e = this.iterator();
            while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction(this, e){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                if (next == null) {
                    if (o != null) continue;
                    e.remove();
                    return true;
                }
                if (!next.equals(o)) continue;
                e.remove();
                return true;
            }
            return false;
        }

        public synchronized boolean contains(Object o) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && this.which == 3) {
                if (Subject.this.getPrincipals() == null || Subject.this.getPrincipals().size() == 0) {
                    sm.checkPermission(new PrivateCredentialPermission(o.getClass().getName(), new HashSet()));
                } else {
                    sm.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(o.getClass().getName(), Subject.this.getPrincipals()), "read"));
                }
            }
            Iterator e = this.iterator();
            while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction(this, e){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                if (!(next == null ? o == null : next.equals(o))) continue;
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator e = this.iterator();
            block0: while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction(this, e){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                Iterator ce = c.iterator();
                while (ce.hasNext()) {
                    Object o = ce.next();
                    if (next == null) {
                        if (o != null) continue;
                        e.remove();
                        modified = true;
                        continue block0;
                    }
                    if (!next.equals(o)) continue;
                    e.remove();
                    modified = true;
                    continue block0;
                }
            }
            return modified;
        }

        public boolean retainAll(Collection c) {
            boolean modified = false;
            boolean retain = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                retain = false;
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction(this, e){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                Iterator ce = c.iterator();
                while (ce.hasNext()) {
                    Object o = ce.next();
                    if (next == null) {
                        if (o != null) continue;
                        retain = true;
                        break;
                    }
                    if (!next.equals(o)) continue;
                    retain = true;
                    break;
                }
                if (retain) continue;
                e.remove();
                retain = false;
                modified = true;
            }
            return modified;
        }

        public void clear() {
            Iterator e = this.iterator();
            while (e.hasNext()) {
                Object next = this.which != 3 ? e.next() : AccessController.doPrivileged(new PrivilegedAction(this, e){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public Object run() {
                        return this.val$e.next();
                    }
                });
                e.remove();
            }
        }

        private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
            if (this.which == 3) {
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    i.next();
                }
            }
            oos.defaultWriteObject();
        }

        static /* synthetic */ int access$000(SecureSet x0) {
            return x0.which;
        }

        static /* synthetic */ Subject access$100(SecureSet x0) {
            return x0.Subject.this;
        }
    }
}

